/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.events;

import com.mojang.blaze3d.platform.InputConstants;
import com.ninni.species.client.inventory.CruncherInventoryMenu;
import com.ninni.species.client.inventory.CruncherInventoryScreen;
import com.ninni.species.registry.SpeciesBannerPatterns;
import com.ninni.species.registry.SpeciesPaintingVariants;
import com.ninni.species.server.entity.mob.update_2.Cruncher;
import com.ninni.species.server.packet.OpenCruncherScreenPacket;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ClientEventsHandler {
    public static void openCruncherScreen(OpenCruncherScreenPacket packet) {
        Minecraft client = Minecraft.m_91087_();
        ClientLevel level = client.f_91073_;
        Optional.ofNullable(level).ifPresent(world -> {
            Entity entity = world.m_6815_(packet.getId());
            if (entity instanceof Cruncher) {
                Cruncher cruncher = (Cruncher)entity;
                int slotCount = packet.getSlotCount();
                int syncId = packet.getSyncId();
                LocalPlayer clientPlayerEntity = client.f_91074_;
                SimpleContainer simpleInventory = new SimpleContainer(slotCount);
                assert (clientPlayerEntity != null);
                CruncherInventoryMenu cruncherInventoryMenu = new CruncherInventoryMenu(syncId, clientPlayerEntity.m_150109_(), (Container)simpleInventory, cruncher);
                clientPlayerEntity.f_36096_ = cruncherInventoryMenu;
                client.execute(() -> client.m_91152_((Screen)new CruncherInventoryScreen(cruncherInventoryMenu, clientPlayerEntity.m_150109_(), cruncher)));
            }
        });
    }

    public static boolean isValidKey(InputConstants.Key key) {
        return key.m_84868_() == InputConstants.Type.KEYSYM && key.m_84873_() > 0;
    }

    public static ItemStack getHopefulBannerInstance() {
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42660_);
        CompoundTag compoundtag = new CompoundTag();
        ListTag listtag = new BannerPattern.Builder().m_222705_(SpeciesBannerPatterns.VILLAGER.getKey(), DyeColor.WHITE).m_58587_();
        compoundtag.m_128365_("Patterns", (Tag)listtag);
        BlockItem.m_186338_((ItemStack)itemstack, (BlockEntityType)BlockEntityType.f_58935_, (CompoundTag)compoundtag);
        itemstack.m_41654_(ItemStack.TooltipPart.ADDITIONAL);
        itemstack.m_41714_((Component)Component.m_237115_((String)"block.species.hopeful_banner").m_130940_(ChatFormatting.GREEN));
        return itemstack;
    }

    public static ItemStack getSpeciesPainting(PaintingVariant variant) {
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42487_);
        SpeciesPaintingVariants.PAINTING_VARIANTS.getEntries().forEach(variantRegistry -> {
            if (((PaintingVariant)variantRegistry.get()).equals(variant)) {
                CompoundTag compoundtag = itemStack.m_41698_("EntityTag");
                Painting.m_269220_((CompoundTag)compoundtag, (Holder)((Holder)variantRegistry.getHolder().get()));
            }
        });
        return itemStack;
    }
}

