/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.platform.forge;

import com.mojang.brigadier.CommandDispatcher;
import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.network.PingS2CPacket;
import dev.emi.emi.platform.EmiMain;
import dev.emi.emi.platform.forge.EmiPacketHandler;
import dev.emi.emi.registry.EmiCommands;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod(value="emi")
public class EmiForge {
    public EmiForge() {
        EmiMain.init();
        EmiPacketHandler.init();
        EmiNetwork.initServer((player, packet) -> EmiPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), packet));
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::playerConnect);
    }

    public void registerCommands(RegisterCommandsEvent event) {
        EmiCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public void playerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer spe = (ServerPlayer)player;
            EmiNetwork.sendToClient(spe, new PingS2CPacket());
        }
    }
}

