/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.utils;

import com.mongoose.clanginghowl.client.particles.BloodSplashParticleOption;
import com.mongoose.clanginghowl.common.capabilities.CHCapHelper;
import com.mongoose.clanginghowl.common.entities.CHEntityType;
import com.mongoose.clanginghowl.common.network.CHNetwork;
import com.mongoose.clanginghowl.common.network.server.SInstaLookPacket;
import com.mongoose.clanginghowl.init.CHSounds;
import com.mongoose.clanginghowl.init.CHTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;

public class MobUtil {
    public static final Predicate<Entity> LIVING_OR_PART = entity -> {
        PartEntity partEntity;
        return entity.m_6084_() && (entity instanceof LivingEntity || entity instanceof PartEntity && (partEntity = (PartEntity)entity).getParent() instanceof LivingEntity);
    };

    public static boolean areAllies(@Nullable Entity entity, @Nullable Entity entity1) {
        if (entity != null && entity1 != null) {
            return entity.m_7307_(entity1) || entity1.m_7307_(entity) || entity == entity1;
        }
        return false;
    }

    public static void instaLook(Mob mob, Vec3 vec3) {
        mob.m_21563_().m_24950_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 200.0f, (float)mob.m_8132_());
        double d2 = vec3.f_82479_ - mob.m_20185_();
        double d1 = vec3.f_82481_ - mob.m_20189_();
        float rotate = -((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f;
        mob.m_146922_(rotate);
        mob.f_20883_ = rotate;
        mob.f_20885_ = rotate;
    }

    public static void instaLook(Mob looker, Entity target) {
        MobUtil.instaLook(looker, target, false);
    }

    public static void instaLook(Mob looker, Entity target, boolean clientSent) {
        looker.m_21391_(target, 100.0f, 100.0f);
        MobUtil.instaLook(looker, target.m_20182_());
        if (clientSent && !looker.m_9236_().f_46443_) {
            CHNetwork.sendToALL(new SInstaLookPacket(looker, target));
        }
    }

    public static boolean isWalking(LivingEntity livingEntity) {
        return livingEntity.m_20096_() && MobUtil.isMoving(livingEntity);
    }

    public static boolean isMoving(LivingEntity livingEntity) {
        return livingEntity.m_20184_().m_165925_() > 2.500000277905201E-7;
    }

    public static BlockHitResult rayTrace(Entity entity, double distance, boolean fluids) {
        return (BlockHitResult)entity.m_19907_(distance, 1.0f, fluids);
    }

    public static boolean isInSunlight(Entity entity) {
        if (entity.m_9236_().m_46461_() && !entity.m_9236_().f_46443_) {
            float f = entity.m_213856_();
            BlockPos blockpos = BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20188_(), (double)entity.m_20189_());
            boolean flag = entity.m_20071_() || entity.f_146808_ || entity.f_146809_;
            return f > 0.5f && !flag && entity.m_9236_().m_45527_(blockpos);
        }
        return false;
    }

    public static void knockBack(Entity knocked, Entity knocker, double xPower, double yPower, double zPower) {
        Player player;
        double d;
        Vec3 vec3 = new Vec3(knocker.m_20185_() - knocked.m_20185_(), knocker.m_20186_() - knocked.m_20186_(), knocker.m_20189_() - knocked.m_20189_()).m_82541_();
        double pY0 = Math.max(-vec3.f_82480_, yPower);
        Vec3 vec31 = new Vec3(-vec3.f_82479_ * xPower, pY0, -vec3.f_82481_ * zPower);
        if (knocked instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)knocked;
            d = livingEntity.m_21133_(Attributes.f_22278_);
        } else {
            d = 0.0;
        }
        double resist = d;
        double resist1 = Math.max(0.0, 1.0 - resist);
        if (knocked instanceof Player && EntitySelector.f_20406_.test(player = (Player)knocked)) {
            player.f_19864_ = true;
            if (!player.m_9236_().f_46443_) {
                player.m_6853_(false);
            }
        }
        knocked.m_20256_(knocked.m_20184_().m_82549_(vec31).m_82490_(resist1));
        knocked.f_19812_ = true;
    }

    public static List<Entity> getTargets(Level level, LivingEntity pSource, double pRange, double pRadius) {
        return MobUtil.getTargets(level, pSource, pRange, pRadius, EntitySelector.f_20406_.and(LIVING_OR_PART).and(entity -> !MobUtil.areAllies(entity, (Entity)pSource)));
    }

    public static List<Entity> getTargets(Level level, LivingEntity pSource, double pRange, double pRadius, Predicate<? super Entity> predicate) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        Vec3 srcVec = pSource.m_146892_();
        Vec3 lookVec = pSource.m_20252_(1.0f);
        double[] lookRange = new double[]{lookVec.m_7096_() * pRange, lookVec.m_7098_() * pRange, lookVec.m_7094_() * pRange};
        Vec3 destVec = srcVec.m_82520_(lookRange[0], lookRange[1], lookRange[2]);
        List possibleList = level.m_6249_((Entity)pSource, pSource.m_20191_().m_82363_(lookRange[0], lookRange[1], lookRange[2]).m_82377_(pRadius, pRadius, pRadius), predicate);
        double hitDist = 0.0;
        for (Entity hit : possibleList) {
            double possibleDist;
            if (!hit.m_6087_() && !(hit instanceof ItemEntity) && !(hit instanceof Projectile) || !pSource.m_142582_(hit) || hit == pSource) continue;
            float maxSize = pSource instanceof Mob ? 2.0f : 0.8f;
            float borderSize = Math.max(maxSize, hit.m_6143_());
            AABB collisionBB = hit.m_20191_().m_82400_((double)borderSize);
            Optional interceptPos = collisionBB.m_82371_(srcVec, destVec);
            if (collisionBB.m_82390_(srcVec)) {
                if (!(0.0 <= hitDist)) continue;
                list.add(hit);
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.m_82554_((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            list.add(hit);
            hitDist = possibleDist;
        }
        return list;
    }

    public static void buffTechnoFlesh(ServerLevel serverLevel, LivingEntity livingEntity) {
        int buff = Mth.m_14143_((float)((float)serverLevel.m_46467_() / 24000.0f));
        if (buff >= 1 && buff < 1000) {
            float increase = 0.005f * (float)buff + 1.0f;
            AttributeInstance health = livingEntity.m_21051_(Attributes.f_22276_);
            AttributeInstance attack = livingEntity.m_21051_(Attributes.f_22281_);
            AttributeInstance armor = livingEntity.m_21051_(Attributes.f_22284_);
            if (health != null) {
                health.m_22100_(health.m_22115_() * (double)increase);
                livingEntity.m_5634_((float)health.m_22115_());
            }
            if (attack != null) {
                attack.m_22100_(attack.m_22115_() * (double)increase);
            }
            if (armor != null) {
                armor.m_22100_(armor.m_22115_() * (double)increase);
            }
            if (CHCapHelper.getTechnoResist(livingEntity) < 65.0f) {
                CHCapHelper.setTechnoResist(livingEntity, CHCapHelper.getTechnoResist(livingEntity) + (float)buff);
            }
        }
    }

    public static boolean isTechnoConvert(LivingEntity livingEntity) {
        return livingEntity.m_6095_().m_204039_(CHTags.EntityTypes.TECHNO_CONVERT) || MobUtil.isHoDConvert(livingEntity) || MobUtil.isReaperConvert(livingEntity);
    }

    public static boolean isHoDConvert(LivingEntity livingEntity) {
        return (double)livingEntity.m_21233_() <= 25.0 && (livingEntity.m_6095_().m_204039_(CHTags.EntityTypes.HOD_CONVERT) || livingEntity instanceof Animal || livingEntity instanceof Spider);
    }

    public static boolean isReaperConvert(LivingEntity livingEntity) {
        return livingEntity.m_6095_().m_204039_(CHTags.EntityTypes.REAPER_CONVERT) || livingEntity instanceof AbstractVillager || livingEntity instanceof AbstractIllager || livingEntity instanceof Witch || livingEntity instanceof Zombie;
    }

    public static void convertTechno(Mob original) {
        Level level = original.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Monster convert = null;
            if (MobUtil.isHoDConvert((LivingEntity)original)) {
                convert = (Monster)original.m_21406_((EntityType)CHEntityType.HEART_OF_DECAY.get(), false);
            }
            if (MobUtil.isReaperConvert((LivingEntity)original)) {
                convert = serverLevel.m_213780_().m_188499_() ? (Monster)original.m_21406_((EntityType)CHEntityType.FLESH_MAIDEN.get(), false) : (Monster)original.m_21406_((EntityType)CHEntityType.EX_REAPER.get(), false);
            }
            if (convert != null) {
                convert.m_21219_();
                ForgeEventFactory.onFinalizeSpawn((Mob)convert, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.m_6436_(convert.m_20183_()), (MobSpawnType)MobSpawnType.CONVERSION, null, null);
                serverLevel.m_8767_((ParticleOptions)new BloodSplashParticleOption((float)convert.m_20191_().m_82309_() * 2.0f, 0), convert.m_20185_(), convert.m_20186_() + 1.0, convert.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_6263_(null, convert.m_20185_(), convert.m_20186_(), convert.m_20189_(), (SoundEvent)CHSounds.FLESH_RUPTURE_ENDING.get(), convert.m_5720_(), 2.0f, 1.0f);
            }
        }
    }
}

