/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.utils;

import com.mongoose.clanginghowl.ClangingHowl;
import com.mongoose.clanginghowl.utils.NoKnockBackDamageSource;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CHDamageSource
extends DamageSource {
    public static ResourceKey<DamageType> LIGHTNING = CHDamageSource.create("lightning");
    public static ResourceKey<DamageType> FIRE_STREAM = CHDamageSource.create("fire_stream");
    public static ResourceKey<DamageType> NEUROTOXIN = CHDamageSource.create("neurotoxin");
    public static ResourceKey<DamageType> ICICLE = CHDamageSource.create("icicle");

    public CHDamageSource(Holder<DamageType> p_270906_, @Nullable Entity p_270796_, @Nullable Entity p_270459_, @Nullable Vec3 p_270623_) {
        super(p_270906_, p_270796_, p_270459_, p_270623_);
    }

    public static ResourceKey<DamageType> create(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)ClangingHowl.location(name));
    }

    public static DamageSource getDamageSource(Level level, ResourceKey<DamageType> type) {
        return CHDamageSource.getEntityDamageSource(level, type, null);
    }

    public static DamageSource source(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker, @Nullable Entity indirectAttacker) {
        return new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(type), attacker, indirectAttacker);
    }

    public static DamageSource noKnockbackDamageSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker, @Nullable Entity indirectAttacker) {
        return new NoKnockBackDamageSource((Holder<DamageType>)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(type), attacker, indirectAttacker);
    }

    public static DamageSource getEntityDamageSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker) {
        return CHDamageSource.indirectEntityDamageSource(level, type, attacker, attacker);
    }

    public static DamageSource indirectEntityDamageSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker, @Nullable Entity indirectAttacker) {
        return CHDamageSource.source(level, type, attacker, indirectAttacker);
    }

    public static DamageSource lightning(Entity pSource, @Nullable Entity pIndirectEntity) {
        return CHDamageSource.indirectEntityDamageSource(pSource.m_9236_(), LIGHTNING, pSource, pIndirectEntity);
    }

    public static DamageSource fireStream(Entity pSource, @Nullable Entity pIndirectEntity) {
        return CHDamageSource.noKnockbackDamageSource(pSource.m_9236_(), FIRE_STREAM, pSource, pIndirectEntity);
    }

    public static boolean physicalAttacks(DamageSource source) {
        return source.m_7640_() != null && source.m_7640_() instanceof LivingEntity && (source.m_19385_().equals("mob") || source.m_19385_().equals("sting") || source.m_19385_().equals("player"));
    }

    public static String source(String source) {
        return "clanginghowl." + source;
    }

    public static void bootstrap(BootstapContext<DamageType> context) {
        context.m_255272_(LIGHTNING, (Object)new DamageType("clanginghowl.lightning", 0.0f));
        context.m_255272_(FIRE_STREAM, (Object)new DamageType("clanginghowl.fire_stream", 0.0f, DamageEffects.BURNING));
        context.m_255272_(NEUROTOXIN, (Object)new DamageType("clanginghowl.neurotoxin", 0.0f));
        context.m_255272_(ICICLE, (Object)new DamageType("clanginghowl.icicle", 0.0f, DamageEffects.FREEZING));
    }
}

