/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.data;

import com.mongoose.clanginghowl.ClangingHowl;
import com.mongoose.clanginghowl.common.blocks.CHBlocks;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class CHBlockStateProvider
extends BlockStateProvider {
    public CHBlockStateProvider(PackOutput gen, ExistingFileHelper exFileHelper) {
        super(gen, "clanginghowl", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlockWithItem((Block)CHBlocks.SMOOTH_EXTRATERRESTRIAL_STONE.get());
        this.simpleBlockWithItem((Block)CHBlocks.EXTRATERRESTRIAL_STONE_BRICKS.get());
        this.simpleBlockWithItem((Block)CHBlocks.CARVED_EXTRATERRESTRIAL_STONE_BRICKS.get());
        this.simpleBlockWithItem((Block)CHBlocks.RAW_EXTRATERRESTRIAL_STEEL_BLOCK.get());
        this.simpleBlockWithItem((Block)CHBlocks.EXTRATERRESTRIAL_STEEL_BLOCK.get());
        this.simpleBlockWithItem((Block)CHBlocks.STEEL_PLATE_BLOCK.get());
        this.simpleBlockWithItem((Block)CHBlocks.DAMAGED_STEEL_PLATE_BLOCK.get());
        this.simpleBlockWithItem((Block)CHBlocks.METEORITE_STEEL_ORE.get());
        this.simpleBlockWithItem((Block)CHBlocks.EXTRATERRESTRIAL_STEEL_ORE.get());
        this.simpleBlockWithItem((Block)CHBlocks.CALCITE_TILES.get());
        this.simpleBlockWithItem((Block)CHBlocks.CRACKED_CALCITE_TILES.get());
        this.simpleBlockWithItem((Block)CHBlocks.FROZEN_TECHNOFLESH_BLOCK.get());
        this.simpleBlockWithItem((Block)CHBlocks.TECHNOFLESH_NEST.get());
        this.crossBlockWithItem((Block)CHBlocks.CRYOGENIC_ICICLE.get());
        this.crossBlockWithItem((Block)CHBlocks.HANGING_TECHNOFLESH.get());
        this.doorBlockWithRenderType((DoorBlock)CHBlocks.STEEL_DOOR.get(), ClangingHowl.location("block/steel_door_bottom"), ClangingHowl.location("block/steel_door_top"), "translucent");
        this.sideBottomTopColumnBlock((RotatedPillarBlock)CHBlocks.CARVED_STEEL_PLATE_BLOCK.get(), ClangingHowl.location("block/carved_steel_plate_block_top"), ClangingHowl.location("block/carved_steel_plate_block"), ClangingHowl.location("block/carved_steel_plate_block_bottom"));
        this.sideBottomTopColumnBlock((RotatedPillarBlock)CHBlocks.DAMAGED_CARVED_STEEL_PLATE_BLOCK.get(), ClangingHowl.location("block/damaged_carved_steel_plate_block_top"), ClangingHowl.location("block/damaged_carved_steel_plate_block"), ClangingHowl.location("block/damaged_carved_steel_plate_block_bottom"));
        this.columnBlockWithItem((RotatedPillarBlock)CHBlocks.EXTRATERRESTRIAL_COLUMN.get(), ClangingHowl.location("block/extraterrestrial_column"), ClangingHowl.location("block/extraterrestrial_column_top"));
        this.columnBlockWithItem((RotatedPillarBlock)CHBlocks.TUBULAR_TECHNOFLESH.get(), ClangingHowl.location("block/tubular_technoflesh"), ClangingHowl.location("block/tubular_technoflesh_top"));
        this.slabBlockWithItem((SlabBlock)CHBlocks.EXTRATERRESTRIAL_STONE_SLAB.get(), ClangingHowl.location("block/extraterrestrial_stone"));
        this.slabBlockWithItem((SlabBlock)CHBlocks.SMOOTH_EXTRATERRESTRIAL_STONE_SLAB.get(), ClangingHowl.location("block/smooth_extraterrestrial_stone"));
        this.slabBlockWithItem((SlabBlock)CHBlocks.EXTRATERRESTRIAL_STONE_BRICK_SLAB.get(), ClangingHowl.location("block/extraterrestrial_stone_bricks"));
        this.slabBlockWithItem((SlabBlock)CHBlocks.CARVED_STEEL_PLATE_SLAB.get(), ClangingHowl.location("block/carved_steel_plate_block"));
        this.slabBlockWithItem((SlabBlock)CHBlocks.CALCITE_TILE_SLAB.get(), ClangingHowl.location("block/calcite_tiles"));
        this.slabBlockWithItem((SlabBlock)CHBlocks.TECHNOFLESH_SLAB.get(), ClangingHowl.location("block/technoflesh_block_ordinary"));
        this.stairsBlockWithItem((StairBlock)CHBlocks.EXTRATERRESTRIAL_STONE_STAIRS.get(), ClangingHowl.location("block/extraterrestrial_stone"));
        this.stairsBlockWithItem((StairBlock)CHBlocks.SMOOTH_EXTRATERRESTRIAL_STONE_STAIRS.get(), ClangingHowl.location("block/smooth_extraterrestrial_stone"));
        this.stairsBlockWithItem((StairBlock)CHBlocks.EXTRATERRESTRIAL_STONE_BRICK_STAIRS.get(), ClangingHowl.location("block/extraterrestrial_stone_bricks"));
        this.stairsBlockWithItem((StairBlock)CHBlocks.CARVED_STEEL_PLATE_STAIRS.get(), ClangingHowl.location("block/carved_steel_plate_block"));
        this.stairsBlockWithItem((StairBlock)CHBlocks.CALCITE_TILE_STAIRS.get(), ClangingHowl.location("block/calcite_tiles"));
        this.wallBlockWithItem((WallBlock)CHBlocks.EXTRATERRESTRIAL_STONE_WALL.get(), ClangingHowl.location("block/extraterrestrial_stone"));
        this.wallBlockWithItem((WallBlock)CHBlocks.SMOOTH_EXTRATERRESTRIAL_STONE_WALL.get(), ClangingHowl.location("block/smooth_extraterrestrial_stone"));
        this.wallBlockWithItem((WallBlock)CHBlocks.EXTRATERRESTRIAL_STONE_BRICK_WALL.get(), ClangingHowl.location("block/extraterrestrial_stone_bricks"));
        this.trapdoorBlockWithItem((TrapDoorBlock)CHBlocks.STEEL_TRAPDOOR.get(), ClangingHowl.location("block/steel_trapdoor"), true);
    }

    public ModelFile cubeAllWithRender(Block block, String renderType) {
        return ((BlockModelBuilder)this.models().cubeAll(this.name(block), this.blockTexture(block))).renderType(renderType);
    }

    public void simpleBlockWithItem(Block block) {
        this.simpleBlock(block, this.cubeAll(block));
        this.simpleBlockItem(block, this.cubeAll(block));
    }

    public void simpleBlockWithItemAndRender(Block block, String renderType) {
        this.simpleBlock(block, this.cubeAllWithRender(block, renderType));
        this.simpleBlockItem(block, this.cubeAllWithRender(block, renderType));
    }

    public void slabBlockWithItem(SlabBlock block, ResourceLocation texture) {
        this.slabBlock(block, texture);
        String baseName = this.key((Block)block).toString();
        this.simpleBlockItem((Block)block, (ModelFile)this.models().slab(baseName, texture, texture, texture));
    }

    public void slabBlockWithItem(SlabBlock block, ResourceLocation doubleSlab, ResourceLocation texture) {
        this.slabBlock(block, doubleSlab, texture);
        String baseName = this.key((Block)block).toString();
        this.simpleBlockItem((Block)block, (ModelFile)this.models().slab(baseName, texture, texture, texture));
    }

    public void slabBlockWithItem(SlabBlock block, ResourceLocation doubleSlab, ResourceLocation side, ResourceLocation top) {
        this.slabBlock(block, doubleSlab, side, top);
        String baseName = this.key((Block)block).toString();
        this.simpleBlockItem((Block)block, (ModelFile)this.models().slab(baseName, side, top, top));
    }

    public void slabBlock(SlabBlock block, ResourceLocation texture) {
        this.slabBlock(block, texture, texture, texture, texture);
    }

    public void slabBlock(SlabBlock block, ResourceLocation doubleSlab, ResourceLocation side, ResourceLocation top) {
        this.slabBlock(block, doubleSlab, side, top, top);
    }

    public void stairsBlockWithItem(StairBlock block, ResourceLocation texture) {
        this.stairsBlock(block, texture, texture, texture);
        String baseName = this.key((Block)block).toString();
        this.simpleBlockItem((Block)block, (ModelFile)this.models().stairs(baseName, texture, texture, texture));
    }

    public void buttonBlockWithItem(ButtonBlock block, ResourceLocation texture) {
        this.buttonBlock(block, texture);
        this.buttonBlockInventory(block, texture);
        this.simpleBlockItem((Block)block, this.buttonBlockInventory(block, texture));
    }

    public ModelFile buttonBlockInventory(ButtonBlock block, ResourceLocation texture) {
        String baseName = this.key((Block)block).toString();
        return this.models().buttonInventory(baseName + "_inventory", texture);
    }

    public void logBlockWithItem(RotatedPillarBlock block) {
        this.logBlock(block);
        String baseName = this.key((Block)block).toString();
        this.simpleBlockItem((Block)block, (ModelFile)this.models().cubeColumn(baseName, this.blockTexture((Block)block), this.extend(this.blockTexture((Block)block), "_top")));
    }

    public void columnBlockWithItem(RotatedPillarBlock block, ResourceLocation texture) {
        this.columnBlockWithItem(block, texture, texture);
    }

    public void columnBlockWithItem(RotatedPillarBlock block, ResourceLocation side, ResourceLocation top) {
        this.columnBlock(block, side, top);
        String baseName = this.key((Block)block).toString();
        this.simpleBlockItem((Block)block, (ModelFile)this.models().cubeColumn(baseName, side, top));
    }

    public void columnBlock(RotatedPillarBlock block, ResourceLocation texture) {
        this.columnBlock(block, texture, texture);
    }

    public void columnBlock(RotatedPillarBlock block, ResourceLocation side, ResourceLocation top) {
        this.axisBlock(block, (ModelFile)this.models().cubeColumn(this.name((Block)block), side, top), (ModelFile)this.models().cubeColumn(this.name((Block)block), side, top));
    }

    public void sideBottomTopBlock(Block block, ResourceLocation top, ResourceLocation side, ResourceLocation bottom) {
        String baseName = this.key(block).toString();
        ((BlockModelBuilder)this.models().cube(baseName, bottom, top, side, side, side, side)).texture("particle", side);
        this.simpleBlockWithItem(block, (ModelFile)((BlockModelBuilder)this.models().cube(baseName, bottom, top, side, side, side, side)).texture("particle", side));
    }

    public void sideBottomTopColumnBlock(RotatedPillarBlock block, ResourceLocation top, ResourceLocation side, ResourceLocation bottom) {
        String baseName = this.key((Block)block).toString();
        this.axisBlock(block, (ModelFile)((BlockModelBuilder)this.models().cube(baseName, bottom, top, side, side, side, side)).texture("particle", side), (ModelFile)((BlockModelBuilder)this.models().cube(baseName, bottom, top, side, side, side, side)).texture("particle", side));
        this.simpleBlockItem((Block)block, (ModelFile)((BlockModelBuilder)this.models().cube(baseName, bottom, top, side, side, side, side)).texture("particle", side));
    }

    public void fenceGateWithItem(FenceGateBlock block, ResourceLocation texture) {
        this.fenceGateBlock(block, texture);
        String baseName = this.key((Block)block).toString();
        this.simpleBlockItem((Block)block, (ModelFile)this.models().fenceGate(baseName, texture));
    }

    public void fenceBlockWithItem(FenceBlock block, ResourceLocation texture) {
        this.fenceBlock(block, texture);
        this.fenceInventory(block, texture);
        this.simpleBlockItem((Block)block, this.fenceInventory(block, texture));
    }

    public ModelFile fenceInventory(FenceBlock block, ResourceLocation texture) {
        String baseName = this.key((Block)block).toString();
        return this.models().fenceInventory(baseName + "_inventory", texture);
    }

    public void fenceBlock(FenceBlock block, ResourceLocation texture) {
        String baseName = this.key((Block)block).toString();
        this.fourWayBlock((CrossCollisionBlock)block, (ModelFile)this.models().fencePost(baseName + "_post", texture), (ModelFile)this.models().fenceSide(baseName + "_side", texture));
        this.fenceInventory(block, texture);
    }

    public void pressurePlateWithItem(PressurePlateBlock block, ResourceLocation texture) {
        this.pressurePlateBlock(block, texture);
        String baseName = this.key((Block)block).toString();
        this.simpleBlockItem((Block)block, (ModelFile)this.models().pressurePlate(baseName, texture));
    }

    public void wallBlockWithItem(WallBlock block, ResourceLocation texture) {
        this.wallBlock(block, texture);
        this.wallBlockInventory(block, texture);
        this.simpleBlockItem((Block)block, this.wallBlockInventory(block, texture));
    }

    public void wallBlock(WallBlock block, ResourceLocation texture) {
        this.wallBlockInternal(block, this.key((Block)block).toString(), texture);
    }

    public ModelFile wallBlockInventory(WallBlock block, ResourceLocation texture) {
        String baseName = this.key((Block)block).toString();
        return this.models().wallInventory(baseName + "_inventory", texture);
    }

    private void wallBlockInternal(WallBlock block, String baseName, ResourceLocation texture) {
        this.wallBlock(block, (ModelFile)this.models().wallPost(baseName + "_post", texture), (ModelFile)this.models().wallSide(baseName + "_side", texture), (ModelFile)this.models().wallSideTall(baseName + "_side_tall", texture));
    }

    public void paneBlockWithItem(IronBarsBlock block, ResourceLocation texture) {
        this.paneBlockWithItem(block, texture, texture, texture);
    }

    public void paneBlockWithItem(IronBarsBlock block, ResourceLocation pane, ResourceLocation edge, ResourceLocation item) {
        this.paneBlock(block, pane, edge);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key((Block)block).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", item);
    }

    public void paneBlockWithItemAndRender(IronBarsBlock block, ResourceLocation texture, String renderType) {
        this.paneBlockWithItemAndRender(block, texture, texture, texture, renderType);
    }

    public void paneBlockWithItemAndRender(IronBarsBlock block, ResourceLocation pane, ResourceLocation edge, ResourceLocation item, String renderType) {
        this.paneBlockWithRenderType(block, pane, edge, renderType);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key((Block)block).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", item);
    }

    public void trapdoorBlockWithItem(TrapDoorBlock block, ResourceLocation texture, boolean orientable) {
        this.trapdoorBlock(block, texture, orientable);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().trapdoorOrientableBottom(this.name((Block)block), texture));
    }

    protected void builtinEntity(Block b, String particle) {
        this.simpleBlock(b, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(b))).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).texture("particle", particle));
    }

    public ModelFile cross(Block block) {
        return ((BlockModelBuilder)this.models().cross(this.name(block), this.blockTexture(block))).renderType("cutout");
    }

    public ItemModelBuilder generatedItem(Block block) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.blockTexture(block));
    }

    protected void crossBlockWithItem(Block block) {
        this.simpleBlock(block, this.cross(block));
        this.generatedItem(block);
    }

    private ResourceLocation extend(ResourceLocation rl, String suffix) {
        return new ResourceLocation(rl.m_135827_(), rl.m_135815_() + suffix);
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }
}

