/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.network.client;

import com.mongoose.clanginghowl.common.capabilities.CHCapHelper;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class CIsMovingPacket {
    private final int entityID;
    private boolean moving;

    public CIsMovingPacket(int entityID, boolean moving) {
        this.entityID = entityID;
        this.moving = moving;
    }

    public static void encode(CIsMovingPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.entityID);
        buf.writeBoolean(packet.moving);
    }

    public static CIsMovingPacket decode(FriendlyByteBuf buf) {
        return new CIsMovingPacket(buf.readInt(), buf.readBoolean());
    }

    public static void consume(CIsMovingPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (packet != null) {
            ctx.get().setPacketHandled(true);
            ctx.get().enqueueWork(() -> {
                Entity entity;
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null && (entity = player.m_9236_().m_6815_(packet.entityID)) instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    CHCapHelper.setMoving(livingEntity, packet.moving);
                }
            });
        }
    }
}

