/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.network;

import com.mongoose.clanginghowl.ClangingHowl;
import com.mongoose.clanginghowl.common.capabilities.CHCapUpdatePacket;
import com.mongoose.clanginghowl.common.network.client.CIsMovingPacket;
import com.mongoose.clanginghowl.common.network.server.SInstaLookPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class CHNetwork {
    public static SimpleChannel INSTANCE;
    private static int id;

    public static int nextID() {
        return id++;
    }

    public static void init() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)ClangingHowl.location("channel"), () -> "1.0", s -> true, s -> true);
        INSTANCE.registerMessage(CHNetwork.nextID(), CIsMovingPacket.class, CIsMovingPacket::encode, CIsMovingPacket::decode, CIsMovingPacket::consume);
        INSTANCE.registerMessage(CHNetwork.nextID(), SInstaLookPacket.class, SInstaLookPacket::encode, SInstaLookPacket::decode, SInstaLookPacket::consume);
        INSTANCE.registerMessage(CHNetwork.nextID(), CHCapUpdatePacket.class, CHCapUpdatePacket::encode, CHCapUpdatePacket::decode, CHCapUpdatePacket::consume);
    }

    public static <MSG> void sendTo(Player player, MSG msg) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), msg);
    }

    public static <MSG> void sendToServer(MSG msg) {
        INSTANCE.sendToServer(msg);
    }

    public static <MSG> void sentToTrackingChunk(LevelChunk chunk, MSG msg) {
        INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), msg);
    }

    public static <MSG> void sentToTrackingEntity(Entity entity, MSG msg) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), msg);
    }

    public static <MSG> void sentToTrackingEntityAndPlayer(Entity entity, MSG msg) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), msg);
    }

    public static <MSG> void sendToALL(MSG msg) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), msg);
    }

    public static <MSG> void sendToClient(ServerPlayer player, MSG msg) {
        INSTANCE.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    static {
        id = 0;
    }
}

