/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.items.fuel;

import com.mongoose.clanginghowl.common.enchantments.CHEnchantments;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface IFuel {
    public static final String FUEL_AMOUNT = "Fuel";
    public static final String MAX_FUEL_AMOUNT = "Max Fuel";

    public int getMaxFuel();

    default public int getConsumption(ItemStack itemStack) {
        return 5;
    }

    default public void consumeFuel(ItemStack itemStack) {
        int amount = this.getConsumption(itemStack) - itemStack.getEnchantmentLevel((Enchantment)CHEnchantments.FUEL_SAVING.get());
        IFuel.decreaseFuel(itemStack, amount);
    }

    default public void setTagTick(ItemStack stack) {
        CompoundTag compound;
        if (stack.m_41783_() == null) {
            compound = stack.m_41784_();
            compound.m_128405_(FUEL_AMOUNT, 0);
            compound.m_128405_(MAX_FUEL_AMOUNT, this.getMaxFuel());
        }
        if (!stack.m_41783_().m_128441_(MAX_FUEL_AMOUNT)) {
            compound = stack.m_41784_();
            compound.m_128405_(MAX_FUEL_AMOUNT, this.getMaxFuel());
        }
        if (stack.m_41783_().m_128451_(FUEL_AMOUNT) > stack.m_41783_().m_128451_(MAX_FUEL_AMOUNT)) {
            stack.m_41783_().m_128405_(FUEL_AMOUNT, stack.m_41783_().m_128451_(MAX_FUEL_AMOUNT));
        }
        if (stack.m_41783_().m_128451_(FUEL_AMOUNT) < 0) {
            stack.m_41783_().m_128405_(FUEL_AMOUNT, 0);
        }
    }

    public static boolean isFull(ItemStack itemStack) {
        int maxFuel;
        if (itemStack.m_41783_() == null) {
            return false;
        }
        int fuel = itemStack.m_41783_().m_128451_(FUEL_AMOUNT);
        return fuel >= (maxFuel = itemStack.m_41783_().m_128451_(MAX_FUEL_AMOUNT));
    }

    public static boolean isEmpty(ItemStack itemStack) {
        if (itemStack.m_41783_() == null) {
            return true;
        }
        int fuel = itemStack.m_41783_().m_128451_(FUEL_AMOUNT);
        return fuel <= 0;
    }

    public static int currentFuel(ItemStack itemStack) {
        if (itemStack.m_41783_() != null) {
            return itemStack.m_41783_().m_128451_(FUEL_AMOUNT);
        }
        return 0;
    }

    public static int maximumFuel(ItemStack itemStack) {
        if (itemStack.m_41783_() != null) {
            return itemStack.m_41783_().m_128451_(MAX_FUEL_AMOUNT);
        }
        return 0;
    }

    public static void setFuel(ItemStack itemStack, int fuel) {
        if (!(itemStack.m_41720_() instanceof IFuel)) {
            return;
        }
        itemStack.m_41784_().m_128405_(FUEL_AMOUNT, fuel);
    }

    public static void setMaxFuelAmount(ItemStack itemStack, int fuel) {
        if (!(itemStack.m_41720_() instanceof IFuel)) {
            return;
        }
        itemStack.m_41784_().m_128405_(MAX_FUEL_AMOUNT, fuel);
    }

    public static void fillUpItem(ItemStack itemStack, int fuel) {
        if (!(itemStack.m_41720_() instanceof IFuel) || itemStack.m_41783_() == null) {
            return;
        }
        int currentEnergy = itemStack.m_41783_().m_128451_(FUEL_AMOUNT);
        if (!IFuel.isFull(itemStack)) {
            int finalCount = Math.min(currentEnergy + fuel, IFuel.maximumFuel(itemStack));
            itemStack.m_41784_().m_128405_(FUEL_AMOUNT, finalCount);
        }
    }

    public static void decreaseFuel(ItemStack itemStack, int fuel) {
        if (!(itemStack.m_41720_() instanceof IFuel) || itemStack.m_41783_() == null) {
            return;
        }
        int currentFuel = itemStack.m_41783_().m_128451_(FUEL_AMOUNT);
        if (!IFuel.isEmpty(itemStack)) {
            int finalCount = Math.max(currentFuel - fuel, 0);
            itemStack.m_41784_().m_128405_(FUEL_AMOUNT, finalCount);
        }
    }

    default public void addFuelText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41783_() != null) {
            tooltip.add((Component)Component.m_237119_());
            int energy = stack.m_41783_().m_128451_(FUEL_AMOUNT);
            int maxEnergy = stack.m_41783_().m_128451_(MAX_FUEL_AMOUNT);
            tooltip.add((Component)Component.m_237115_((String)"info.clanginghowl.fuel.amount").m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237110_((String)"info.clanginghowl.energy.number", (Object[])new Object[]{energy, maxEnergy}).m_130940_(ChatFormatting.GRAY)));
        }
    }
}

