/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.items.fuel;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mongoose.clanginghowl.client.particles.CHParticleTypes;
import com.mongoose.clanginghowl.common.effects.CHEffects;
import com.mongoose.clanginghowl.common.enchantments.CHEnchantments;
import com.mongoose.clanginghowl.common.items.CHItems;
import com.mongoose.clanginghowl.common.items.fuel.IFuel;
import com.mongoose.clanginghowl.init.CHSounds;
import com.mongoose.clanginghowl.utils.CHBlockUtil;
import com.mongoose.clanginghowl.utils.CHDamageSource;
import com.mongoose.clanginghowl.utils.ItemHelper;
import com.mongoose.clanginghowl.utils.MathHelper;
import com.mongoose.clanginghowl.utils.MobUtil;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class FlamethrowerItem
extends Item
implements IFuel {
    public FlamethrowerItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Override
    public int getMaxFuel() {
        return 1600;
    }

    public ItemStack getPowerlessItem() {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        IFuel.setFuel(itemStack, 0);
        IFuel.setMaxFuelAmount(itemStack, this.getMaxFuel());
        return itemStack;
    }

    public ItemStack getPoweredItem() {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        IFuel.setFuel(itemStack, this.getMaxFuel());
        IFuel.setMaxFuelAmount(itemStack, this.getMaxFuel());
        return itemStack;
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, 1.0f - this.amountColor(stack));
        return Mth.m_14159_((float)1.0f, (float)(0.88f * f), (float)0.045f);
    }

    public float amountColor(ItemStack stack) {
        if (stack.m_41783_() != null) {
            int energy = stack.m_41783_().m_128451_("Fuel");
            int maxEnergy = stack.m_41783_().m_128451_("Max Fuel");
            return 1.0f - (float)energy / (float)maxEnergy;
        }
        return 1.0f;
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41783_() != null && !IFuel.isFull(stack);
    }

    public int m_142158_(ItemStack stack) {
        if (stack.m_41783_() != null) {
            int energy = stack.m_41783_().m_128451_("Fuel");
            int maxEnergy = stack.m_41783_().m_128451_("Max Fuel");
            return Math.round((float)energy * 13.0f / (float)maxEnergy);
        }
        return 0;
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        IFuel.setFuel(pStack, 0);
        IFuel.setMaxFuelAmount(pStack, this.getMaxFuel());
        super.m_7836_(pStack, pLevel, pPlayer);
    }

    @Override
    public int getConsumption(ItemStack itemStack) {
        int increase = 0;
        if (itemStack.getEnchantmentLevel((Enchantment)CHEnchantments.NAPALM_STREAM.get()) > 0) {
            increase += itemStack.getEnchantmentLevel((Enchantment)CHEnchantments.NAPALM_STREAM.get());
        }
        if (this.isFuelBurst(itemStack)) {
            increase += 5;
        }
        return IFuel.super.getConsumption(itemStack) + increase;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.setTagTick(stack);
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public int m_8105_(ItemStack p_40680_) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack p_40678_) {
        return UseAnim.CUSTOM;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 10;
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean isFuelBurst(ItemStack stack) {
        return stack.getEnchantmentLevel((Enchantment)CHEnchantments.FUEL_BURST.get()) > 0;
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack itemStack, int ticks) {
        super.m_5929_(level, livingEntity, itemStack, ticks);
        int range = 6;
        if (EntitySelector.f_20406_.test(livingEntity) && ticks % 20 == 0) {
            this.consumeFuel(itemStack);
        }
        if (this.noFuelInInventory(livingEntity, itemStack)) {
            level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), (SoundEvent)CHSounds.DISCHARGED.get(), livingEntity.m_5720_(), 0.4f, 1.0f);
            livingEntity.m_5810_();
        }
        if (!level.f_46443_) {
            float flameRange = (float)range * ((float)Math.PI / 180);
            for (int i = 0; i < 3; ++i) {
                Vec3 cast = livingEntity.m_20154_().m_82541_().m_82496_(level.m_213780_().m_188501_() * flameRange * 2.0f - flameRange).m_82524_(level.m_213780_().m_188501_() * flameRange * 2.0f - flameRange);
                BlockHitResult hitResult = level.m_45547_(new ClipContext(livingEntity.m_146892_(), livingEntity.m_146892_().m_82549_(cast.m_82490_(10.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)livingEntity));
                if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                    Vec3 pos = hitResult.m_82450_().m_82546_(cast.m_82490_(0.5));
                    BlockPos blockPos = BlockPos.m_274561_((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_);
                    if (level.m_8055_(blockPos).m_60795_() || CHBlockUtil.canBeReplaced(level, blockPos) && level.m_6425_(blockPos).m_76178_() && Blocks.f_50083_.m_49966_().m_60710_((LevelReader)level, blockPos)) {
                        level.m_46597_(blockPos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)blockPos));
                    }
                }
                for (Entity target : this.getBreathTarget(livingEntity, range)) {
                    int enchantment;
                    DamageSource damageSource;
                    if (target == null || target.m_5842_() || !target.m_6469_(damageSource = CHDamageSource.fireStream((Entity)livingEntity, (Entity)livingEntity), 1.5f + (float)(enchantment = itemStack.getEnchantmentLevel((Enchantment)CHEnchantments.NAPALM_STREAM.get())))) continue;
                    if (target instanceof LivingEntity) {
                        LivingEntity livingEntity1 = (LivingEntity)target;
                        livingEntity1.m_7292_(new MobEffectInstance((MobEffect)CHEffects.DEEP_BURN.get(), 500));
                    }
                    int fireSeconds = 10;
                    target.m_20254_(fireSeconds += enchantment * 5);
                    if (itemStack.getEnchantmentLevel((Enchantment)CHEnchantments.CHAIN_BURN.get()) <= 0 || !(target instanceof LivingEntity)) continue;
                    LivingEntity livingEntity1 = (LivingEntity)target;
                    livingEntity1.m_7292_(new MobEffectInstance((MobEffect)CHEffects.INTERNAL_HEAT.get(), 500));
                }
            }
        }
        this.dragonBreathAttack((ParticleOptions)CHParticleTypes.FLAMETHROWER_FLAME.get(), livingEntity, (double)range / 10.0 * 0.5);
    }

    public List<Entity> getBreathTarget(LivingEntity livingEntity, double range) {
        return MobUtil.getTargets(livingEntity.m_9236_(), livingEntity, range, 3.0);
    }

    public List<Entity> getBreathTarget(LivingEntity livingEntity, double range, Predicate<Entity> predicate) {
        return MobUtil.getTargets(livingEntity.m_9236_(), livingEntity, range, 3.0, predicate);
    }

    public void dragonBreathAttack(ParticleOptions particleOptions, LivingEntity entityLiving, double pVelocity) {
        this.dragonBreathAttack(particleOptions, entityLiving, 10, pVelocity);
    }

    public void dragonBreathAttack(ParticleOptions particleOptions, LivingEntity entityLiving, int pParticleAmount, double pVelocity) {
        Vec3 look = entityLiving.m_20154_();
        double dist = 2.0;
        double px = entityLiving.m_20185_() + look.f_82479_ * dist;
        double py = entityLiving.m_20188_() + look.f_82480_ * dist;
        double pz = entityLiving.m_20189_() + look.f_82481_ * dist;
        double velocity = pVelocity + entityLiving.m_217043_().m_188500_() * pVelocity;
        for (int i = 0; i < pParticleAmount; ++i) {
            Level level;
            double offset = 0.15;
            double dx = entityLiving.m_217043_().m_188500_() * 2.0 * offset - offset;
            double dy = entityLiving.m_217043_().m_188500_() * 2.0 * offset - offset;
            double dz = entityLiving.m_217043_().m_188500_() * 2.0 * offset - offset;
            double angle = 0.5;
            Vec3 randomVec = new Vec3(entityLiving.m_217043_().m_188500_() * 2.0 * angle - angle, entityLiving.m_217043_().m_188500_() * 2.0 * angle - angle, entityLiving.m_217043_().m_188500_() * 2.0 * angle - angle).m_82541_();
            Vec3 result = look.m_82541_().m_82490_(3.0).m_82549_(randomVec).m_82541_().m_82490_(velocity);
            BlockPos blockPos = BlockPos.m_274561_((double)(px + dx), (double)(py + dy), (double)(pz + dz));
            if (entityLiving.m_9236_().m_46801_(blockPos)) {
                particleOptions = ParticleTypes.f_123795_;
            }
            if ((level = entityLiving.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_(particleOptions, px + dx, py + dy - 0.2, pz + dz, 0, result.f_82479_, result.f_82480_, result.f_82481_, 1.0);
                continue;
            }
            entityLiving.m_9236_().m_7107_(particleOptions, px + dx, py + dy - 0.2, pz + dz, result.f_82479_, result.f_82480_, result.f_82481_);
        }
    }

    public boolean noFuelInInventory(LivingEntity livingEntity, ItemStack itemStack) {
        if (IFuel.isEmpty(itemStack) && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Inventory inventory = player.m_150109_();
            ImmutableList compartments = ImmutableList.of((Object)inventory.f_35974_, (Object)inventory.f_35975_, (Object)inventory.f_35976_);
            for (List list : compartments) {
                for (ItemStack itemStack1 : list) {
                    if (itemStack1.m_41619_() || !itemStack1.m_150930_((Item)CHItems.BLAZE_FUEL_CYLINDER.get())) continue;
                    itemStack1.m_41774_(1);
                    IFuel.fillUpItem(itemStack, this.getMaxFuel());
                    return false;
                }
            }
        }
        return IFuel.isEmpty(itemStack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!this.noFuelInInventory((LivingEntity)player, itemStack)) {
            if (this.isFuelBurst(itemStack)) {
                this.consumeFuel(itemStack);
                int range = 6;
                if (!level.f_46443_) {
                    for (Entity target : this.getBreathTarget((LivingEntity)player, range, EntitySelector.f_20406_.and(entity -> !MobUtil.areAllies(entity, (Entity)player)))) {
                        if (target == null || target.m_5842_()) continue;
                        DamageSource damageSource = CHDamageSource.fireStream((Entity)player, (Entity)player);
                        int enchantment = itemStack.getEnchantmentLevel((Enchantment)CHEnchantments.NAPALM_STREAM.get());
                        if (target instanceof LivingEntity) {
                            LivingEntity livingEntity1 = (LivingEntity)target;
                            if (target.m_6469_(damageSource, 1.5f + (float)enchantment)) {
                                livingEntity1.m_7292_(new MobEffectInstance((MobEffect)CHEffects.DEEP_BURN.get(), 500));
                                int fireSeconds = 10;
                                target.m_20254_(fireSeconds += enchantment * 5);
                            }
                        }
                        double power = target instanceof Projectile ? 6.0 : 3.0;
                        MobUtil.knockBack(target, (Entity)player, power, 0.2, power);
                    }
                }
                this.dragonBreathAttack((ParticleOptions)CHParticleTypes.FLAMETHROWER_BURST.get(), (LivingEntity)player, 30, (double)0.1f + (double)range / 10.0);
                player.m_36335_().m_41524_((Item)this, 35);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)CHSounds.FLAMETHROWER_ACTIVATION.get(), player.m_5720_(), 1.0f, 1.0f);
            } else {
                player.m_6672_(hand);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)CHSounds.FLAMETHROWER_ACTIVATION.get(), player.m_5720_(), 0.4f, 1.0f);
            }
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)CHSounds.DISCHARGED.get(), player.m_5720_(), 0.4f, 1.0f);
        player.m_5661_((Component)Component.m_237115_((String)"info.clanginghowl.fuel.empty"), true);
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        ItemHelper.addOnShift(tooltip, () -> this.addInformationAfterShift(tooltip));
        this.addFuelText(stack, worldIn, tooltip, flagIn);
    }

    public void addInformationAfterShift(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)"info.clanginghowl.item.flamethrower.0"));
        tooltip.add((Component)Component.m_237115_((String)"info.clanginghowl.item.flamethrower.1"));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new FlameClient());
    }

    public static class FlameClient
    implements IClientItemExtensions {
        private static final HumanoidModel.ArmPose FLAME = HumanoidModel.ArmPose.create((String)"CH_FLAME", (boolean)false, (model, entity, arm) -> {
            if (arm == HumanoidArm.RIGHT) {
                model.f_102811_.f_104203_ = -MathHelper.modelDegrees(55.0f) + model.f_102808_.f_104203_;
                model.f_102811_.f_104204_ = -0.1f + model.f_102808_.f_104204_;
                model.f_102812_.f_104203_ = -MathHelper.modelDegrees(50.0f) + model.f_102808_.f_104203_;
                model.f_102812_.f_104204_ = 0.1f + model.f_102808_.f_104204_ + 0.4f;
                model.f_102812_.f_104205_ = MathHelper.modelDegrees(30.0f);
            } else {
                model.f_102812_.f_104203_ = -MathHelper.modelDegrees(55.0f) + model.f_102808_.f_104203_;
                model.f_102812_.f_104204_ = 0.1f + model.f_102808_.f_104204_;
                model.f_102811_.f_104203_ = -MathHelper.modelDegrees(50.0f) + model.f_102808_.f_104203_;
                model.f_102811_.f_104204_ = -0.1f + model.f_102808_.f_104204_ - 0.4f;
                model.f_102811_.f_104205_ = -MathHelper.modelDegrees(30.0f);
            }
        });
        private static final HumanoidModel.ArmPose IDLE_FLAME = HumanoidModel.ArmPose.create((String)"CH_IDLE_FLAME", (boolean)false, (model, entity, arm) -> {
            if (arm == HumanoidArm.RIGHT) {
                model.f_102811_.f_104203_ = -MathHelper.modelDegrees(45.0f) + model.f_102808_.f_104203_;
                model.f_102811_.f_104204_ = -0.1f + model.f_102808_.f_104204_;
                model.f_102811_.f_104205_ = 0.0f;
                model.f_102812_.f_104203_ = -MathHelper.modelDegrees(45.0f) + model.f_102808_.f_104203_;
                model.f_102812_.f_104204_ = 0.1f + model.f_102808_.f_104204_ + 0.4f;
                model.f_102812_.f_104205_ = MathHelper.modelDegrees(30.0f);
            } else {
                model.f_102812_.f_104203_ = -MathHelper.modelDegrees(45.0f) + model.f_102808_.f_104203_;
                model.f_102812_.f_104204_ = 0.1f + model.f_102808_.f_104204_;
                model.f_102812_.f_104205_ = 0.0f;
                model.f_102811_.f_104203_ = -MathHelper.modelDegrees(45.0f) + model.f_102808_.f_104203_;
                model.f_102811_.f_104204_ = -0.1f + model.f_102808_.f_104204_ - 0.4f;
                model.f_102811_.f_104205_ = -MathHelper.modelDegrees(30.0f);
            }
        });

        public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
            if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof FlamethrowerItem) {
                if (entityLiving.m_7655_() == hand && entityLiving.m_21212_() > 0) {
                    return FLAME;
                }
                return IDLE_FLAME;
            }
            return HumanoidModel.ArmPose.EMPTY;
        }

        public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
            int i;
            int n = i = arm == HumanoidArm.RIGHT ? 1 : -1;
            if (player.m_6117_()) {
                this.applyItemArmTransform(poseStack, arm, equipProcess);
                poseStack.m_252880_(0.0f, 0.0f, 0.0f);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(1.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * 35.3f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_((float)i * -9.785f));
                float f8 = (float)itemInHand.m_41779_() - ((float)player.m_21212_() - partialTick + 1.0f);
                float f12 = f8 / 20.0f;
                f12 = (f12 * f12 + f12 * 2.0f) / 3.0f;
                if (f12 > 1.0f) {
                    f12 = 1.0f;
                }
                if (f12 > 0.1f) {
                    float f15 = Mth.m_14031_((float)((f8 - 0.1f) * 1.3f));
                    float f18 = f12 - 0.1f;
                    float f20 = f15 * f18;
                    poseStack.m_85837_((double)(f20 * 0.0f), (double)(f20 * 0.004f), (double)(f20 * 0.0f));
                }
                poseStack.m_85837_((double)(f12 * 0.0f), (double)(f12 * 0.0f), (double)(f12 * 0.04f));
                poseStack.m_85841_(1.0f, 1.0f, 1.0f);
                poseStack.m_252781_(Axis.f_252392_.m_252977_((float)i * 45.0f));
            } else {
                float f5 = -0.4f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProcess) * (float)Math.PI));
                float f6 = 0.2f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProcess) * ((float)Math.PI * 2)));
                float f10 = -0.2f * Mth.m_14031_((float)(swingProcess * (float)Math.PI));
                poseStack.m_85837_((double)((float)i * f5), (double)f6, (double)f10);
                this.applyItemArmTransform(poseStack, arm, equipProcess);
                this.applyItemArmAttackTransform(poseStack, arm, swingProcess);
            }
            return true;
        }

        private void applyItemArmTransform(PoseStack poseStack, HumanoidArm arm, float equipProcess) {
            int i = arm == HumanoidArm.RIGHT ? 1 : -1;
            poseStack.m_85837_((double)((float)i * 0.56f), (double)(-0.52f + equipProcess * -0.6f), (double)-0.72f);
        }

        private void applyItemArmAttackTransform(PoseStack poseStack, HumanoidArm humanoidArm, float swingProcess) {
            int i = humanoidArm == HumanoidArm.RIGHT ? 1 : -1;
            float f = Mth.m_14031_((float)(swingProcess * swingProcess * (float)Math.PI));
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * (45.0f + f * -20.0f)));
            float f1 = Mth.m_14031_((float)(Mth.m_14116_((float)swingProcess) * (float)Math.PI));
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)i * f1 * -20.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(f1 * -80.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * -45.0f));
        }
    }
}

