/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.items.energy;

import com.google.common.collect.ImmutableList;
import com.mongoose.clanginghowl.client.inventory.menu.PortableChargerMenu;
import com.mongoose.clanginghowl.common.items.capabilities.PortableChargerCapability;
import com.mongoose.clanginghowl.common.items.energy.BatteryItem;
import com.mongoose.clanginghowl.common.items.energy.IEnergyItem;
import com.mongoose.clanginghowl.common.items.handler.PortableChargerHandler;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class PortableChargerItem
extends Item {
    private static final String HAS_BATTERIES = "HasBatteries";

    public PortableChargerItem() {
        super(new Item.Properties().setNoRepair().m_41497_(Rarity.RARE).m_41487_(1));
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            if (stack.m_41783_() == null) {
                stack.m_41784_().m_128379_(HAS_BATTERIES, false);
            }
            PortableChargerHandler handler = PortableChargerHandler.get(stack);
            ItemStack battery = ItemStack.f_41583_;
            for (ItemStack itemStack : handler.getContents()) {
                if (!(itemStack.m_41720_() instanceof BatteryItem)) continue;
                if (!IEnergyItem.isEmpty(itemStack)) {
                    battery = itemStack;
                    break;
                }
                itemStack.m_41774_(1);
            }
            if (!battery.m_41619_()) {
                if (!worldIn.f_46443_) {
                    Inventory inventory = player.m_150109_();
                    ImmutableList compartments = ImmutableList.of((Object)inventory.f_35974_, (Object)inventory.f_35975_, (Object)inventory.f_35976_);
                    for (List list : compartments) {
                        for (ItemStack itemStack : list) {
                            if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof IEnergyItem) || itemStack.m_41720_() instanceof BatteryItem || IEnergyItem.isFull(itemStack)) continue;
                            IEnergyItem.chargeEnergy(itemStack, battery);
                        }
                    }
                }
                if (stack.m_41783_() != null) {
                    stack.m_41783_().m_128379_(HAS_BATTERIES, true);
                }
            } else if (stack.m_41783_() != null) {
                stack.m_41783_().m_128379_(HAS_BATTERIES, false);
            }
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public static boolean hasBatteries(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128471_(HAS_BATTERIES);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (!worldIn.f_46443_) {
            SimpleMenuProvider provider = new SimpleMenuProvider((id, inventory, player) -> new PortableChargerMenu(id, inventory, PortableChargerHandler.get(itemstack), itemstack), this.m_7626_(itemstack));
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)provider, buffer -> {});
        }
        return InteractionResultHolder.m_19090_((Object)itemstack);
    }

    private static IItemHandler getItemHandler(ItemStack itemStack) {
        return (IItemHandler)itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(() -> new IllegalArgumentException("Expected an item handler for the Magic Focus item, but " + itemStack + " does not expose an item handler."));
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt;
        IItemHandler iitemHandler = PortableChargerItem.getItemHandler(stack);
        CompoundTag compoundTag = nbt = stack.m_41783_() != null ? stack.m_41783_() : new CompoundTag();
        if (iitemHandler instanceof ItemStackHandler) {
            ItemStackHandler itemHandler = (ItemStackHandler)iitemHandler;
            nbt.m_128365_("cap", (Tag)itemHandler.serializeNBT());
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt == null) {
            stack.m_41751_(null);
        } else {
            IItemHandler iitemHandler = PortableChargerItem.getItemHandler(stack);
            if (iitemHandler instanceof ItemStackHandler) {
                ItemStackHandler itemHandler = (ItemStackHandler)iitemHandler;
                itemHandler.deserializeNBT(nbt.m_128469_("cap"));
            }
            stack.m_41751_(nbt);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && slotChanged;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundTag nbt) {
        return new PortableChargerCapability(stack);
    }

    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"info.clanginghowl.item.charger.0"));
        tooltip.add((Component)Component.m_237115_((String)"info.clanginghowl.item.charger.1"));
    }
}

