/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.items.energy;

import com.mongoose.clanginghowl.common.enchantments.CHEnchantments;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public interface IEnergyItem {
    public static final String ENERGY_AMOUNT = "Energy";
    public static final String MAX_ENERGY_AMOUNT = "Max Energy";

    public int getMaxEnergy();

    default public int getConsumption(ItemStack itemStack) {
        return 4;
    }

    default public void consumeEnergy(ItemStack itemStack) {
        int amount = this.getConsumption(itemStack) - itemStack.getEnchantmentLevel((Enchantment)CHEnchantments.ENERGY_EFFICIENCY.get());
        IEnergyItem.decreaseEnergy(itemStack, amount);
    }

    default public void setTagTick(ItemStack stack) {
        CompoundTag compound;
        if (stack.m_41783_() == null) {
            compound = stack.m_41784_();
            compound.m_128405_(ENERGY_AMOUNT, 0);
            compound.m_128405_(MAX_ENERGY_AMOUNT, this.getMaxEnergy());
        }
        if (!stack.m_41783_().m_128441_(MAX_ENERGY_AMOUNT)) {
            compound = stack.m_41784_();
            compound.m_128405_(MAX_ENERGY_AMOUNT, this.getMaxEnergy());
        }
        if (stack.m_41783_().m_128451_(ENERGY_AMOUNT) > stack.m_41783_().m_128451_(MAX_ENERGY_AMOUNT)) {
            stack.m_41783_().m_128405_(ENERGY_AMOUNT, stack.m_41783_().m_128451_(MAX_ENERGY_AMOUNT));
        }
        if (stack.m_41783_().m_128451_(ENERGY_AMOUNT) < 0) {
            stack.m_41783_().m_128405_(ENERGY_AMOUNT, 0);
        }
    }

    public static boolean isFull(ItemStack itemStack) {
        int maxEnergy;
        if (itemStack.m_41783_() == null) {
            return false;
        }
        int energy = itemStack.m_41783_().m_128451_(ENERGY_AMOUNT);
        return energy >= (maxEnergy = itemStack.m_41783_().m_128451_(MAX_ENERGY_AMOUNT));
    }

    public static boolean isEmpty(ItemStack itemStack) {
        if (itemStack.m_41783_() == null) {
            return true;
        }
        int energy = itemStack.m_41783_().m_128451_(ENERGY_AMOUNT);
        return energy <= 0;
    }

    public static int currentEnergy(ItemStack itemStack) {
        if (itemStack.m_41783_() != null) {
            return itemStack.m_41783_().m_128451_(ENERGY_AMOUNT);
        }
        return 0;
    }

    public static int maximumEnergy(ItemStack itemStack) {
        if (itemStack.m_41783_() != null) {
            return itemStack.m_41783_().m_128451_(MAX_ENERGY_AMOUNT);
        }
        return 0;
    }

    public static void setEnergy(ItemStack itemStack, int energy) {
        if (!(itemStack.m_41720_() instanceof IEnergyItem)) {
            return;
        }
        itemStack.m_41784_().m_128405_(ENERGY_AMOUNT, energy);
    }

    public static void setMaxEnergyAmount(ItemStack itemStack, int energy) {
        if (!(itemStack.m_41720_() instanceof IEnergyItem)) {
            return;
        }
        itemStack.m_41784_().m_128405_(MAX_ENERGY_AMOUNT, energy);
    }

    public static void powerItem(ItemStack itemStack, int energy) {
        if (!(itemStack.m_41720_() instanceof IEnergyItem) || itemStack.m_41783_() == null) {
            return;
        }
        int currentEnergy = itemStack.m_41783_().m_128451_(ENERGY_AMOUNT);
        if (!IEnergyItem.isFull(itemStack)) {
            int finalCount = Math.min(currentEnergy + energy, IEnergyItem.maximumEnergy(itemStack));
            itemStack.m_41784_().m_128405_(ENERGY_AMOUNT, finalCount);
        }
    }

    public static void decreaseEnergy(ItemStack itemStack, int energy) {
        if (!(itemStack.m_41720_() instanceof IEnergyItem) || itemStack.m_41783_() == null) {
            return;
        }
        int currentEnergy = itemStack.m_41783_().m_128451_(ENERGY_AMOUNT);
        if (!IEnergyItem.isEmpty(itemStack)) {
            int finalCount = Math.max(currentEnergy - energy, 0);
            itemStack.m_41784_().m_128405_(ENERGY_AMOUNT, finalCount);
        }
    }

    public static void chargeEnergy(ItemStack charging, ItemStack battery) {
        if (!IEnergyItem.isEmpty(battery)) {
            IEnergyItem.powerItem(charging, 1);
            IEnergyItem.decreaseEnergy(battery, 1);
            if (IEnergyItem.isEmpty(battery)) {
                battery.m_41774_(1);
            }
        }
    }
}

