/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.items.energy;

import com.mongoose.clanginghowl.common.capabilities.CHCapHelper;
import com.mongoose.clanginghowl.common.enchantments.CHEnchantments;
import com.mongoose.clanginghowl.common.items.energy.BatteryItem;
import com.mongoose.clanginghowl.common.items.energy.IEnergyItem;
import com.mongoose.clanginghowl.init.CHSounds;
import com.mongoose.clanginghowl.utils.MobUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public abstract class EnergyItem
extends Item
implements IEnergyItem {
    public EnergyItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public ItemStack getPowerlessItem() {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        IEnergyItem.setEnergy(itemStack, 0);
        IEnergyItem.setMaxEnergyAmount(itemStack, this.getMaxEnergy());
        return itemStack;
    }

    public ItemStack getPoweredItem() {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        IEnergyItem.setEnergy(itemStack, this.getMaxEnergy());
        IEnergyItem.setMaxEnergyAmount(itemStack, this.getMaxEnergy());
        return itemStack;
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, 1.0f - this.amountColor(stack));
        return Mth.m_14159_((float)1.0f, (float)(0.88f * f), (float)0.045f);
    }

    public float amountColor(ItemStack stack) {
        if (stack.m_41783_() != null) {
            int energy = stack.m_41783_().m_128451_("Energy");
            int maxEnergy = stack.m_41783_().m_128451_("Max Energy");
            return 1.0f - (float)energy / (float)maxEnergy;
        }
        return 1.0f;
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41783_() != null && !IEnergyItem.isFull(stack);
    }

    public int m_142158_(ItemStack stack) {
        if (stack.m_41783_() != null) {
            int energy = stack.m_41783_().m_128451_("Energy");
            int maxEnergy = stack.m_41783_().m_128451_("Max Energy");
            return Math.round((float)energy * 13.0f / (float)maxEnergy);
        }
        return 0;
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        IEnergyItem.setEnergy(pStack, this.getMaxEnergy());
        IEnergyItem.setMaxEnergyAmount(pStack, this.getMaxEnergy());
        super.m_7836_(pStack, pLevel, pPlayer);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.setTagTick(stack);
        if (!worldIn.f_46443_ && stack.getEnchantmentLevel((Enchantment)CHEnchantments.ECOLOGICAL_ENERGY.get()) > 0 && MobUtil.isInSunlight(entityIn) && entityIn.f_19797_ % 20 == 0) {
            IEnergyItem.powerItem(stack, 2);
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public BlockHitResult blockResult(Level worldIn, LivingEntity caster, double range) {
        float f = caster.m_146909_();
        float f1 = caster.m_146908_();
        Vec3 vector3d = caster.m_20299_(1.0f);
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3 vector3d1 = vector3d.m_82520_((double)f6 * range, (double)f5 * range, (double)f7 * range);
        return worldIn.m_45547_(new ClipContext(vector3d, vector3d1, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)caster));
    }

    public float getDestroySpeed(BlockState blockState, float toolSpeed, BlockGetter blockGetter, BlockPos blockPos) {
        float f = blockState.m_60800_(blockGetter, blockPos);
        int i = TierSortingRegistry.isCorrectTierForDrops((Tier)Tiers.DIAMOND, (BlockState)blockState) ? 30 : 100;
        return toolSpeed / f / (float)i;
    }

    public static void resetMiningProgress(Level level, Player player) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (CHCapHelper.getMiningProgress(player) > 0) {
                CHCapHelper.setMiningProgress(player, 0);
            }
            if (CHCapHelper.getMiningPos(player) != null) {
                EnergyItem.destroyBlockProgress(serverLevel, player.m_19879_(), CHCapHelper.getMiningPos(player), -1);
                CHCapHelper.setMiningPos(player, null);
            }
        }
    }

    public static void destroyBlockProgress(ServerLevel serverLevel, int p_8612_, BlockPos p_8613_, int p_8614_) {
        for (ServerPlayer serverplayer : serverLevel.m_7654_().m_6846_().m_11314_()) {
            double d2;
            double d1;
            double d0;
            if (serverplayer == null || serverplayer.m_9236_() != serverLevel || !((d0 = (double)p_8613_.m_123341_() - serverplayer.m_20185_()) * d0 + (d1 = (double)p_8613_.m_123342_() - serverplayer.m_20186_()) * d1 + (d2 = (double)p_8613_.m_123343_() - serverplayer.m_20189_()) * d2 < 1024.0)) continue;
            serverplayer.f_8906_.m_9829_((Packet)new ClientboundBlockDestructionPacket(p_8612_, p_8613_, p_8614_));
        }
    }

    public boolean canMineBlock(Level world, Player player, BlockPos pos, BlockState state) {
        if (!player.m_36326_() || !world.m_7966_(player, pos)) {
            return false;
        }
        return this.isValid(pos, world) && !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, player));
    }

    public boolean isValid(BlockPos pos, Level world) {
        return !world.m_46859_(pos);
    }

    public float getBreakSpeed(BlockPos blockPos, LivingEntity player, int efficiency) {
        MobEffectInstance fatigue;
        float toolSpeed = Tiers.GOLD.m_6624_();
        if (efficiency > 0) {
            toolSpeed += (float)(efficiency * efficiency + 1);
        }
        if (MobEffectUtil.m_19584_((LivingEntity)player)) {
            toolSpeed *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)player) + 1) * 0.2f;
        }
        if ((fatigue = player.m_21124_(MobEffects.f_19599_)) != null) {
            float f1 = switch (fatigue.m_19564_()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            toolSpeed *= f1;
        }
        Level world = player.m_9236_();
        BlockState state = world.m_8055_(blockPos);
        if (player instanceof Player) {
            Player player1 = (Player)player;
            toolSpeed = ForgeEventFactory.getBreakSpeed((Player)player1, (BlockState)state, (float)toolSpeed, (BlockPos)blockPos);
        }
        return toolSpeed;
    }

    public BlockEvent.BreakEvent fixForgeEventBreakBlock(BlockState state, Player player, Level world, BlockPos pos, int silk, int fortune) {
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
        if (state != null) {
            event.setExpToDrop(state.getExpDrop((LevelReader)world, world.f_46441_, pos, fortune, silk));
        }
        return event;
    }

    public PlayState predicate(AnimationState<?> animationState) {
        animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_40672_, Player p_40673_, InteractionHand p_40674_) {
        ItemStack itemstack = p_40673_.m_21120_(p_40674_);
        if (!IEnergyItem.isEmpty(itemstack)) {
            p_40673_.m_6672_(p_40674_);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        p_40672_.m_6263_(null, p_40673_.m_20185_(), p_40673_.m_20186_(), p_40673_.m_20189_(), (SoundEvent)CHSounds.DISCHARGED.get(), p_40673_.m_5720_(), 0.4f, 1.0f);
        p_40673_.m_5661_((Component)Component.m_237115_((String)"info.clanginghowl.energy.empty"), true);
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public boolean m_8120_(ItemStack stack) {
        if (!(stack.m_41720_() instanceof BatteryItem)) {
            return true;
        }
        return super.m_8120_(stack);
    }

    public int getEnchantmentValue(ItemStack stack) {
        if (!(stack.m_41720_() instanceof BatteryItem)) {
            return 10;
        }
        return super.getEnchantmentValue(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && slotChanged;
    }

    public void addEnergyText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41783_() != null) {
            tooltip.add((Component)Component.m_237119_());
            int energy = stack.m_41783_().m_128451_("Energy");
            int maxEnergy = stack.m_41783_().m_128451_("Max Energy");
            if (stack.m_41720_() instanceof BatteryItem) {
                tooltip.add((Component)Component.m_237115_((String)"info.clanginghowl.battery.amount").m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237110_((String)"info.clanginghowl.battery.number", (Object[])new Object[]{energy, maxEnergy}).m_130940_(ChatFormatting.GRAY)));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"info.clanginghowl.energy.amount").m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237110_((String)"info.clanginghowl.energy.number", (Object[])new Object[]{energy, maxEnergy}).m_130940_(ChatFormatting.GRAY)));
            }
        }
    }
}

