/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.items.energy;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mongoose.clanginghowl.common.items.energy.EnergyItem;
import com.mongoose.clanginghowl.common.items.energy.IEnergyItem;
import com.mongoose.clanginghowl.init.CHSounds;
import com.mongoose.clanginghowl.utils.ItemHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ChainswordItem
extends EnergyItem {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private final Multimap<Attribute, AttributeModifier> dischargedModifiers;

    public ChainswordItem() {
        super(new Item.Properties().m_41487_(1));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 6.5, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
        ImmutableMultimap.Builder builder2 = ImmutableMultimap.builder();
        builder2.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 1.3000000715255737, AttributeModifier.Operation.ADDITION));
        builder2.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        this.dischargedModifiers = builder2.build();
    }

    @Override
    public int getMaxEnergy() {
        return 1500;
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        if (!IEnergyItem.isEmpty(itemStack)) {
            if (EntitySelector.f_20406_.test(attacker)) {
                this.consumeEnergy(itemStack);
            }
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), (SoundEvent)CHSounds.CHAINSAW_BLOW.get(), attacker.m_5720_(), 1.0f, 1.0f);
        } else if (attacker instanceof Player) {
            Player player = (Player)attacker;
            player.m_5661_((Component)Component.m_237115_((String)"info.clanginghowl.energy.empty"), true);
        }
        return true;
    }

    public boolean m_6813_(ItemStack itemStack, Level level, BlockState blockState, BlockPos blockPos, LivingEntity livingEntity) {
        if (blockState.m_60800_((BlockGetter)level, blockPos) != 0.0f && EntitySelector.f_20406_.test(livingEntity)) {
            this.consumeEnergy(itemStack);
        }
        return true;
    }

    public boolean m_6777_(BlockState p_43291_, Level p_43292_, BlockPos p_43293_, Player p_43294_) {
        return !p_43294_.m_7500_();
    }

    public float m_8102_(ItemStack p_43288_, BlockState p_43289_) {
        if (p_43289_.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        return p_43289_.m_204336_(BlockTags.f_278398_) ? 1.5f : 1.0f;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.f_44672_ == EnchantmentCategory.WEAPON) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean m_8096_(BlockState p_43298_) {
        return p_43298_.m_60713_(Blocks.f_50033_);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level p_40672_, Player p_40673_, InteractionHand p_40674_) {
        return Items.f_42388_.m_7203_(p_40672_, p_40673_, p_40674_);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            if (IEnergyItem.isEmpty(stack)) {
                return this.dischargedModifiers;
            }
            return this.defaultModifiers;
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        ItemHelper.addOnShift(tooltip, () -> this.addInformationAfterShift(tooltip));
        this.addEnergyText(stack, worldIn, tooltip, flagIn);
    }

    public void addInformationAfterShift(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)"info.clanginghowl.item.chainsword.0"));
        tooltip.add((Component)Component.m_237115_((String)"info.clanginghowl.item.chainsword.1"));
        tooltip.add((Component)Component.m_237115_((String)"info.clanginghowl.item.chainsword.2"));
    }
}

