/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.items.energy;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mongoose.clanginghowl.client.particles.CHParticleTypes;
import com.mongoose.clanginghowl.client.render.item.AdvancedChainsawRenderer;
import com.mongoose.clanginghowl.common.capabilities.CHCapHelper;
import com.mongoose.clanginghowl.common.effects.CHEffects;
import com.mongoose.clanginghowl.common.enchantments.CHEnchantments;
import com.mongoose.clanginghowl.common.items.energy.EnergyItem;
import com.mongoose.clanginghowl.common.items.energy.IEnergyItem;
import com.mongoose.clanginghowl.init.CHSounds;
import com.mongoose.clanginghowl.utils.ItemHelper;
import com.mongoose.clanginghowl.utils.MathHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.RenderUtils;

public class ChainsawItem
extends EnergyItem
implements GeoItem {
    private static final RawAnimation SAWING = RawAnimation.begin().thenLoop("sawing");
    public AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final Multimap<Attribute, AttributeModifier> attributes;

    public ChainsawItem() {
        super(new Item.Properties().m_41487_(1));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 9.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-3.1f, AttributeModifier.Operation.ADDITION));
        this.attributes = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack itemStack) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributes : super.getAttributeModifiers(equipmentSlot, itemStack);
    }

    @Override
    public int getConsumption(ItemStack itemStack) {
        if (itemStack.getEnchantmentLevel((Enchantment)CHEnchantments.OVERDRIVE.get()) > 0) {
            return super.getConsumption(itemStack) + 3;
        }
        return super.getConsumption(itemStack);
    }

    @Override
    public int getMaxEnergy() {
        return 3000;
    }

    public int m_8105_(ItemStack p_40680_) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack p_40678_) {
        return UseAnim.CUSTOM;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44984_ || enchantment == Enchantments.f_44977_ || enchantment == Enchantments.f_44982_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        if (!IEnergyItem.isEmpty(itemStack)) {
            if (EntitySelector.f_20406_.test(attacker)) {
                this.consumeEnergy(itemStack);
            }
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), (SoundEvent)CHSounds.CHAINSAW_BLOW.get(), attacker.m_5720_(), 1.0f, 1.0f);
        }
        return true;
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack itemStack, int ticks) {
        super.m_5929_(level, livingEntity, itemStack, ticks);
        this.triggerAnim((Entity)livingEntity, GeoItem.getId((ItemStack)itemStack), "controller", "sawing");
        if (EntitySelector.f_20406_.test(livingEntity) && ticks % 20 == 0) {
            this.consumeEnergy(itemStack);
        }
        if (itemStack.getEnchantmentLevel((Enchantment)CHEnchantments.OVERDRIVE.get()) > 0) {
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)CHEffects.OVERDRIVE.get(), 5));
        }
        if (ticks % 15 == 0) {
            double d0 = level.f_46441_.m_188583_() * 0.02;
            double d1 = level.f_46441_.m_188583_() * 0.02;
            double d2 = level.f_46441_.m_188583_() * 0.02;
            level.m_7106_((ParticleOptions)CHParticleTypes.BREAKDOWN_SMOKE.get(), livingEntity.m_20208_(0.5), livingEntity.m_20187_(), livingEntity.m_20262_(0.5), d0, d1, d2);
        }
        if (IEnergyItem.isEmpty(itemStack)) {
            level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), (SoundEvent)CHSounds.CHAINSAW_DISCHARGED.get(), livingEntity.m_5720_(), 0.4f, 1.0f);
            livingEntity.m_5810_();
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            boolean hitting = false;
            if (ticks % 10 == 0) {
                double hitRange = 2.5;
                Vec3 srcVec = livingEntity.m_146892_();
                Vec3 lookVec = livingEntity.m_20252_(1.0f);
                Vec3 destVec = srcVec.m_82520_(lookVec.m_7096_() * hitRange, lookVec.m_7098_() * hitRange, lookVec.m_7094_() * hitRange);
                float scale = 1.0f;
                List possibleList = level.m_45933_((Entity)livingEntity, livingEntity.m_20191_().m_82363_(lookVec.m_7096_() * hitRange, lookVec.m_7098_() * hitRange, lookVec.m_7094_() * hitRange).m_82377_((double)scale, (double)scale, (double)scale));
                for (Entity entity : possibleList) {
                    int j;
                    if (!(entity instanceof LivingEntity)) continue;
                    float borderSize = 0.5f;
                    AABB collisionBB = entity.m_20191_().m_82377_((double)borderSize, (double)borderSize, (double)borderSize);
                    Optional interceptPos = collisionBB.m_82371_(srcVec, destVec);
                    if (collisionBB.m_82390_(srcVec)) {
                        hitting = true;
                    } else if (interceptPos.isPresent()) {
                        hitting = true;
                    }
                    if (!hitting) continue;
                    float extraDamage = 0.0f;
                    if (entity instanceof Mob) {
                        Mob mob = (Mob)entity;
                        extraDamage = EnchantmentHelper.m_44833_((ItemStack)itemStack, (MobType)mob.m_6336_());
                    }
                    if (itemStack.getEnchantmentLevel((Enchantment)CHEnchantments.OVERDRIVE.get()) > 0) {
                        extraDamage += 4.0f;
                    }
                    if (!entity.m_6469_(livingEntity.m_269291_().m_269333_(livingEntity), 3.0f + extraDamage) || (j = EnchantmentHelper.m_44914_((LivingEntity)livingEntity)) <= 0 || entity.m_6060_()) continue;
                    entity.m_20254_(j * 4);
                }
            }
            double range = 2.5;
            if (livingEntity.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()) != null) {
                range = livingEntity.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get());
            }
            BlockHitResult blockHitResult = this.blockResult((Level)serverLevel, livingEntity, range);
            BlockPos blockPos = blockHitResult.m_82425_();
            BlockState blockState = serverLevel.m_8055_(blockPos);
            if (!hitting) {
                Player player;
                float toolSpeed = this.getBreakSpeed(blockPos, livingEntity, EnchantmentHelper.m_44926_((LivingEntity)livingEntity));
                if (livingEntity instanceof Player && this.canMineBlock((Level)serverLevel, player = (Player)livingEntity, blockPos, blockState)) {
                    if (!blockState.m_204336_(BlockTags.f_144280_) && !blockState.m_204336_(BlockTags.f_144281_)) {
                        toolSpeed = 1.0f;
                    }
                    float hardness = this.getDestroySpeed(blockState, toolSpeed, (BlockGetter)serverLevel, blockPos);
                    SoundType soundtype = blockState.getSoundType((LevelReader)serverLevel, blockPos, null);
                    BlockPos miningPos = CHCapHelper.getMiningPos(player);
                    if (miningPos != null && (miningPos.m_123341_() != blockPos.m_123341_() || miningPos.m_123342_() != blockPos.m_123342_() || miningPos.m_123343_() != blockPos.m_123343_())) {
                        CHCapHelper.setMiningProgress(player, 0);
                    }
                    CHCapHelper.increaseMiningProgress(player);
                    CHCapHelper.setMiningPos(player, blockPos);
                    int i = CHCapHelper.getMiningProgress(player);
                    float progress = hardness * (float)(i + 1);
                    int j = (int)(progress * 10.0f);
                    if (hardness >= 0.0f) {
                        ChainsawItem.destroyBlockProgress(serverLevel, player.m_19879_(), blockPos, j);
                    }
                    if (CHCapHelper.getMiningProgress(player) % 4 == 0) {
                        serverLevel.m_5594_(null, blockPos, soundtype.m_56778_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                    }
                    if (hardness == 0.0f) {
                        progress = 1.0f;
                    }
                    if (progress >= 1.0f) {
                        ItemStack tempTool = new ItemStack((ItemLike)Items.f_42391_);
                        int silk = itemStack.getEnchantmentLevel(Enchantments.f_44985_);
                        int fortune = itemStack.getEnchantmentLevel(Enchantments.f_44987_);
                        if (silk > 0) {
                            tempTool.m_41663_(Enchantments.f_44985_, silk);
                        } else if (fortune > 0) {
                            tempTool.m_41663_(Enchantments.f_44987_, fortune);
                        }
                        BlockEvent.BreakEvent breakEvent = this.fixForgeEventBreakBlock(blockState, player, (Level)serverLevel, blockPos, silk, fortune);
                        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
                        if (breakEvent.isCanceled()) {
                            return;
                        }
                        if (!(!TierSortingRegistry.isCorrectTierForDrops((Tier)Tiers.DIAMOND, (BlockState)blockState) || blockState.m_204336_(BlockTags.f_144282_) && blockState.m_60834_())) {
                            List drops = Block.m_49874_((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)blockPos, null, (Entity)player, (ItemStack)tempTool);
                            int exp = blockState.getExpDrop((LevelReader)serverLevel, serverLevel.f_46441_, blockPos, fortune, silk);
                            for (ItemStack drop : drops) {
                                if (drop == null) continue;
                                Block.m_49840_((Level)serverLevel, (BlockPos)blockPos, (ItemStack)drop);
                            }
                            if (exp > 0) {
                                blockState.m_60734_().m_49805_(serverLevel, blockPos, exp);
                            }
                        }
                        serverLevel.m_5594_(null, blockPos, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                        serverLevel.m_46747_(blockPos);
                        serverLevel.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockState));
                        serverLevel.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                        player.m_36246_(Stats.f_12949_.m_12902_((Object)blockState.m_60734_()));
                        CHCapHelper.setMiningProgress(player, 0);
                        CHCapHelper.setMiningPos(player, null);
                        ChainsawItem.destroyBlockProgress(serverLevel, player.m_19879_(), blockPos, -1);
                    }
                }
            } else if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                CHCapHelper.setMiningProgress(player, 0);
                CHCapHelper.setMiningPos(player, null);
                ChainsawItem.destroyBlockProgress(serverLevel, player.m_19879_(), blockPos, -1);
            }
        }
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        super.onStopUsing(stack, entity, count);
        this.stopTriggeredAnim((Entity)entity, GeoItem.getId((ItemStack)stack), "controller", "sawing");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate).triggerableAnim("sawing", SAWING)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object itemStack) {
        return RenderUtils.getCurrentTick();
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level p_40672_, Player p_40673_, InteractionHand p_40674_) {
        ItemStack itemstack = p_40673_.m_21120_(p_40674_);
        if (!IEnergyItem.isEmpty(itemstack)) {
            p_40673_.m_6672_(p_40674_);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        p_40672_.m_6263_(null, p_40673_.m_20185_(), p_40673_.m_20186_(), p_40673_.m_20189_(), (SoundEvent)CHSounds.CHAINSAW_DISCHARGED.get(), p_40673_.m_5720_(), 0.4f, 1.0f);
        p_40673_.m_5661_((Component)Component.m_237115_((String)"info.clanginghowl.energy.empty"), true);
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        ItemHelper.addOnShift(tooltip, () -> this.addInformationAfterShift(tooltip));
        this.addEnergyText(stack, worldIn, tooltip, flagIn);
    }

    public void addInformationAfterShift(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)"info.clanginghowl.item.chainsaw.0"));
        tooltip.add((Component)Component.m_237115_((String)"info.clanginghowl.item.chainsaw.1"));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new ChainsawClient());
    }

    public static class ChainsawClient
    implements IClientItemExtensions {
        private AdvancedChainsawRenderer renderer;
        private static final HumanoidModel.ArmPose CHAINSAW = HumanoidModel.ArmPose.create((String)"CH_CHAINSAW", (boolean)false, (model, entity, arm) -> {
            if (arm == HumanoidArm.RIGHT) {
                model.f_102811_.f_104203_ = -MathHelper.modelDegrees(55.0f);
                model.f_102811_.f_104204_ = -0.1f + model.f_102808_.f_104204_;
                model.f_102812_.f_104203_ = -MathHelper.modelDegrees(50.0f);
                model.f_102812_.f_104204_ = 0.1f + model.f_102808_.f_104204_ + 0.4f;
                model.f_102812_.f_104205_ = MathHelper.modelDegrees(30.0f);
            } else {
                model.f_102812_.f_104203_ = -MathHelper.modelDegrees(55.0f);
                model.f_102812_.f_104204_ = 0.1f + model.f_102808_.f_104204_;
                model.f_102811_.f_104203_ = -MathHelper.modelDegrees(50.0f);
                model.f_102811_.f_104204_ = -0.1f + model.f_102808_.f_104204_ - 0.4f;
                model.f_102811_.f_104205_ = -MathHelper.modelDegrees(30.0f);
            }
        });
        private static final HumanoidModel.ArmPose IDLE_SAW = HumanoidModel.ArmPose.create((String)"CH_IDLE_SAW", (boolean)false, (model, entity, arm) -> {
            if (arm == HumanoidArm.RIGHT) {
                model.f_102811_.f_104203_ = -MathHelper.modelDegrees(45.0f);
                model.f_102811_.f_104204_ = -0.1f + model.f_102808_.f_104204_;
                model.f_102811_.f_104205_ = 0.0f;
                model.f_102812_.f_104203_ = -MathHelper.modelDegrees(45.0f);
                model.f_102812_.f_104204_ = 0.1f + model.f_102808_.f_104204_ + 0.4f;
                model.f_102812_.f_104205_ = MathHelper.modelDegrees(30.0f);
            } else {
                model.f_102812_.f_104203_ = -MathHelper.modelDegrees(45.0f);
                model.f_102812_.f_104204_ = 0.1f + model.f_102808_.f_104204_;
                model.f_102812_.f_104205_ = 0.0f;
                model.f_102811_.f_104203_ = -MathHelper.modelDegrees(45.0f);
                model.f_102811_.f_104204_ = -0.1f + model.f_102808_.f_104204_ - 0.4f;
                model.f_102811_.f_104205_ = -MathHelper.modelDegrees(30.0f);
            }
        });

        public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
            if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof ChainsawItem) {
                if (entityLiving.m_7655_() == hand && entityLiving.m_21212_() > 0) {
                    return CHAINSAW;
                }
                return IDLE_SAW;
            }
            return HumanoidModel.ArmPose.EMPTY;
        }

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            if (this.renderer == null) {
                this.renderer = new AdvancedChainsawRenderer();
            }
            return this.renderer;
        }

        public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
            int i;
            int n = i = arm == HumanoidArm.RIGHT ? 1 : -1;
            if (player.m_6117_()) {
                this.applyItemArmTransform(poseStack, arm, equipProcess);
                poseStack.m_85837_((double)((float)i * -0.1f), 0.0, 0.15731531381607056);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(1.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * 35.3f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_((float)i * -9.785f));
                float f8 = (float)itemInHand.m_41779_() - ((float)player.m_21212_() - partialTick + 1.0f);
                float f12 = f8 / 20.0f;
                f12 = (f12 * f12 + f12 * 2.0f) / 3.0f;
                if (f12 > 1.0f) {
                    f12 = 1.0f;
                }
                if (f12 > 0.1f) {
                    float f15 = Mth.m_14031_((float)((f8 - 0.1f) * 1.3f));
                    float f18 = f12 - 0.1f;
                    float f20 = f15 * f18;
                    poseStack.m_85837_((double)(f20 * 0.0f), (double)(f20 * 0.004f), (double)(f20 * 0.0f));
                }
                poseStack.m_85837_((double)(f12 * 0.0f), (double)(f12 * 0.0f), (double)(f12 * 0.04f));
                poseStack.m_85841_(1.0f, 1.0f, 1.0f);
                poseStack.m_252781_(Axis.f_252392_.m_252977_((float)i * 45.0f));
            } else {
                float f5 = -0.4f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProcess) * (float)Math.PI));
                float f6 = 0.2f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProcess) * ((float)Math.PI * 2)));
                float f10 = -0.2f * Mth.m_14031_((float)(swingProcess * (float)Math.PI));
                poseStack.m_85837_((double)((float)i * f5), (double)f6, (double)f10);
                this.applyItemArmTransform(poseStack, arm, equipProcess);
                this.applyItemArmAttackTransform(poseStack, arm, swingProcess);
            }
            return true;
        }

        private void applyItemArmTransform(PoseStack poseStack, HumanoidArm arm, float equipProcess) {
            int i = arm == HumanoidArm.RIGHT ? 1 : -1;
            poseStack.m_85837_((double)((float)i * 0.56f), (double)(-0.52f + equipProcess * -0.6f), (double)-0.72f);
        }

        private void applyItemArmAttackTransform(PoseStack poseStack, HumanoidArm humanoidArm, float swingProcess) {
            int i = humanoidArm == HumanoidArm.RIGHT ? 1 : -1;
            float f = Mth.m_14031_((float)(swingProcess * swingProcess * (float)Math.PI));
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * (45.0f + f * -20.0f)));
            float f1 = Mth.m_14031_((float)(Mth.m_14116_((float)swingProcess) * (float)Math.PI));
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)i * f1 * -20.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(f1 * -80.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * -45.0f));
        }
    }
}

