/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.items.capabilities;

import com.mongoose.clanginghowl.common.items.handler.PortableChargerHandler;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class PortableChargerCapability
implements ICapabilitySerializable<Tag> {
    private final ItemStack stack;
    private final LazyOptional<IItemHandler> holder = LazyOptional.of(this::getHandler);
    private PortableChargerHandler handler;

    public PortableChargerCapability(ItemStack stack) {
        this.stack = stack;
    }

    @Nonnull
    private PortableChargerHandler getHandler() {
        if (this.handler == null) {
            this.handler = new PortableChargerHandler(this.stack);
        }
        return this.handler;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.holder);
    }

    public Tag serializeNBT() {
        return this.getHandler().serializeNBT();
    }

    public void deserializeNBT(Tag nbt) {
        this.getHandler().deserializeNBT((CompoundTag)nbt);
    }
}

