/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mongoose.clanginghowl.client.particles.CHParticleTypes;
import com.mongoose.clanginghowl.client.particles.RotationParticleOption;
import com.mongoose.clanginghowl.common.blocks.CHBlockStates;
import com.mongoose.clanginghowl.common.blocks.CHBlocks;
import com.mongoose.clanginghowl.common.blocks.CrystalFormerBlock;
import com.mongoose.clanginghowl.common.blocks.SteelBridgeBlock;
import com.mongoose.clanginghowl.utils.ItemHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class WrenchItem
extends Item {
    private final Multimap<Attribute, AttributeModifier> wrenchAttributes;

    public WrenchItem() {
        super(new Item.Properties().m_41503_(1200));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 6.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-2.6f, AttributeModifier.Operation.ADDITION));
        this.wrenchAttributes = builder.build();
    }

    public InteractionResult m_6225_(UseOnContext p_40529_) {
        Level level = p_40529_.m_43725_();
        BlockPos blockpos = p_40529_.m_8083_();
        Player player = p_40529_.m_43723_();
        BlockState blockstate = level.m_8055_(blockpos);
        ItemStack itemstack = p_40529_.m_43722_();
        BlockState result = null;
        if (blockstate.m_60713_((Block)CHBlocks.DAMAGED_STEEL_PLATE_BLOCK.get())) {
            result = ((Block)CHBlocks.STEEL_PLATE_BLOCK.get()).m_49966_();
        }
        if (blockstate.m_60713_((Block)CHBlocks.DAMAGED_CARVED_STEEL_PLATE_BLOCK.get())) {
            result = (BlockState)((Block)CHBlocks.CARVED_STEEL_PLATE_BLOCK.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)blockstate.m_61143_((Property)RotatedPillarBlock.f_55923_)));
        }
        if (blockstate.m_60713_((Block)CHBlocks.CRYSTAL_FORMER.get())) {
            result = (BlockState)blockstate.m_61122_((Property)CrystalFormerBlock.ENABLED);
        }
        if (blockstate.m_60713_((Block)CHBlocks.STEEL_BRIDGE.get())) {
            result = (BlockState)blockstate.m_61122_((Property)SteelBridgeBlock.ALTERNATE);
        }
        if (blockstate.m_60734_() instanceof StairBlock && blockstate.m_61138_((Property)StairBlock.f_56841_)) {
            result = (BlockState)blockstate.m_61122_((Property)StairBlock.f_56841_);
        }
        if (result != null) {
            Vec3 vec3 = blockpos.m_252807_();
            if (blockstate.m_61138_((Property)CHBlockStates.ALTERNATE)) {
                level.m_5594_(player, blockpos, SoundEvents.f_144119_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7106_((ParticleOptions)new RotationParticleOption(1.0f, 0), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0);
            } else if (blockstate.m_61138_((Property)BlockStateProperties.f_61431_)) {
                level.m_5594_(player, blockpos, SoundEvents.f_11762_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (blockstate.m_61138_((Property)StairBlock.f_56841_)) {
                if (player != null) {
                    player.m_36335_().m_41524_((Item)this, 5);
                }
                level.m_5594_(player, blockpos, SoundEvents.f_11762_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7106_((ParticleOptions)new RotationParticleOption(1.0f, 0), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0);
            } else {
                level.m_5594_(player, blockpos, SoundEvents.f_12009_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ItemHelper.hurtAndBreak(itemstack, 1, player);
                ParticleUtils.m_216313_((Level)level, (BlockPos)blockpos, (ParticleOptions)((ParticleOptions)CHParticleTypes.REPAIR.get()), (IntProvider)UniformInt.m_146622_((int)2, (int)4));
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, itemstack);
            }
            level.m_7731_(blockpos, result, 11);
            level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)result));
            if (player != null) {
                player.m_6674_(p_40529_.m_43724_());
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity target, InteractionHand hand) {
        if (!player.m_36335_().m_41519_((Item)this) && target instanceof IronGolem && target.m_21223_() < target.m_21233_()) {
            target.m_5634_(40.0f);
            target.m_5496_(SoundEvents.f_12009_, 1.0f, 1.0f);
            ItemHelper.hurtAndBreak(itemStack, 5, player);
            player.m_36335_().m_41524_((Item)this, 20);
            Level level = target.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 5; ++i) {
                    double d0 = serverLevel.f_46441_.m_188583_() * 0.02;
                    double d1 = serverLevel.f_46441_.m_188583_() * 0.02;
                    double d2 = serverLevel.f_46441_.m_188583_() * 0.02;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)CHParticleTypes.REPAIR.get()), target.m_20208_(0.5), target.m_20187_(), target.m_20262_(0.5), 0, d0, d1, d2, 0.5);
                }
            }
            player.m_6674_(hand);
        }
        return super.m_6880_(itemStack, player, target, hand);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack itemStack) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.wrenchAttributes : super.getAttributeModifiers(equipmentSlot, itemStack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        ItemHelper.addOnShift(tooltip, () -> this.addInformationAfterShift(tooltip));
    }

    public void addInformationAfterShift(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)"info.clanginghowl.item.wrench.0"));
        tooltip.add((Component)Component.m_237115_((String)"info.clanginghowl.item.wrench.1"));
    }
}

