/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.items;

import com.mongoose.clanginghowl.client.particles.CHParticleTypes;
import com.mongoose.clanginghowl.common.blocks.CHBlocks;
import com.mongoose.clanginghowl.common.items.CHTiers;
import com.mongoose.clanginghowl.utils.ItemHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class ExHammerItem
extends SwordItem {
    public ExHammerItem() {
        super((Tier)CHTiers.EXTRATERRESTRIAL, 6, -3.1f, new Item.Properties().m_41503_(1000));
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    @Nonnull
    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        ItemStack container = itemStack.m_41777_();
        if (container.m_41773_() <= container.m_41776_()) {
            container.m_41721_(itemStack.m_41773_() + 1);
        } else {
            container = ItemStack.f_41583_;
        }
        return container;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && slotChanged;
    }

    public InteractionResult m_6225_(UseOnContext p_40529_) {
        Level level = p_40529_.m_43725_();
        BlockPos blockpos = p_40529_.m_8083_();
        Player player = p_40529_.m_43723_();
        BlockState blockstate = level.m_8055_(blockpos);
        ItemStack itemstack = p_40529_.m_43722_();
        BlockState result = null;
        if (blockstate.m_60713_((Block)CHBlocks.STEEL_PLATE_BLOCK.get())) {
            result = ((Block)CHBlocks.DAMAGED_STEEL_PLATE_BLOCK.get()).m_49966_();
        }
        if (blockstate.m_60713_((Block)CHBlocks.CARVED_STEEL_PLATE_BLOCK.get())) {
            result = (BlockState)((Block)CHBlocks.DAMAGED_CARVED_STEEL_PLATE_BLOCK.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)blockstate.m_61143_((Property)RotatedPillarBlock.f_55923_)));
        }
        if (result != null) {
            level.m_5594_(player, blockpos, SoundEvents.f_12600_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, itemstack);
            }
            level.m_7731_(blockpos, result, 11);
            level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)result));
            ParticleUtils.m_216313_((Level)level, (BlockPos)blockpos, (ParticleOptions)((ParticleOptions)CHParticleTypes.BREAKDOWN_SMOKE.get()), (IntProvider)UniformInt.m_146622_((int)1, (int)3));
            if (player != null) {
                itemstack.m_41622_(1, (LivingEntity)player, p_150686_ -> p_150686_.m_21190_(p_40529_.m_43724_()));
                player.m_6674_(p_40529_.m_43724_());
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        ItemHelper.addOnShift(tooltip, () -> this.addInformationAfterShift(tooltip));
    }

    public void addInformationAfterShift(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)"info.clanginghowl.item.extraterrestrial"));
        tooltip.add((Component)Component.m_237115_((String)"info.clanginghowl.item.hammer"));
    }
}

