/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.events;

import com.google.common.collect.ImmutableList;
import com.mongoose.clanginghowl.client.particles.BloodSplashParticleOption;
import com.mongoose.clanginghowl.client.particles.CHParticleTypes;
import com.mongoose.clanginghowl.client.particles.ElectricShockParticleOption;
import com.mongoose.clanginghowl.client.particles.ElectricSplashParticleOption;
import com.mongoose.clanginghowl.client.particles.FieryExplosionParticleOption;
import com.mongoose.clanginghowl.common.capabilities.CHCapHelper;
import com.mongoose.clanginghowl.common.capabilities.CHCapProvider;
import com.mongoose.clanginghowl.common.capabilities.ICHCap;
import com.mongoose.clanginghowl.common.effects.CHEffects;
import com.mongoose.clanginghowl.common.enchantments.CHEnchantments;
import com.mongoose.clanginghowl.common.entities.CHEntityType;
import com.mongoose.clanginghowl.common.entities.hostiles.HeartOfDecay;
import com.mongoose.clanginghowl.common.items.BlazeBurnerItem;
import com.mongoose.clanginghowl.common.items.CHItems;
import com.mongoose.clanginghowl.common.items.CHTiers;
import com.mongoose.clanginghowl.common.items.energy.BatteryItem;
import com.mongoose.clanginghowl.common.items.energy.ChainswordItem;
import com.mongoose.clanginghowl.common.items.energy.EnergyItem;
import com.mongoose.clanginghowl.common.items.energy.IEnergyItem;
import com.mongoose.clanginghowl.common.network.CHNetwork;
import com.mongoose.clanginghowl.common.network.client.CIsMovingPacket;
import com.mongoose.clanginghowl.config.CHConfig;
import com.mongoose.clanginghowl.init.CHSounds;
import com.mongoose.clanginghowl.init.CHTags;
import com.mongoose.clanginghowl.utils.CHDamageSource;
import com.mongoose.clanginghowl.utils.EffectsUtil;
import com.mongoose.clanginghowl.utils.ItemHelper;
import com.mongoose.clanginghowl.utils.MobUtil;
import com.mongoose.clanginghowl.utils.NoKnockBackDamageSource;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="clanginghowl", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CHEvents {
    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        Player original = event.getOriginal();
        original.reviveCaps();
        ICHCap capability3 = CHCapHelper.getCapability((LivingEntity)original);
        player.getCapability(CHCapProvider.CAPABILITY).ifPresent(cap -> cap.setMiningProgress(0));
        player.getCapability(CHCapProvider.CAPABILITY).ifPresent(cap -> cap.setMiningPos(null));
    }

    @SubscribeEvent
    public static void TickEvent(LivingEvent.LivingTickEvent event) {
        MobEffectInstance instance;
        LivingEntity livingEntity = event.getEntity();
        if (CHCapHelper.getShakeTime(livingEntity) > 0) {
            CHCapHelper.setShakeTime(livingEntity, CHCapHelper.getShakeTime(livingEntity) - 1);
        }
        if (livingEntity.m_9236_().f_46443_) {
            CHNetwork.sendToServer(new CIsMovingPacket(livingEntity.m_19879_(), MobUtil.isMoving(livingEntity)));
        }
        if (livingEntity.m_21023_((MobEffect)CHEffects.OVERDRIVE.get()) && MobUtil.isWalking(livingEntity)) {
            livingEntity.m_9236_().m_7106_((ParticleOptions)CHParticleTypes.OVERDRIVE_FIRE.get(), livingEntity.m_20185_(), livingEntity.m_20186_() + 0.25, livingEntity.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (livingEntity.m_21023_((MobEffect)CHEffects.BEYOND_FLESH.get()) && (instance = livingEntity.m_21124_((MobEffect)CHEffects.BEYOND_FLESH.get())) != null) {
            int duration = instance.m_19557_();
            Level level = livingEntity.m_9236_();
            if (level instanceof ServerLevel) {
                Mob mob;
                ServerLevel serverLevel = (ServerLevel)level;
                if (duration % 200 == 0 || duration <= 100 && duration % 5 == 0) {
                    for (int i = 0; i < serverLevel.m_213780_().m_216332_(1, 3); ++i) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)CHParticleTypes.INFECTION.get()), livingEntity.m_20208_(0.5), livingEntity.m_20187_() + 0.5, livingEntity.m_20262_(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_6084_()) {
                    if (duration <= 100) {
                        if (CHCapHelper.getShakeTime((LivingEntity)mob) == 0) {
                            serverLevel.m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), (SoundEvent)CHSounds.FLESH_RUPTURE_BEGINNING.get(), mob.m_5720_(), 1.0f, 1.0f);
                        }
                        CHCapHelper.setShakeTime((LivingEntity)mob, 20);
                        mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 1, false, false));
                    }
                    if (duration <= 60) {
                        MobUtil.convertTechno(mob);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void AttackEvent(LivingAttackEvent event) {
        NoKnockBackDamageSource damageSource;
        LivingEntity victim = event.getEntity();
        DamageSource damageSource2 = event.getSource();
        if (damageSource2 instanceof NoKnockBackDamageSource && (damageSource = (NoKnockBackDamageSource)damageSource2).getOwner() != null) {
            OwnableEntity owned;
            LivingEntity livingEntity;
            Entity entity;
            if (damageSource.getOwner() instanceof LivingEntity && !damageSource.m_269533_(DamageTypeTags.f_268718_)) {
                victim.m_6703_((LivingEntity)damageSource.getOwner());
            }
            if ((entity = damageSource.getOwner()) instanceof Player) {
                Player player;
                victim.f_20888_ = player = (Player)entity;
                victim.f_20889_ = 100;
            }
            if (damageSource.getOwner() instanceof ServerPlayer) {
                CriteriaTriggers.f_10573_.m_60112_((ServerPlayer)damageSource.getOwner(), (Entity)victim, event.getSource(), event.getAmount(), event.getAmount(), false);
            }
            if ((entity = damageSource.getOwner()) instanceof OwnableEntity && (livingEntity = (owned = (OwnableEntity)entity).m_269323_()) instanceof Player) {
                Player player;
                victim.f_20888_ = player = (Player)livingEntity;
                victim.f_20889_ = 100;
            }
        }
    }

    @SubscribeEvent
    public static void HurtEvent(LivingHurtEvent event) {
        LivingEntity victim = event.getEntity();
        Entity directEntity = event.getSource().m_7640_();
        if (event.getAmount() > 0.0f) {
            MobEffectInstance mobEffectInstance;
            if (event.getSource().m_276093_(CHDamageSource.ICICLE) && victim.m_142079_()) {
                victim.m_146917_(460);
            }
            if (directEntity instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)directEntity;
                if (CHDamageSource.physicalAttacks(event.getSource())) {
                    TieredItem weapon;
                    Item item;
                    if (livingAttacker.m_21205_().m_41720_() instanceof BlazeBurnerItem && !livingAttacker.m_5825_() && !livingAttacker.m_21023_(MobEffects.f_19607_)) {
                        victim.m_7311_(120);
                        ItemHelper.hurtAndBreak(livingAttacker.m_21205_(), 1, livingAttacker);
                    }
                    if ((item = livingAttacker.m_21205_().m_41720_()) instanceof TieredItem && (weapon = (TieredItem)item).m_43314_() == CHTiers.EXTRATERRESTRIAL) {
                        victim.m_7292_(new MobEffectInstance((MobEffect)CHEffects.COSMIC_IRRADIATION.get(), 400));
                        if (victim.m_6095_().m_204039_(CHTags.EntityTypes.TECHNO_FLESH)) {
                            event.setAmount(event.getAmount() + 4.0f);
                        }
                    }
                    if (livingAttacker.m_21205_().m_41720_() instanceof ChainswordItem && victim.m_6095_().m_204039_(CHTags.EntityTypes.TECHNO_FLESH)) {
                        event.setAmount(event.getAmount() + 7.0f);
                    }
                }
            }
            if (victim.m_21023_((MobEffect)CHEffects.DEEP_BURN.get()) && (mobEffectInstance = victim.m_21124_((MobEffect)CHEffects.DEEP_BURN.get())) != null && event.getSource().m_269533_(DamageTypeTags.f_268745_)) {
                event.setAmount(event.getAmount() * 1.6f);
            }
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        LivingEntity victim = event.getEntity();
        if (event.getAmount() > 0.0f && CHCapHelper.getTechnoResist(victim) > 0.0f && !victim.m_6060_() && !event.getSource().m_269533_(DamageTypeTags.f_268630_)) {
            float percent = CHCapHelper.getTechnoResist(victim) / 100.0f;
            float calc = 1.0f - percent;
            event.setAmount(event.getAmount() * calc);
        }
    }

    @SubscribeEvent
    public static void onSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getEntity().m_6095_().m_204039_(CHTags.EntityTypes.TECHNO_FLESH) && ((Boolean)CHConfig.TechnoFleshBuff.get()).booleanValue()) {
            MobUtil.buffTechnoFlesh(event.getLevel().m_6018_(), (LivingEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        Level livingEntity3;
        Object serverLevel;
        Level player;
        LivingEntity victim = event.getEntity();
        Entity directEntity = event.getSource().m_7640_();
        if (CHDamageSource.physicalAttacks(event.getSource()) && directEntity instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)directEntity;
            if (CHDamageSource.physicalAttacks(event.getSource()) && livingAttacker.m_21205_().getEnchantmentLevel((Enchantment)CHEnchantments.KILLER_CHARGE.get()) > 0) {
                LivingEntity livingEntity22;
                for (LivingEntity livingEntity22 : livingAttacker.m_9236_().m_45976_(LivingEntity.class, victim.m_20191_().m_82400_(4.0))) {
                    if (MobUtil.areAllies((Entity)livingAttacker, (Entity)livingEntity22) || !EntitySelector.f_20406_.test(livingEntity22) || !livingEntity22.m_6469_(CHDamageSource.lightning((Entity)livingAttacker, (Entity)livingAttacker), 7.0f)) continue;
                    livingEntity22.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, 1));
                }
                livingAttacker.m_9236_().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), (SoundEvent)CHSounds.ELECTRIC_SHOCK.get(), livingAttacker.m_5720_(), 1.0f, 1.0f);
                livingEntity22 = livingAttacker.m_9236_();
                if (livingEntity22 instanceof ServerLevel) {
                    ServerLevel serverLevel2 = (ServerLevel)livingEntity22;
                    serverLevel2.m_8767_((ParticleOptions)new ElectricShockParticleOption(2.0f, 0), victim.m_20185_(), victim.m_20186_() + 2.0, victim.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    serverLevel2.m_8767_((ParticleOptions)new ElectricSplashParticleOption(4.0f, 0), victim.m_20185_(), victim.m_20186_() + 0.5, victim.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (livingAttacker instanceof Player) {
                    player = (Player)livingAttacker;
                    if (!player.m_9236_().f_46443_) {
                        Inventory inventory = player.m_150109_();
                        ImmutableList compartments = ImmutableList.of((Object)inventory.f_35974_, (Object)inventory.f_35975_, (Object)inventory.f_35976_);
                        for (List list : compartments) {
                            for (ItemStack itemStack : list) {
                                if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof IEnergyItem) || itemStack.m_41720_() instanceof BatteryItem || IEnergyItem.isFull(itemStack)) continue;
                                IEnergyItem.powerItem(itemStack, 40);
                            }
                        }
                    }
                }
            }
        }
        if (victim.m_21023_((MobEffect)CHEffects.INTERNAL_HEAT.get())) {
            victim.m_9236_().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), SoundEvents.f_11913_, victim.m_5720_(), 1.0f, 1.0f);
            player = victim.m_9236_();
            if (player instanceof ServerLevel) {
                serverLevel = (ServerLevel)player;
                serverLevel.m_8767_((ParticleOptions)new FieryExplosionParticleOption(3.0f, 0), victim.m_20185_(), victim.m_20186_() + 1.0, victim.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            for (Level livingEntity3 : victim.m_9236_().m_45976_(LivingEntity.class, victim.m_20191_().m_82400_(3.0))) {
                OwnableEntity ownable;
                if (!EntitySelector.f_20406_.test(livingEntity3) || livingEntity3 instanceof Player || livingEntity3 instanceof OwnableEntity && (ownable = (OwnableEntity)livingEntity3).m_269323_() instanceof Player || !livingEntity3.m_6469_(victim.m_9236_().m_269111_().m_269387_(), 5.0f)) continue;
                livingEntity3.m_7292_(new MobEffectInstance((MobEffect)CHEffects.INTERNAL_HEAT.get(), 500));
                livingEntity3.m_7311_(100);
            }
        }
        if ((livingEntity3 = victim.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)livingEntity3;
            if (victim.m_21023_((MobEffect)CHEffects.BEYOND_FLESH.get()) && !victim.m_6060_()) {
                serverLevel.m_8767_((ParticleOptions)new BloodSplashParticleOption(1.0f, 0), victim.m_20185_(), victim.m_20186_() + 1.0, victim.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                HeartOfDecay heartOfDecay = new HeartOfDecay((EntityType<? extends Spider>)((EntityType)CHEntityType.HEART_OF_DECAY.get()), victim.m_9236_());
                heartOfDecay.m_146884_(victim.m_20182_().m_82520_(0.0, 1.0, 0.0));
                ForgeEventFactory.onFinalizeSpawn((Mob)heartOfDecay, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.m_6436_(victim.m_20183_()), (MobSpawnType)MobSpawnType.TRIGGERED, null, null);
                heartOfDecay.m_5496_((SoundEvent)CHSounds.FLESH_TEAR.get(), 1.0f, 1.0f);
                serverLevel.m_7967_((Entity)heartOfDecay);
            }
        }
        if (!event.isCanceled()) {
            CHCapHelper.setShakeTime(victim, 0);
        }
    }

    @SubscribeEvent
    public static void onCritical(CriticalHitEvent event) {
        Entity entity;
        if ((event.isVanillaCritical() || event.getResult() == Event.Result.ALLOW) && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            ItemStack itemStack = event.getEntity().m_21205_();
            if (itemStack.m_41720_() instanceof ChainswordItem && !IEnergyItem.isEmpty(itemStack)) {
                if (!target.m_21023_((MobEffect)CHEffects.SAWING_UP_HEALTH.get())) {
                    target.m_7292_(new MobEffectInstance((MobEffect)CHEffects.SAWING_UP_HEALTH.get(), 500));
                } else {
                    EffectsUtil.amplifyEffect(target, (MobEffect)CHEffects.SAWING_UP_HEALTH.get(), 500);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onHeal(LivingHealEvent event) {
        if (event.getEntity().m_21023_((MobEffect)CHEffects.SAWING_UP_HEALTH.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level world = player.m_9236_();
        if (!(event.phase != TickEvent.Phase.END || player.m_6117_() && player.m_21211_().m_41720_() instanceof EnergyItem)) {
            EnergyItem.resetMiningProgress(world, player);
        }
    }

    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent.EntityInteract event) {
        int duration;
        MobEffectInstance instance;
        Mob mob;
        Entity entity;
        if (event.getLevel() instanceof ServerLevel && (entity = event.getTarget()) instanceof Mob && (mob = (Mob)entity).m_6084_() && !(mob instanceof Enemy) && mob.m_21023_((MobEffect)CHEffects.BEYOND_FLESH.get()) && (instance = mob.m_21124_((MobEffect)CHEffects.BEYOND_FLESH.get())) != null && (duration = instance.m_19557_()) > 100) {
            mob.m_21195_((MobEffect)CHEffects.BEYOND_FLESH.get());
            mob.m_7292_(new MobEffectInstance((MobEffect)CHEffects.BEYOND_FLESH.get(), 99, 0, false, false));
        }
    }

    @SubscribeEvent
    public static void onLightningStrike(EntityStruckByLightningEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack itemStack = player.m_150109_().m_8020_(i);
                if (!(itemStack.m_41720_() instanceof IEnergyItem) || itemStack.getEnchantmentLevel((Enchantment)CHEnchantments.ECOLOGICAL_ENERGY.get()) <= 0) continue;
                IEnergyItem.powerItem(itemStack, 400);
            }
        }
    }

    @SubscribeEvent
    public static void FurnaceBurnItems(FurnaceFuelBurnTimeEvent event) {
        ItemStack itemStack;
        if (!event.getItemStack().m_41619_() && (itemStack = event.getItemStack()).m_150930_((Item)CHItems.BLAZE_FUEL.get())) {
            event.setBurnTime(3200);
        }
    }

    @SubscribeEvent
    public static void PotionApplyEvents(MobEffectEvent.Applicable event) {
        ServerLevel serverLevel;
        Level level;
        LivingEntity livingEntity = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        if (instance.m_19544_() == CHEffects.OVERDRIVE.get() && (level = livingEntity.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (livingEntity.m_6084_() && !livingEntity.m_21023_((MobEffect)CHEffects.OVERDRIVE.get())) {
                serverLevel.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), (SoundEvent)CHSounds.CHAINSAW_OVERDRIVE.get(), livingEntity.m_5720_(), 1.0f, 1.0f);
            }
        }
        if (instance.m_19544_() == CHEffects.BEYOND_FLESH.get() && (level = livingEntity.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (livingEntity.m_6084_() && !livingEntity.m_21023_((MobEffect)CHEffects.BEYOND_FLESH.get())) {
                for (int i = 0; i < 20; ++i) {
                    double d0 = serverLevel.m_213780_().m_188583_() * 0.02;
                    double d1 = serverLevel.m_213780_().m_188583_() * 0.02;
                    double d2 = serverLevel.m_213780_().m_188583_() * 0.02;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)CHParticleTypes.CRIMSON_POOF.get()), livingEntity.m_20208_(1.0), livingEntity.m_20187_(), livingEntity.m_20262_(1.0), 0, d0, d1, d2, 1.0);
                }
            }
        }
    }
}

