/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.entities.hostiles;

import com.mongoose.clanginghowl.common.effects.CHEffects;
import com.mongoose.clanginghowl.common.entities.projectiles.SpitProjectile;
import com.mongoose.clanginghowl.config.CHConfig;
import com.mongoose.clanginghowl.init.CHSounds;
import com.mongoose.clanginghowl.init.CHTags;
import com.mongoose.clanginghowl.utils.CHUUIDUtil;
import com.mongoose.clanginghowl.utils.MathHelper;
import com.mongoose.clanginghowl.utils.MobUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HeartOfDecay
extends Spider
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(HeartOfDecay.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static AttributeModifier SHOOT_SPEED_MODIFIER = new AttributeModifier(CHUUIDUtil.createUUID("entity.clanginghowl.heart_of_decay.immobile"), "Shooting speed penalty", -1.0, AttributeModifier.Operation.ADDITION);
    public static String IDLE = "idle";
    public static String ATTACK = "attack";
    public static String SPIT = "spit";
    public static String APPEAR = "appear";
    public int isAppearTick;
    public int attackTick;
    public int spitCool;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState spitAnimationState = new AnimationState();
    public AnimationState appearAnimationState = new AnimationState();

    public HeartOfDecay(EntityType<? extends Spider> p_33786_, Level p_33787_) {
        super(p_33786_, p_33787_);
        this.f_21364_ = 4;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25){

            protected boolean m_202729_() {
                return this.f_25684_.m_6060_();
            }
        });
        this.f_21345_.m_25352_(2, new WebShootGoal<HeartOfDecay>(this));
        this.f_21345_.m_25352_(4, (Goal)new HoDAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new HoDTargetGoal<Player>(this, Player.class));
        this.f_21346_.m_25352_(2, new HoDTargetGoal<LivingEntity>(this, LivingEntity.class, livingEntity -> MobUtil.isTechnoConvert(livingEntity) && !livingEntity.m_21023_((MobEffect)CHEffects.BEYOND_FLESH.get())));
        this.f_21346_.m_25352_(3, new HoDTargetGoal<IronGolem>(this, IronGolem.class));
    }

    public static AttributeSupplier.Builder m_33815_() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("SpitCool", this.spitCool);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("SpitCool")) {
            this.spitCool = pCompound.m_128451_("SpitCool");
        }
    }

    public boolean m_7307_(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return true;
        }
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity.m_6095_().m_204039_(CHTags.EntityTypes.TECHNO_FLESH)) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    public static boolean checkHoDSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos blockPos, RandomSource randomSource) {
        if ((Integer)CHConfig.HoDDaySpawn.get() >= 0 && levelAccessor.m_8044_() >= (long)MathHelper.minecraftDayToTicks((Integer)CHConfig.HoDDaySpawn.get())) {
            return levelAccessor.m_46791_() != Difficulty.PEACEFUL && HeartOfDecay.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)blockPos, (RandomSource)randomSource) && HeartOfDecay.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)blockPos, (RandomSource)randomSource);
        }
        return false;
    }

    public boolean m_6779_(LivingEntity p_21171_) {
        return super.m_6779_(p_21171_) && !p_21171_.m_21023_((MobEffect)CHEffects.BEYOND_FLESH.get());
    }

    public void m_8032_() {
    }

    protected SoundEvent m_7975_(DamageSource p_33814_) {
        return (SoundEvent)CHSounds.TECHNO_FLESH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CHSounds.HEART_OF_DECAY_DEATH.get();
    }

    protected PathNavigation m_6037_(Level p_33802_) {
        return new WallClimberNavigation((Mob)this, p_33802_);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, IDLE)) {
            return 0;
        }
        if (Objects.equals(animation, ATTACK)) {
            return 1;
        }
        if (Objects.equals(animation, SPIT)) {
            return 2;
        }
        if (Objects.equals(animation, APPEAR)) {
            return 3;
        }
        return 0;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAnimations()) {
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public boolean isCurrentAnimation(String animation) {
        return this.getCurrentAnimation() == this.getAnimationState(animation);
    }

    public void m_7350_(EntityDataAccessor<?> p_219422_) {
        if (ANIM_STATE.equals(p_219422_) && this.m_9236_().f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.stopAllAnimation();
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimation();
                    this.spitAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimation();
                    this.appearAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_219422_);
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.spitAnimationState);
        animationStates.add(this.appearAnimationState);
        return animationStates;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.m_217003_(Pose.EMERGING) ? 1 : 0);
    }

    public void m_141965_(ClientboundAddEntityPacket p_219420_) {
        super.m_141965_(p_219420_);
        if (p_219420_.m_131509_() == 1) {
            this.m_20124_(Pose.EMERGING);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_20124_(Pose.EMERGING);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected float m_6431_(Pose p_33799_, EntityDimensions p_33800_) {
        return p_33800_.f_20378_ * 0.85f;
    }

    public boolean isMeleeAttacking() {
        return this.attackTick > 0;
    }

    public boolean isAppearing() {
        return this.m_217003_(Pose.EMERGING);
    }

    public void shootSpit() {
        SpitProjectile snowball = new SpitProjectile((LivingEntity)this, this.m_9236_());
        Vec3 vector3d = this.m_20252_(1.0f);
        snowball.m_6034_(this.m_20185_() + vector3d.f_82479_ / 2.0, this.m_20188_() - 0.2, this.m_20189_() + vector3d.f_82481_ / 2.0);
        if (this.m_5448_() != null) {
            double d0 = this.m_5448_().m_20185_() - this.m_20185_();
            double d1 = this.m_5448_().m_20186_() - this.m_20186_();
            double d2 = this.m_5448_().m_20189_() - this.m_20189_();
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            snowball.m_6686_(d0, d1 + 0.25, d2, 1.6f, 1.0f);
        } else {
            snowball.m_37251_((Entity)this, this.m_146909_(), this.m_146908_(), 0.0f, 1.6f, 1.0f);
        }
        this.m_5496_(SoundEvents.f_12098_, 1.0f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)snowball);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_217003_(Pose.EMERGING)) {
            ++this.isAppearTick;
            if (this.isAppearTick > MathHelper.secondsToTicks(0.5f)) {
                this.setAnimationState(IDLE);
                this.m_20124_(Pose.STANDING);
            } else {
                this.setAnimationState(APPEAR);
            }
        }
        if (this.m_9236_().f_46443_) {
            this.idleAnimationState.m_246184_(!this.f_267362_.m_267780_() && this.isCurrentAnimation(IDLE), this.f_19797_);
        }
        if (!this.m_9236_().f_46443_) {
            if (this.spitCool > 0) {
                --this.spitCool;
            }
            if (this.attackTick > 0) {
                --this.attackTick;
            } else if (this.isCurrentAnimation(ATTACK)) {
                this.setAnimationState(IDLE);
            }
            AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22279_);
            if (this.isCurrentAnimation(SPIT)) {
                if (modifiableattributeinstance != null) {
                    modifiableattributeinstance.m_22130_(SHOOT_SPEED_MODIFIER);
                    modifiableattributeinstance.m_22118_(SHOOT_SPEED_MODIFIER);
                }
            } else if (modifiableattributeinstance != null && modifiableattributeinstance.m_22109_(SHOOT_SPEED_MODIFIER)) {
                modifiableattributeinstance.m_22130_(SHOOT_SPEED_MODIFIER);
            }
        }
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (!this.m_9236_().f_46443_ && flag) {
            LivingEntity livingEntity;
            this.attackTick = 10;
            this.setAnimationState(ATTACK);
            if (entityIn instanceof LivingEntity && MobUtil.isTechnoConvert(livingEntity = (LivingEntity)entityIn)) {
                this.m_5496_((SoundEvent)CHSounds.INFECT.get(), 1.0f, 1.0f);
                int time = 1000;
                if (livingEntity instanceof Zombie) {
                    time = 300;
                } else if (livingEntity instanceof AbstractVillager) {
                    time = 12000;
                } else if (livingEntity instanceof AbstractIllager) {
                    time = 500;
                }
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)CHEffects.BEYOND_FLESH.get(), time, 0, false, false));
                this.m_146870_();
            }
        }
        return flag;
    }

    public void m_6504_(LivingEntity p_33317_, float p_33318_) {
        this.shootSpit();
    }

    public static class WebShootGoal<T extends HeartOfDecay>
    extends Goal {
        private final T mob;
        public int attackTick;
        @Nullable
        private LivingEntity target;

        public WebShootGoal(T mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null && livingentity.m_6084_() && !MobUtil.isTechnoConvert(livingentity) && !this.mob.m_6060_() && !((HeartOfDecay)((Object)this.mob)).isAppearing() && !((HeartOfDecay)((Object)this.mob)).isMeleeAttacking() && ((HeartOfDecay)((Object)this.mob)).spitCool <= 0 && this.mob.m_142582_((Entity)livingentity)) {
                this.target = livingentity;
                return this.mob.m_20270_((Entity)livingentity) > 4.0f && this.mob.m_20270_((Entity)livingentity) <= 12.0f;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.attackTick < 20;
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.m_21573_().m_26573_();
            ((HeartOfDecay)((Object)this.mob)).shootSpit();
            ((HeartOfDecay)((Object)this.mob)).setAnimationState(SPIT);
        }

        public void m_8041_() {
            this.target = null;
            this.attackTick = 0;
            ((HeartOfDecay)((Object)this.mob)).spitCool = 160;
            ((HeartOfDecay)((Object)this.mob)).setAnimationState(IDLE);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            ++this.attackTick;
            this.mob.m_21573_().m_26573_();
            ((HeartOfDecay)this.mob).f_21342_.m_24988_(0.0f, 0.0f);
            if (this.target != null) {
                MobUtil.instaLook(this.mob, (Entity)this.target);
            }
        }
    }

    static class HoDAttackGoal
    extends MeleeAttackGoal {
        public HeartOfDecay heartOfDecay;

        public HoDAttackGoal(HeartOfDecay p_33822_) {
            super((PathfinderMob)p_33822_, (double)1.1f, true);
            this.heartOfDecay = p_33822_;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.f_25540_.m_20160_() && !this.heartOfDecay.isAppearing() && !this.heartOfDecay.m_6060_() && this.f_25540_.m_5448_() != null;
        }

        public boolean m_8045_() {
            if (this.f_25540_.m_6060_()) {
                this.f_25540_.m_6710_(null);
                return false;
            }
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity p_33825_) {
            return 4.0f + p_33825_.m_20205_();
        }
    }

    static class HoDTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public HoDTargetGoal(HeartOfDecay p_33832_, Class<T> p_33833_) {
            super((Mob)p_33832_, p_33833_, true);
        }

        public HoDTargetGoal(HeartOfDecay p_199891_, Class<T> p_199892_, Predicate<LivingEntity> p_199894_) {
            super((Mob)p_199891_, p_199892_, 10, true, false, p_199894_);
        }

        public boolean m_8036_() {
            return !this.f_26135_.m_6060_() && super.m_8036_();
        }
    }
}

