/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.entities.hostiles;

import com.mongoose.clanginghowl.common.effects.CHEffects;
import com.mongoose.clanginghowl.common.entities.ai.ModMeleeAttackGoal;
import com.mongoose.clanginghowl.config.CHConfig;
import com.mongoose.clanginghowl.init.CHSounds;
import com.mongoose.clanginghowl.init.CHTags;
import com.mongoose.clanginghowl.utils.MathHelper;
import com.mongoose.clanginghowl.utils.MobUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FleshMaiden
extends Monster {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(FleshMaiden.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static String IDLE = "idle";
    public static String ATTACK = "attack";
    public static String LONG_ATTACK = "long_attack";
    public static String APPEAR = "appear";
    public int isAppearTick;
    public int attackTick;
    public int longAttackCool;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState longAttackAnimationState = new AnimationState();
    public AnimationState appearAnimationState = new AnimationState();

    public FleshMaiden(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new LongAttackGoal(this, 1.2, false));
        this.f_21345_.m_25352_(2, (Goal)new MaidenAttackGoal(this, 1.2, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22281_, 9.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("LongAttackCool", this.longAttackCool);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("LongAttackCool")) {
            this.longAttackCool = pCompound.m_128451_("LongAttackCool");
        }
    }

    public boolean m_6779_(LivingEntity p_21171_) {
        return super.m_6779_(p_21171_) && !p_21171_.m_21023_((MobEffect)CHEffects.BEYOND_FLESH.get());
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)CHSounds.TECHNO_FLESH_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return (SoundEvent)CHSounds.TECHNO_FLESH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CHSounds.FLESH_MAIDEN_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)CHSounds.TECHNO_FLESH_STEP.get();
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public boolean m_7307_(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return true;
        }
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity.m_6095_().m_204039_(CHTags.EntityTypes.TECHNO_FLESH)) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    public static boolean checkFleshMaidenSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos blockPos, RandomSource randomSource) {
        if ((Integer)CHConfig.FleshMaidenDaySpawn.get() >= 0 && levelAccessor.m_8044_() >= (long)MathHelper.minecraftDayToTicks((Integer)CHConfig.FleshMaidenDaySpawn.get())) {
            return levelAccessor.m_46791_() != Difficulty.PEACEFUL && FleshMaiden.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)blockPos, (RandomSource)randomSource) && FleshMaiden.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)blockPos, (RandomSource)randomSource);
        }
        return false;
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, IDLE)) {
            return 0;
        }
        if (Objects.equals(animation, ATTACK)) {
            return 1;
        }
        if (Objects.equals(animation, LONG_ATTACK)) {
            return 2;
        }
        if (Objects.equals(animation, APPEAR)) {
            return 3;
        }
        return 0;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAnimations()) {
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public boolean isCurrentAnimation(String animation) {
        return this.getCurrentAnimation() == this.getAnimationState(animation);
    }

    public void m_7350_(EntityDataAccessor<?> p_219422_) {
        if (ANIM_STATE.equals(p_219422_) && this.m_9236_().f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.stopAllAnimation();
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimation();
                    this.longAttackAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimation();
                    this.appearAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_219422_);
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.longAttackAnimationState);
        animationStates.add(this.appearAnimationState);
        return animationStates;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.m_217003_(Pose.EMERGING) ? 1 : 0);
    }

    public void m_141965_(ClientboundAddEntityPacket p_219420_) {
        super.m_141965_(p_219420_);
        if (p_219420_.m_131509_() == 1) {
            this.m_20124_(Pose.EMERGING);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_20124_(Pose.EMERGING);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_217003_(Pose.EMERGING)) {
            ++this.isAppearTick;
            if (this.isAppearTick > MathHelper.secondsToTicks(0.5f)) {
                this.setAnimationState(IDLE);
                this.m_20124_(Pose.STANDING);
            } else {
                this.setAnimationState(APPEAR);
            }
        }
        if (this.m_9236_().f_46443_) {
            this.idleAnimationState.m_246184_(!this.f_267362_.m_267780_() && this.isCurrentAnimation(IDLE), this.f_19797_);
        }
        if (!this.m_9236_().f_46443_) {
            if (this.m_5448_() != null) {
                this.m_21561_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)4);
            } else {
                this.m_21561_(false);
                this.m_9236_().m_7605_((Entity)this, (byte)5);
            }
            if (this.attackTick > 0) {
                --this.attackTick;
                if (this.m_5448_() != null && this.attackTick == 10) {
                    if (this.m_217066_(this.m_5448_())) {
                        this.m_7327_((Entity)this.m_5448_());
                    }
                    if (this.isCurrentAnimation(LONG_ATTACK)) {
                        this.longAttackCool = 120;
                    }
                }
            } else if (this.isCurrentAnimation(ATTACK) || this.isCurrentAnimation(LONG_ATTACK)) {
                this.setAnimationState(IDLE);
            }
            if (this.longAttackCool > 0) {
                --this.longAttackCool;
            }
        }
    }

    public double m_142593_(LivingEntity target) {
        if (this.isCurrentAnimation(LONG_ATTACK)) {
            return super.m_142593_(target) * 4.0;
        }
        return super.m_142593_(target);
    }

    public void m_7822_(byte pByte) {
        if (pByte == 4) {
            this.m_21561_(true);
        } else if (pByte == 5) {
            this.m_21561_(false);
        } else {
            super.m_7822_(pByte);
        }
    }

    public static class LongAttackGoal
    extends ModMeleeAttackGoal {
        public FleshMaiden maiden;

        public LongAttackGoal(FleshMaiden p_25552_, double p_25553_, boolean p_25554_) {
            super((PathfinderMob)p_25552_, p_25553_, p_25554_);
            this.maiden = p_25552_;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && this.maiden.longAttackCool <= 0;
        }

        @Override
        protected void checkAndPerformAttack(LivingEntity target, double distance) {
            double d0;
            if (this.maiden.isCurrentAnimation(IDLE) && distance <= (d0 = this.getAttackReachSqr(target)) && this.isTimeToAttack()) {
                MobUtil.instaLook((Mob)this.mob, (Entity)target);
                this.maiden.attackTick = 15;
                this.maiden.m_5496_((SoundEvent)CHSounds.FLESH_WHIPPING.get(), this.maiden.m_6121_(), this.maiden.m_6100_());
                this.maiden.setAnimationState(LONG_ATTACK);
            }
        }

        @Override
        protected double getAttackReachSqr(LivingEntity target) {
            return this.defaultAttackReachSqr(target) * 4.0;
        }
    }

    public static class MaidenAttackGoal
    extends ModMeleeAttackGoal {
        public FleshMaiden maiden;

        public MaidenAttackGoal(FleshMaiden p_25552_, double p_25553_, boolean p_25554_) {
            super((PathfinderMob)p_25552_, p_25553_, p_25554_);
            this.maiden = p_25552_;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && this.maiden.longAttackCool > 0;
        }

        @Override
        protected void checkAndPerformAttack(LivingEntity target, double distance) {
            double d0;
            if (this.maiden.isCurrentAnimation(IDLE) && distance <= (d0 = this.getAttackReachSqr(target)) && this.isTimeToAttack()) {
                this.maiden.attackTick = 15;
                this.maiden.setAnimationState(ATTACK);
            }
        }
    }
}

