/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.entities.hostiles;

import com.mongoose.clanginghowl.common.effects.CHEffects;
import com.mongoose.clanginghowl.common.entities.ai.ModMeleeAttackGoal;
import com.mongoose.clanginghowl.config.CHConfig;
import com.mongoose.clanginghowl.init.CHSounds;
import com.mongoose.clanginghowl.init.CHTags;
import com.mongoose.clanginghowl.utils.MathHelper;
import com.mongoose.clanginghowl.utils.MobUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ExReaper
extends Monster {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(ExReaper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static String IDLE = "idle";
    public static String ATTACK = "attack";
    public static String INFECT = "infect";
    public static String APPEAR = "appear";
    public int isAppearTick;
    public int attackTick;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState infectAnimationState = new AnimationState();
    public AnimationState appearAnimationState = new AnimationState();

    public ExReaper(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.f_21364_ = 6;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new ModMeleeAttackGoal((PathfinderMob)this, 1.2, false){

            @Override
            protected void checkAndPerformAttack(LivingEntity p_25557_, double p_25558_) {
                double d0;
                if (ExReaper.this.isCurrentAnimation(IDLE) && p_25558_ <= (d0 = this.getAttackReachSqr(p_25557_))) {
                    Mob mob1;
                    ExReaper.this.attackTick = 15;
                    boolean infect = false;
                    LivingEntity livingEntity = ExReaper.this.m_5448_();
                    if (livingEntity instanceof Mob && MobUtil.isReaperConvert((LivingEntity)(mob1 = (Mob)livingEntity)) && mob1.m_5448_() != ExReaper.this) {
                        infect = true;
                    }
                    if (!infect) {
                        ExReaper.this.setAnimationState(ATTACK);
                    } else {
                        ExReaper.this.setAnimationState(INFECT);
                    }
                }
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, livingEntity -> MobUtil.isReaperConvert(livingEntity) && !livingEntity.m_21023_((MobEffect)CHEffects.BEYOND_FLESH.get())));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.24).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22284_, 7.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    public boolean m_7307_(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return true;
        }
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity.m_6095_().m_204039_(CHTags.EntityTypes.TECHNO_FLESH)) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    public static boolean checkExReaperSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos blockPos, RandomSource randomSource) {
        if ((Integer)CHConfig.ExReaperDaySpawn.get() >= 0 && levelAccessor.m_8044_() >= (long)MathHelper.minecraftDayToTicks((Integer)CHConfig.ExReaperDaySpawn.get())) {
            return levelAccessor.m_46791_() != Difficulty.PEACEFUL && ExReaper.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)blockPos, (RandomSource)randomSource) && ExReaper.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)blockPos, (RandomSource)randomSource);
        }
        return false;
    }

    public boolean m_6779_(LivingEntity p_21171_) {
        return super.m_6779_(p_21171_) && !p_21171_.m_21023_((MobEffect)CHEffects.BEYOND_FLESH.get());
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)CHSounds.TECHNO_FLESH_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return (SoundEvent)CHSounds.TECHNO_FLESH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CHSounds.TECHNO_FLESH_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)CHSounds.TECHNO_FLESH_STEP.get();
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, IDLE)) {
            return 0;
        }
        if (Objects.equals(animation, ATTACK)) {
            return 1;
        }
        if (Objects.equals(animation, INFECT)) {
            return 2;
        }
        if (Objects.equals(animation, APPEAR)) {
            return 3;
        }
        return 0;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAnimations()) {
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public boolean isCurrentAnimation(String animation) {
        return this.getCurrentAnimation() == this.getAnimationState(animation);
    }

    public void m_7350_(EntityDataAccessor<?> p_219422_) {
        if (ANIM_STATE.equals(p_219422_) && this.m_9236_().f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.stopAllAnimation();
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimation();
                    this.infectAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimation();
                    this.appearAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_219422_);
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.infectAnimationState);
        animationStates.add(this.appearAnimationState);
        return animationStates;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.m_217003_(Pose.EMERGING) ? 1 : 0);
    }

    public void m_141965_(ClientboundAddEntityPacket p_219420_) {
        super.m_141965_(p_219420_);
        if (p_219420_.m_131509_() == 1) {
            this.m_20124_(Pose.EMERGING);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_20124_(Pose.EMERGING);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_217003_(Pose.EMERGING)) {
            ++this.isAppearTick;
            if (this.isAppearTick > MathHelper.secondsToTicks(0.5f)) {
                this.setAnimationState(IDLE);
                this.m_20124_(Pose.STANDING);
            } else {
                this.setAnimationState(APPEAR);
            }
        }
        if (this.m_9236_().f_46443_) {
            this.idleAnimationState.m_246184_(!this.f_267362_.m_267780_() && this.isCurrentAnimation(IDLE), this.f_19797_);
        }
        if (!this.m_9236_().f_46443_) {
            if (this.attackTick > 0) {
                this.m_21573_().m_26573_();
                this.f_21342_.m_24988_(0.0f, 0.0f);
                --this.attackTick;
                if (this.m_5448_() != null && this.attackTick == 10 && this.m_217066_(this.m_5448_())) {
                    this.m_7327_((Entity)this.m_5448_());
                }
            } else if (this.isCurrentAnimation(ATTACK) || this.isCurrentAnimation(INFECT)) {
                this.setAnimationState(IDLE);
            }
        }
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (!this.m_9236_().f_46443_ && flag && this.isCurrentAnimation(INFECT)) {
            this.m_5496_((SoundEvent)CHSounds.INJECT.get(), 1.0f, 1.0f);
            this.setAnimationState(INFECT);
            LivingEntity livingEntity = (LivingEntity)entityIn;
            int time = 300;
            if (livingEntity instanceof AbstractVillager) {
                time = 12000;
            } else if (livingEntity instanceof AbstractIllager) {
                time = 500;
            }
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)CHEffects.BEYOND_FLESH.get(), time, 0, false, false));
            this.m_6710_(null);
            if (livingEntity instanceof Mob) {
                Mob mob = (Mob)livingEntity;
                mob.m_6710_(null);
                mob.m_6703_(null);
            }
        }
        return flag;
    }
}

