/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.capabilities;

import com.mongoose.clanginghowl.ClangingHowl;
import com.mongoose.clanginghowl.common.capabilities.CHCapHelper;
import com.mongoose.clanginghowl.common.capabilities.CHCapProvider;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class CHCapUpdatePacket {
    private final int entityID;
    private CompoundTag tag;

    public CHCapUpdatePacket(int id, CompoundTag tag) {
        this.entityID = id;
        this.tag = tag;
    }

    public CHCapUpdatePacket(LivingEntity living) {
        this.entityID = living.m_19879_();
        living.getCapability(CHCapProvider.CAPABILITY, null).ifPresent(soulEnergy -> {
            this.tag = CHCapHelper.save(new CompoundTag(), soulEnergy);
        });
    }

    public static void encode(CHCapUpdatePacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.entityID);
        buffer.m_130079_(packet.tag);
    }

    public static CHCapUpdatePacket decode(FriendlyByteBuf buffer) {
        return new CHCapUpdatePacket(buffer.readInt(), buffer.m_130260_());
    }

    public static void consume(CHCapUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientLevel clientLevel;
            Entity entity;
            Level level;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT && (level = ClangingHowl.PROXY.getLevel()) instanceof ClientLevel && (entity = (clientLevel = (ClientLevel)level).m_6815_(packet.entityID)) != null) {
                entity.getCapability(CHCapProvider.CAPABILITY).ifPresent(misc -> CHCapHelper.load(packet.tag, misc));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

