/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.capabilities;

import com.mongoose.clanginghowl.common.capabilities.CHCapImp;
import com.mongoose.clanginghowl.common.capabilities.CHCapProvider;
import com.mongoose.clanginghowl.common.capabilities.CHCapUpdatePacket;
import com.mongoose.clanginghowl.common.capabilities.ICHCap;
import com.mongoose.clanginghowl.common.network.CHNetwork;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class CHCapHelper {
    public static ICHCap getCapability(LivingEntity player) {
        return (ICHCap)player.getCapability(CHCapProvider.CAPABILITY).orElse((Object)new CHCapImp());
    }

    public static int getMiningProgress(Player player) {
        return CHCapHelper.getCapability((LivingEntity)player).getMiningProgress();
    }

    public static void setMiningProgress(Player player, int progress) {
        CHCapHelper.getCapability((LivingEntity)player).setMiningProgress(progress);
    }

    public static void increaseMiningProgress(Player player) {
        CHCapHelper.setMiningProgress(player, CHCapHelper.getMiningProgress(player) + 1);
    }

    @Nullable
    public static BlockPos getMiningPos(Player player) {
        return CHCapHelper.getCapability((LivingEntity)player).getMiningPos();
    }

    public static void setMiningPos(Player player, BlockPos blockPos) {
        CHCapHelper.getCapability((LivingEntity)player).setMiningPos(blockPos);
    }

    public static int getShakeTime(LivingEntity livingEntity) {
        return CHCapHelper.getCapability(livingEntity).getShakeTime();
    }

    public static void setShakeTime(LivingEntity livingEntity, int ticks) {
        CHCapHelper.getCapability(livingEntity).setShakeTime(ticks);
        CHCapHelper.sendCHCapUpdatePacket(livingEntity);
    }

    public static boolean isMoving(LivingEntity livingEntity) {
        return CHCapHelper.getCapability(livingEntity).isMoving();
    }

    public static void setMoving(LivingEntity livingEntity, boolean moving) {
        CHCapHelper.getCapability(livingEntity).setMoving(moving);
    }

    public static float getTechnoResist(LivingEntity livingEntity) {
        return CHCapHelper.getCapability(livingEntity).technoResist();
    }

    public static void setTechnoResist(LivingEntity livingEntity, float resist) {
        CHCapHelper.getCapability(livingEntity).setTechnoResist(resist);
        CHCapHelper.sendCHCapUpdatePacket(livingEntity);
    }

    public static void sendCHCapUpdatePacket(LivingEntity livingEntity) {
        if (!livingEntity.m_9236_().m_5776_()) {
            CHNetwork.sentToTrackingEntityAndPlayer((Entity)livingEntity, new CHCapUpdatePacket(livingEntity));
        }
    }

    public static CompoundTag save(CompoundTag tag, ICHCap cap) {
        if (cap.getMiningPos() != null) {
            tag.m_128405_("miningPosX", cap.getMiningPos().m_123341_());
            tag.m_128405_("miningPosY", cap.getMiningPos().m_123342_());
            tag.m_128405_("miningPosZ", cap.getMiningPos().m_123343_());
        }
        if (cap.getMiningProgress() > 0) {
            tag.m_128405_("miningProgress", cap.getMiningProgress());
        }
        tag.m_128405_("shakeTime", cap.getShakeTime());
        tag.m_128379_("isMoving", cap.isMoving());
        if (cap.technoResist() > 0.0f) {
            tag.m_128350_("technoResist", cap.technoResist());
        }
        return tag;
    }

    public static ICHCap load(CompoundTag tag, ICHCap cap) {
        if (tag.m_128441_("miningPosX") && tag.m_128441_("miningPosY") && tag.m_128441_("miningPosZ")) {
            cap.setMiningPos(new BlockPos(tag.m_128451_("miningPosX"), tag.m_128451_("miningPosY"), tag.m_128451_("miningPosZ")));
        }
        if (tag.m_128441_("miningProgress")) {
            cap.setMiningProgress(tag.m_128451_("miningProgress"));
        }
        if (tag.m_128441_("shakeTime")) {
            cap.setShakeTime(tag.m_128451_("shakeTime"));
        }
        if (tag.m_128441_("isMoving")) {
            cap.setMoving(tag.m_128471_("isMoving"));
        }
        if (tag.m_128441_("technoResist")) {
            cap.setTechnoResist(tag.m_128457_("technoResist"));
        }
        return cap;
    }
}

