/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.blocks.entities;

import com.mongoose.clanginghowl.client.particles.CHParticleTypes;
import com.mongoose.clanginghowl.common.blocks.entities.CHBlockEntities;
import com.mongoose.clanginghowl.common.entities.CHEntityType;
import com.mongoose.clanginghowl.common.entities.hostiles.HeartOfDecay;
import com.mongoose.clanginghowl.init.CHSounds;
import java.util.ArrayList;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;

public class FleshNestBlockEntity
extends BlockEntity {
    public int tickTime;

    public FleshNestBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)CHBlockEntities.TECHNOFLESH_NEST.get(), p_155229_, p_155230_);
    }

    public void tick() {
        Level level;
        if (this.f_58857_ != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.f_58857_.m_46791_() != Difficulty.PEACEFUL) {
                int speed = 1;
                if (this.isNearPlayer((Level)serverLevel, this.f_58858_)) {
                    ++speed;
                }
                this.tickTime += speed;
                if (this.tickTime >= 1500) {
                    this.spawn(serverLevel);
                }
            }
        }
    }

    public void spawn(ServerLevel serverLevel) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        for (Direction direction : Direction.values()) {
            BlockPos blockPos = this.f_58858_.m_121945_(direction);
            if (!serverLevel.m_45772_(((EntityType)CHEntityType.HEART_OF_DECAY.get()).m_20585_((double)((float)blockPos.m_123341_() + 0.5f), (double)blockPos.m_123342_(), (double)((float)blockPos.m_123343_() + 0.5f)))) continue;
            directions.add(direction);
        }
        if (!directions.isEmpty()) {
            Direction direction = (Direction)Util.m_214621_(directions, (RandomSource)serverLevel.m_213780_());
            BlockPos blockPos = this.f_58858_.m_121945_(direction);
            HeartOfDecay hod = new HeartOfDecay((EntityType<? extends Spider>)((EntityType)CHEntityType.HEART_OF_DECAY.get()), this.f_58857_);
            hod.m_146884_(blockPos.m_252807_());
            for (int i = 0; i < 20; ++i) {
                double d0 = serverLevel.m_213780_().m_188583_() * 0.02;
                double d1 = serverLevel.m_213780_().m_188583_() * 0.02;
                double d2 = serverLevel.m_213780_().m_188583_() * 0.02;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)CHParticleTypes.CRIMSON_POOF.get()), hod.m_20208_(1.0), hod.m_20187_(), hod.m_20262_(1.0), 0, d0, d1, d2, 1.0);
            }
            ForgeEventFactory.onFinalizeSpawn((Mob)hod, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.m_6436_(this.f_58858_), (MobSpawnType)MobSpawnType.SPAWNER, null, null);
            if (serverLevel.m_7967_((Entity)hod)) {
                serverLevel.m_6263_(null, hod.m_20185_(), hod.m_20186_(), hod.m_20189_(), (SoundEvent)CHSounds.FLESH_TEAR.get(), hod.m_5720_(), 1.0f, 1.0f);
            }
        }
        this.tickTime = 0;
    }

    private boolean isNearPlayer(Level p_151344_, BlockPos p_151345_) {
        return p_151344_.m_45914_((double)p_151345_.m_123341_() + 0.5, (double)p_151345_.m_123342_() + 0.5, (double)p_151345_.m_123343_() + 0.5, 16.0);
    }

    public CompoundTag m_5995_() {
        return this.writeNetwork(super.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readNetwork(pkt.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.m_142466_(tag);
        this.readNetwork(tag);
    }

    public void readNetwork(CompoundTag tag) {
        this.tickTime = tag.m_128451_("SpawnTick");
    }

    public CompoundTag writeNetwork(CompoundTag tag) {
        tag.m_128405_("SpawnTick", this.tickTime);
        return tag;
    }

    public void markUpdated() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_142466_(CompoundTag compound) {
        this.readNetwork(compound);
        super.m_142466_(compound);
    }

    public void m_183515_(CompoundTag compound) {
        this.writeNetwork(compound);
        super.m_183515_(compound);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

