/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.blocks.entities;

import com.mongoose.clanginghowl.common.blocks.CHBlocks;
import com.mongoose.clanginghowl.common.blocks.CrystalFormerBlock;
import com.mongoose.clanginghowl.common.blocks.ExEnergyClusterBlock;
import com.mongoose.clanginghowl.common.blocks.entities.CHBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class CrystalFormerBlockEntity
extends BlockEntity {
    public int tickTime;

    public CrystalFormerBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)CHBlockEntities.CRYSTAL_FORMER.get(), p_155229_, p_155230_);
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && ((Boolean)this.m_58900_().m_61143_((Property)CrystalFormerBlock.ENABLED)).booleanValue()) {
            for (Entity entity : this.f_58857_.m_45976_(Entity.class, new AABB(this.f_58858_).m_82400_(2.0))) {
                if (entity.m_6095_().m_204039_(EntityTypeTags.f_144294_) || !entity.m_142079_() || !entity.m_6097_() || !EntitySelector.f_20406_.test(entity)) continue;
                int i = entity.m_146888_();
                int j = 4;
                entity.m_146917_(Math.min(entity.m_146891_() + 5, i + j));
            }
            BlockState above = this.f_58857_.m_8055_(this.f_58858_.m_7494_());
            float temperature = ((Biome)this.f_58857_.m_204166_(this.f_58858_).get()).m_47554_();
            int age = -1;
            if (above.m_61138_((Property)ExEnergyClusterBlock.AGE)) {
                age = (Integer)above.m_61143_((Property)ExEnergyClusterBlock.AGE);
            }
            if (above.m_247087_() && temperature <= 1.5f || above.m_60713_((Block)CHBlocks.EXTRATERRESTRIAL_ENERGY_CLUSTER.get()) && CrystalFormerBlockEntity.canGrow(age, temperature)) {
                if (this.tickTime < 5000) {
                    ++this.tickTime;
                }
            } else {
                this.tickTime = 0;
            }
            if (this.tickTime >= 2000) {
                if (above.m_60713_((Block)CHBlocks.EXTRATERRESTRIAL_ENERGY_CLUSTER.get()) && CrystalFormerBlockEntity.canGrow(age, temperature)) {
                    ExEnergyClusterBlock block = (ExEnergyClusterBlock)above.m_60734_();
                    block.growCrystal(above, this.f_58857_, this.f_58858_.m_7494_());
                    this.tickTime = 0;
                } else if (above.m_247087_() && temperature <= 1.5f && this.tickTime >= 4000) {
                    this.f_58857_.m_7731_(this.f_58858_.m_7494_(), ((Block)CHBlocks.EXTRATERRESTRIAL_ENERGY_CLUSTER.get()).m_49966_(), 3);
                    this.tickTime = 0;
                }
            }
        }
    }

    private static boolean canGrow(int age, float temperature) {
        boolean flag = false;
        if (age == 0) {
            if (temperature <= 1.4f) {
                flag = true;
            }
        } else if (age == 1) {
            if (temperature <= 0.9f) {
                flag = true;
            }
        } else if (age == 2 && temperature <= 0.4f) {
            flag = true;
        }
        return flag;
    }

    public CompoundTag m_5995_() {
        return this.writeNetwork(super.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readNetwork(pkt.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.m_142466_(tag);
        this.readNetwork(tag);
    }

    public void readNetwork(CompoundTag tag) {
        this.tickTime = tag.m_128451_("GrowTick");
    }

    public CompoundTag writeNetwork(CompoundTag tag) {
        tag.m_128405_("GrowTick", this.tickTime);
        return tag;
    }

    public void markUpdated() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_142466_(CompoundTag compound) {
        this.readNetwork(compound);
        super.m_142466_(compound);
    }

    public void m_183515_(CompoundTag compound) {
        this.writeNetwork(compound);
        super.m_183515_(compound);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

