/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.blocks.entities;

import com.mongoose.clanginghowl.common.blocks.entities.CHBlockEntities;
import com.mongoose.clanginghowl.common.items.energy.IEnergyItem;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class ChargingStationBlockEntity
extends BlockEntity {
    public long lastChangeTime;
    public LazyOptional<ItemStackHandler> itemStackHandler = LazyOptional.of(() -> new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            if (ChargingStationBlockEntity.this.f_58857_ != null && !((ChargingStationBlockEntity)ChargingStationBlockEntity.this).f_58857_.f_46443_) {
                ChargingStationBlockEntity.this.lastChangeTime = ChargingStationBlockEntity.this.f_58857_.m_46467_();
                boolean flag = !((ItemStack)this.stacks.get(0)).m_41619_();
                ChargingStationBlockEntity.this.f_58857_.m_46597_(ChargingStationBlockEntity.this.m_58899_(), (BlockState)ChargingStationBlockEntity.this.m_58900_().m_61124_((Property)BlockStateProperties.f_61445_, (Comparable)Boolean.valueOf(flag)));
                ChargingStationBlockEntity.this.markNetworkDirty();
            }
        }
    });

    public ChargingStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)CHBlockEntities.STATIONARY_CHARGING_STATION.get(), blockPos, blockState);
    }

    public ChargingStationBlockEntity(BlockEntityType<?> blockEntity, BlockPos blockPos, BlockState blockState) {
        super(blockEntity, blockPos, blockState);
    }

    public void tick() {
        IItemHandler handler;
        ItemStack tool;
        if (this.f_58857_ != null && !(tool = (handler = (IItemHandler)this.itemStackHandler.orElseThrow(RuntimeException::new)).getStackInSlot(0)).m_41619_() && tool.m_41720_() instanceof IEnergyItem && !IEnergyItem.isFull(tool) && this.f_58857_.m_46467_() % 20L == 0L) {
            IEnergyItem.powerItem(tool, 4);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemStackHandler.cast();
        }
        return super.getCapability(cap, direction);
    }

    public void m_142466_(CompoundTag compound) {
        this.readNetwork(compound);
        super.m_142466_(compound);
    }

    public void m_183515_(CompoundTag compound) {
        this.writeNetwork(compound);
        super.m_183515_(compound);
    }

    public void readNetwork(CompoundTag compound) {
        this.itemStackHandler.ifPresent(handler -> handler.deserializeNBT(compound.m_128469_("inventory")));
        this.lastChangeTime = compound.m_128454_("lastChangeTime");
    }

    public CompoundTag writeNetwork(CompoundTag compound) {
        this.itemStackHandler.ifPresent(handler -> compound.m_128365_("inventory", (Tag)handler.serializeNBT()));
        compound.m_128356_("lastChangeTime", this.lastChangeTime);
        return compound;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemStackHandler.invalidate();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.writeNetwork(super.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readNetwork(pkt.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.m_142466_(tag);
        this.readNetwork(tag);
    }

    public void markNetworkDirty() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }
}

