/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.blocks;

import com.mongoose.clanginghowl.common.blocks.CHBlocks;
import com.mongoose.clanginghowl.utils.CHDamageSource;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IcicleBlock
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public IcicleBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50354_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_150930_(((Block)CHBlocks.CRYOGENIC_ICICLE.get()).m_5456_()) && pState.m_60713_((Block)CHBlocks.CRYOGENIC_ICICLE.get())) {
            BlockState blockState = (BlockState)((Block)CHBlocks.BIG_CRYOGENIC_ICICLE.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)));
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            SoundType soundtype = blockState.getSoundType((LevelReader)pLevel, pPos, (Entity)pPlayer);
            pLevel.m_5594_(pPlayer, pPos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            pLevel.m_220407_(GameEvent.f_157797_, pPos, GameEvent.Context.m_223719_((Entity)pPlayer, (BlockState)blockState));
            pLevel.m_46597_(pPos, blockState);
            blockState.m_60734_().m_6402_(pLevel, pPos, blockState, (LivingEntity)pPlayer, itemstack);
            if (pPlayer instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)pPlayer, pPos, itemstack);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_153358_) {
        p_153358_.m_61104_(new Property[]{WATERLOGGED});
    }

    public FluidState m_5888_(BlockState p_153360_) {
        return (Boolean)p_153360_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_153360_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_153340_) {
        BlockState blockstate = super.m_5573_(p_153340_);
        if (blockstate != null) {
            FluidState fluidstate = p_153340_.m_43725_().m_6425_(p_153340_.m_8083_());
            return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public boolean m_7898_(BlockState p_153347_, LevelReader p_153348_, BlockPos p_153349_) {
        BlockPos blockpos = p_153349_.m_7494_();
        BlockState blockstate = p_153348_.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)p_153348_, blockpos, Direction.DOWN);
    }

    public void m_213897_(BlockState p_221865_, ServerLevel p_221866_, BlockPos p_221867_, RandomSource p_221868_) {
        if (!this.m_7898_(p_221865_, (LevelReader)p_221866_, p_221867_)) {
            this.spawnFallingStalactite(p_221865_, p_221866_, p_221867_);
        }
    }

    public VoxelShape m_5940_(BlockState p_153342_, BlockGetter p_153343_, BlockPos p_153344_, CollisionContext p_153345_) {
        return SHAPE;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        if (direction == Direction.UP && !this.m_7898_(blockState, (LevelReader)levelAccessor, blockPos)) {
            levelAccessor.m_186460_(blockPos, (Block)this, 1);
        } else if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(blockState, direction, blockState1, levelAccessor, blockPos, blockPos1);
    }

    public void m_214162_(BlockState p_221870_, Level p_221871_, BlockPos p_221872_, RandomSource p_221873_) {
        float f;
        if (((Biome)p_221871_.m_204166_(p_221872_).get()).m_47554_() > 0.5f && IcicleBlock.isTip(p_221870_) && !((f = p_221873_.m_188501_()) > 0.12f)) {
            IcicleBlock.spawnDripParticle(p_221871_, p_221872_, p_221870_);
        }
    }

    private static void spawnDripParticle(Level p_154072_, BlockPos p_154073_, BlockState p_154074_) {
        Vec3 vec3 = p_154074_.m_60824_((BlockGetter)p_154072_, p_154073_);
        double d0 = 0.0625;
        double d1 = (double)p_154073_.m_123341_() + 0.5 + vec3.f_82479_;
        double d2 = (double)((float)(p_154073_.m_123342_() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)p_154073_.m_123343_() + 0.5 + vec3.f_82481_;
        SimpleParticleType particleoptions = ParticleTypes.f_175824_;
        p_154072_.m_7106_((ParticleOptions)particleoptions, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    public void spawnFallingStalactite(BlockState p_154098_, ServerLevel p_154099_, BlockPos p_154100_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_154100_.m_122032_();
        BlockState blockstate = p_154098_;
        while (blockstate.m_60734_() instanceof IcicleBlock) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_((Level)p_154099_, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
            if (IcicleBlock.isTip(blockstate)) {
                fallingblockentity.m_149656_(4.0f, 40);
                fallingblockentity.m_272001_();
                break;
            }
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
            blockstate = p_154099_.m_8055_((BlockPos)blockpos$mutableblockpos);
        }
    }

    public static boolean isTip(BlockState p_154154_) {
        if (!(p_154154_.m_60734_() instanceof IcicleBlock)) {
            return false;
        }
        return !p_154154_.m_61138_((Property)BlockStateProperties.f_61401_) || p_154154_.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER;
    }

    public void m_142525_(Level p_154059_, BlockPos p_154060_, FallingBlockEntity p_154061_) {
        if (IcicleBlock.isTip(p_154061_.m_31980_())) {
            p_154059_.m_46796_(2001, p_154060_, Block.m_49956_((BlockState)this.m_49966_()));
            Vec3 vec3 = p_154061_.m_20191_().m_82399_();
            p_154059_.m_220400_((Entity)p_154061_, GameEvent.f_157794_, vec3);
        }
    }

    public DamageSource m_252932_(Entity p_254432_) {
        return CHDamageSource.getDamageSource(p_254432_.m_9236_(), CHDamageSource.ICICLE);
    }
}

