/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.blocks;

import com.mongoose.clanginghowl.client.particles.CHParticleTypes;
import com.mongoose.clanginghowl.common.blocks.CHBlocks;
import com.mongoose.clanginghowl.common.blocks.HugeExEnergyClusterBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ExEnergyClusterBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.9, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.9, (double)16.0)};

    public ExEnergyClusterBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152492_).m_60913_(1.5f, 10.0f).m_60918_(SoundType.f_154656_).m_284180_(MapColor.f_283869_).m_280606_().m_60955_().m_278166_(PushReaction.DESTROY).m_60991_((i, d, k) -> true).m_60953_(p_187409_ -> (Integer)p_187409_.m_61143_((Property)AGE) * 2 + 1));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState p_52297_, BlockGetter p_52298_, BlockPos p_52299_, CollisionContext p_52300_) {
        return SHAPE_BY_AGE[this.getAge(p_52297_)];
    }

    public float m_7749_(BlockState p_48731_, BlockGetter p_48732_, BlockPos p_48733_) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState p_48740_, BlockGetter p_48741_, BlockPos p_48742_) {
        return true;
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        if ((Integer)state.m_61143_((Property)AGE) == 0) {
            return SoundType.f_154656_;
        }
        if ((Integer)state.m_61143_((Property)AGE) == 1) {
            return SoundType.f_154657_;
        }
        return SoundType.f_154658_;
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 2;
    }

    public int getAge(BlockState p_52306_) {
        return (Integer)p_52306_.m_61143_((Property)this.getAgeProperty());
    }

    public BlockState getStateForAge(int p_52290_) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(p_52290_));
    }

    public final boolean isMaxAge(BlockState p_52308_) {
        return this.getAge(p_52308_) >= this.getMaxAge();
    }

    public void m_213897_(BlockState p_220908_, ServerLevel p_220909_, BlockPos p_220910_, RandomSource p_220911_) {
        if (!p_220909_.m_46749_(p_220910_)) {
            return;
        }
        if (!p_220908_.m_60710_((LevelReader)p_220909_, p_220910_)) {
            p_220909_.m_46961_(p_220910_, true);
        }
    }

    public boolean m_7898_(BlockState p_57499_, LevelReader p_57500_, BlockPos p_57501_) {
        BlockState blockstate = p_57500_.m_8055_(p_57501_.m_7495_());
        return blockstate.m_60783_((BlockGetter)p_57500_, p_57501_.m_7495_(), Direction.UP);
    }

    public BlockState m_7417_(BlockState p_51157_, Direction p_51158_, BlockState p_51159_, LevelAccessor p_51160_, BlockPos p_51161_, BlockPos p_51162_) {
        if (!p_51157_.m_60710_((LevelReader)p_51160_, p_51161_)) {
            p_51160_.m_186460_(p_51161_, (Block)this, 1);
        }
        if (((Boolean)p_51157_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_51160_.m_186469_(p_51161_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_51160_));
        }
        return super.m_7417_(p_51157_, p_51158_, p_51159_, p_51160_, p_51161_, p_51162_);
    }

    public boolean m_6724_(BlockState p_52288_) {
        return false;
    }

    public void m_213898_(BlockState state, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        int i;
        if (!serverLevel.m_46749_(blockPos)) {
            return;
        }
        if (serverLevel.m_8055_(blockPos.m_7495_()).m_60713_((Block)CHBlocks.EXTRATERRESTRIAL_STONE.get()) && (i = this.getAge(state)) <= this.getMaxAge() && randomSource.m_188503_(5) == 0) {
            if (i == this.getMaxAge()) {
                if (serverLevel.m_8055_(blockPos.m_7494_()).m_60629_((BlockPlaceContext)new DirectionalPlaceContext((Level)serverLevel, blockPos.m_7494_(), Direction.DOWN, ItemStack.f_41583_, Direction.UP))) {
                    HugeExEnergyClusterBlock.placeAt((LevelAccessor)serverLevel, ((Block)CHBlocks.HUGE_EXTRATERRESTRIAL_ENERGY_CLUSTER.get()).m_49966_(), blockPos, 3);
                }
            } else {
                serverLevel.m_7731_(blockPos, this.getStateForAge(i + 1), 2);
            }
        }
    }

    public void growCrystal(BlockState state, Level level, BlockPos blockPos) {
        int i = this.getAge(state);
        if (i <= this.getMaxAge()) {
            if (i == this.getMaxAge()) {
                if (level.m_8055_(blockPos.m_7494_()).m_60629_((BlockPlaceContext)new DirectionalPlaceContext(level, blockPos.m_7494_(), Direction.DOWN, ItemStack.f_41583_, Direction.UP))) {
                    HugeExEnergyClusterBlock.placeAt((LevelAccessor)level, ((Block)CHBlocks.HUGE_EXTRATERRESTRIAL_ENERGY_CLUSTER.get()).m_49966_(), blockPos, 3);
                }
            } else {
                level.m_7731_(blockPos, this.getStateForAge(i + 1), 2);
            }
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        if ((Integer)state.m_61143_((Property)AGE) == 1) {
            return new ItemStack((ItemLike)CHBlocks.MEDIUM_EX_ENERGY_CLUSTER.get());
        }
        if ((Integer)state.m_61143_((Property)AGE) == 2) {
            return new ItemStack((ItemLike)CHBlocks.LARGE_EX_ENERGY_CLUSTER.get());
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public BlockState m_5573_(BlockPlaceContext p_153711_) {
        FluidState fluidstate = p_153711_.m_43725_().m_6425_(p_153711_.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public FluidState m_5888_(BlockState p_153759_) {
        return (Boolean)p_153759_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_153759_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_52286_) {
        p_52286_.m_61104_(new Property[]{AGE, WATERLOGGED});
    }

    public void m_214162_(BlockState p_220827_, Level p_220828_, BlockPos p_220829_, RandomSource p_220830_) {
        super.m_214162_(p_220827_, p_220828_, p_220829_, p_220830_);
        if (p_220828_.m_46467_() % (long)p_220828_.m_213780_().m_216332_(20, 40) == 0L) {
            Direction direction = Direction.m_235672_((RandomSource)p_220830_);
            Direction.Axis axis = direction.m_122434_();
            double x = axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)p_220830_.m_188501_();
            double y = axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.m_122430_() : (double)p_220830_.m_188501_();
            double z = axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)p_220830_.m_188501_();
            p_220828_.m_7106_((ParticleOptions)CHParticleTypes.CRYSTAL_LUSTER.get(), (double)p_220829_.m_123341_() + x, (double)p_220829_.m_123342_() + y, (double)p_220829_.m_123343_() + z, 0.0, 0.0, 0.0);
        }
    }
}

