/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.blocks;

import com.mongoose.clanginghowl.common.blocks.entities.ChargingStationBlockEntity;
import com.mongoose.clanginghowl.common.items.energy.IEnergyItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class ChargingStationBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;

    public ChargingStationBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(4.0f, 9.0f).m_60918_(SoundType.f_154663_).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)OCCUPIED, (Comparable)Boolean.FALSE));
    }

    public boolean m_7923_(BlockState p_52997_) {
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            ItemStack heldItem = player.m_21120_(hand);
            ChargingStationBlockEntity pedestal = (ChargingStationBlockEntity)world.m_7702_(pos);
            if (pedestal != null) {
                pedestal.getCapability(ForgeCapabilities.ITEM_HANDLER, hit.m_82434_()).ifPresent(handler -> {
                    ItemStack itemStack = handler.getStackInSlot(0);
                    if (itemStack.m_41619_() && heldItem.m_41720_() instanceof IEnergyItem) {
                        player.m_21008_(hand, handler.insertItem(0, heldItem, false));
                        world.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else if (!itemStack.m_41619_()) {
                        if (heldItem.m_41619_()) {
                            player.m_21008_(hand, handler.extractItem(0, 64, false));
                        } else {
                            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)handler.extractItem(0, 64, false));
                        }
                        world.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    pedestal.m_6596_();
                });
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity tileentity = pLevel.m_7702_(pPos);
            if (tileentity instanceof ChargingStationBlockEntity) {
                tileentity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> ChargingStationBlock.dropInventoryItems(tileentity.m_58904_(), tileentity.m_58899_(), handler));
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public static void dropInventoryItems(Level worldIn, BlockPos pos, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemHandler.getStackInSlot(i));
        }
    }

    public RenderShape m_7514_(BlockState p_53840_) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext p_48781_) {
        FluidState fluidstate = p_48781_.m_43725_().m_6425_(p_48781_.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)p_48781_.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public FluidState m_5888_(BlockState p_153759_) {
        return (Boolean)p_153759_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_153759_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_53838_) {
        p_53838_.m_61104_(new Property[]{f_54117_, WATERLOGGED, OCCUPIED});
    }

    public BlockState m_7417_(BlockState p_51157_, Direction p_51158_, BlockState p_51159_, LevelAccessor p_51160_, BlockPos p_51161_, BlockPos p_51162_) {
        if (((Boolean)p_51157_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_51160_.m_186469_(p_51161_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_51160_));
        }
        return super.m_7417_(p_51157_, p_51158_, p_51159_, p_51160_, p_51161_, p_51162_);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new ChargingStationBlockEntity(p_153215_, p_153216_);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_152755_, BlockState p_152756_, BlockEntityType<T> p_152757_) {
        return (world, pos, state, blockEntity) -> {
            if (blockEntity instanceof ChargingStationBlockEntity) {
                ChargingStationBlockEntity block = (ChargingStationBlockEntity)blockEntity;
                block.tick();
            }
        };
    }
}

