/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.common.blocks;

import com.mongoose.clanginghowl.common.blocks.BigHangingFleshBlock;
import com.mongoose.clanginghowl.common.blocks.BigIcicleBlock;
import com.mongoose.clanginghowl.common.blocks.CHBlockSetType;
import com.mongoose.clanginghowl.common.blocks.ChargingStationBlock;
import com.mongoose.clanginghowl.common.blocks.CrystalFormerBlock;
import com.mongoose.clanginghowl.common.blocks.ExEnergyClusterBlock;
import com.mongoose.clanginghowl.common.blocks.ExPebbleBlock;
import com.mongoose.clanginghowl.common.blocks.ExStoneBlock;
import com.mongoose.clanginghowl.common.blocks.FleshBlock;
import com.mongoose.clanginghowl.common.blocks.FleshMembraneBlock;
import com.mongoose.clanginghowl.common.blocks.FleshNestBlock;
import com.mongoose.clanginghowl.common.blocks.GrateBlock;
import com.mongoose.clanginghowl.common.blocks.HangingFleshBlock;
import com.mongoose.clanginghowl.common.blocks.HugeExEnergyClusterBlock;
import com.mongoose.clanginghowl.common.blocks.IcicleBlock;
import com.mongoose.clanginghowl.common.blocks.NerveEndingsBlock;
import com.mongoose.clanginghowl.common.blocks.SteelBridgeBlock;
import com.mongoose.clanginghowl.common.blocks.SteelRodBlock;
import com.mongoose.clanginghowl.common.items.CHBlockItem;
import com.mongoose.clanginghowl.common.items.CHItems;
import com.mongoose.clanginghowl.common.items.ExEnergyClusterItem;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class CHBlocks {
    public static DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"clanginghowl");
    public static final Map<ResourceLocation, BlockLootSetting> BLOCK_LOOT = new HashMap<ResourceLocation, BlockLootSetting>();
    public static final RegistryObject<Block> EXTRATERRESTRIAL_STONE = CHBlocks.register("extraterrestrial_stone", ExStoneBlock::new);
    public static final RegistryObject<Block> EXTRATERRESTRIAL_STONE_STAIRS = CHBlocks.registerStairs("extraterrestrial_stone_stairs", EXTRATERRESTRIAL_STONE);
    public static final RegistryObject<Block> EXTRATERRESTRIAL_STONE_SLAB = CHBlocks.registerSlabs("extraterrestrial_stone_slab", EXTRATERRESTRIAL_STONE);
    public static final RegistryObject<Block> EXTRATERRESTRIAL_STONE_WALL = CHBlocks.registerWalls("extraterrestrial_stone_wall", EXTRATERRESTRIAL_STONE);
    public static final RegistryObject<Block> SMOOTH_EXTRATERRESTRIAL_STONE = CHBlocks.register("smooth_extraterrestrial_stone", SmoothExStoneBlock::new);
    public static final RegistryObject<Block> SMOOTH_EXTRATERRESTRIAL_STONE_STAIRS = CHBlocks.registerStairs("smooth_extraterrestrial_stone_stairs", SMOOTH_EXTRATERRESTRIAL_STONE);
    public static final RegistryObject<Block> SMOOTH_EXTRATERRESTRIAL_STONE_SLAB = CHBlocks.registerSlabs("smooth_extraterrestrial_stone_slab", SMOOTH_EXTRATERRESTRIAL_STONE);
    public static final RegistryObject<Block> SMOOTH_EXTRATERRESTRIAL_STONE_WALL = CHBlocks.registerWalls("smooth_extraterrestrial_stone_wall", SMOOTH_EXTRATERRESTRIAL_STONE);
    public static final RegistryObject<Block> EXTRATERRESTRIAL_STONE_BRICKS = CHBlocks.register("extraterrestrial_stone_bricks", ExStoneBricksBlock::new);
    public static final RegistryObject<Block> EXTRATERRESTRIAL_STONE_BRICK_STAIRS = CHBlocks.registerStairs("extraterrestrial_stone_brick_stairs", EXTRATERRESTRIAL_STONE_BRICKS);
    public static final RegistryObject<Block> EXTRATERRESTRIAL_STONE_BRICK_SLAB = CHBlocks.registerSlabs("extraterrestrial_stone_brick_slab", EXTRATERRESTRIAL_STONE_BRICKS);
    public static final RegistryObject<Block> EXTRATERRESTRIAL_STONE_BRICK_WALL = CHBlocks.registerWalls("extraterrestrial_stone_brick_wall", EXTRATERRESTRIAL_STONE_BRICKS);
    public static final RegistryObject<Block> CARVED_EXTRATERRESTRIAL_STONE_BRICKS = CHBlocks.register("carved_extraterrestrial_stone_bricks", ExStoneBricksBlock::new);
    public static final RegistryObject<Block> EXTRATERRESTRIAL_COLUMN = CHBlocks.register("extraterrestrial_column", () -> CHBlocks.pillar(CHBlocks.smoothExStoneProperties()));
    public static final RegistryObject<Block> EXTRATERRESTRIAL_PEBBLE = CHBlocks.register("extraterrestrial_pebble", ExPebbleBlock::new);
    public static final RegistryObject<Block> INCANDESCENT_EXTRATERRESTRIAL_STONE = CHBlocks.register("incandescent_extraterrestrial_stone", () -> new MagmaBlock(CHBlocks.exStoneProperties().m_60953_(l -> 3).m_60982_(CHBlocks::always).m_60991_(CHBlocks::always)));
    public static final RegistryObject<Block> METEORITE_STEEL_ORE = CHBlocks.register("meteorite_steel_ore", () -> new DropExperienceBlock(CHBlocks.exStoneProperties(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)), true, LootTableType.EMPTY);
    public static final RegistryObject<Block> EXTRATERRESTRIAL_STEEL_ORE = CHBlocks.register("extraterrestrial_steel_ore", () -> new DropExperienceBlock(CHBlocks.exSteelOreProperties(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)), true, LootTableType.EMPTY);
    public static final RegistryObject<Block> EXTRATERRESTRIAL_ENERGY_CLUSTER = CHBlocks.registerCluster("extraterrestrial_energy_cluster", ExEnergyClusterBlock::new);
    public static final RegistryObject<Block> HUGE_EXTRATERRESTRIAL_ENERGY_CLUSTER = CHBlocks.register("huge_extraterrestrial_energy_cluster", HugeExEnergyClusterBlock::new, true, LootTableType.EMPTY);
    public static final RegistryObject<Block> RAW_EXTRATERRESTRIAL_STEEL_BLOCK = CHBlocks.register("raw_extraterrestrial_steel_block", () -> new ExSteelBlock(Blocks.f_50069_));
    public static final RegistryObject<Block> EXTRATERRESTRIAL_STEEL_BLOCK = CHBlocks.register("extraterrestrial_steel_block", () -> new ExSteelBlock(Blocks.f_50721_));
    public static final RegistryObject<Block> STEEL_PLATE_BLOCK = CHBlocks.register("steel_plate_block", ExSteelPlateBlock::new);
    public static final RegistryObject<Block> DAMAGED_STEEL_PLATE_BLOCK = CHBlocks.register("damaged_steel_plate_block", ExSteelPlateBlock::new);
    public static final RegistryObject<Block> CARVED_STEEL_PLATE_BLOCK = CHBlocks.register("carved_steel_plate_block", () -> CHBlocks.pillar(CHBlocks.exSteelPlateProperties()));
    public static final RegistryObject<Block> CARVED_STEEL_PLATE_STAIRS = CHBlocks.registerStairs("carved_steel_plate_stairs", CARVED_STEEL_PLATE_BLOCK);
    public static final RegistryObject<Block> CARVED_STEEL_PLATE_SLAB = CHBlocks.registerSlabs("carved_steel_plate_slab", CARVED_STEEL_PLATE_BLOCK);
    public static final RegistryObject<Block> DAMAGED_CARVED_STEEL_PLATE_BLOCK = CHBlocks.register("damaged_carved_steel_plate_block", () -> CHBlocks.pillar(CHBlocks.exSteelPlateProperties()));
    public static final RegistryObject<Block> EXTRATERRESTRIAL_STEEL_GRATE = CHBlocks.register("extraterrestrial_steel_grate", GrateBlock::new);
    public static final RegistryObject<Block> STEEL_BRIDGE = CHBlocks.register("steel_bridge", SteelBridgeBlock::new);
    public static final RegistryObject<Block> STEEL_ROD = CHBlocks.register("steel_rod", () -> new SteelRodBlock(CHBlocks.exSteelPlateProperties().m_60955_()));
    public static final RegistryObject<Block> STEEL_DOOR = CHBlocks.register("steel_door", () -> new DoorBlock(BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 10.0f).m_60918_(SoundType.f_56743_).m_60955_().m_60924_((i, d, k) -> false), CHBlockSetType.EX_STEEL));
    public static final RegistryObject<Block> STEEL_TRAPDOOR = CHBlocks.register("steel_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 10.0f).m_60918_(SoundType.f_56743_).m_60955_(), CHBlockSetType.EX_STEEL));
    public static final RegistryObject<Block> CALCITE_TILES = CHBlocks.register("calcite_tiles", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152497_)));
    public static final RegistryObject<Block> CALCITE_TILE_STAIRS = CHBlocks.registerStairs("calcite_tile_stairs", CALCITE_TILES);
    public static final RegistryObject<Block> CALCITE_TILE_SLAB = CHBlocks.registerSlabs("calcite_tile_slab", CALCITE_TILES);
    public static final RegistryObject<Block> CRACKED_CALCITE_TILES = CHBlocks.register("cracked_calcite_tiles", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152497_)));
    public static final RegistryObject<Block> CRYOGENIC_ICICLE = CHBlocks.register("cryogenic_icicle", IcicleBlock::new);
    public static final RegistryObject<Block> BIG_CRYOGENIC_ICICLE = CHBlocks.register("big_cryogenic_icicle", BigIcicleBlock::new, false, LootTableType.EMPTY);
    public static final RegistryObject<Block> TECHNOFLESH_BLOCK = CHBlocks.register("technoflesh_block", FleshBlock::new);
    public static final RegistryObject<Block> TECHNOFLESH_SLAB = CHBlocks.registerSlabs("technoflesh_slab", TECHNOFLESH_BLOCK);
    public static final RegistryObject<Block> FROZEN_TECHNOFLESH_BLOCK = CHBlocks.register("frozen_technoflesh", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50354_)));
    public static final RegistryObject<Block> TUBULAR_TECHNOFLESH = CHBlocks.register("tubular_technoflesh", () -> CHBlocks.pillar(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283913_).m_60978_(2.0f).m_278183_().m_60918_(SoundType.f_56751_)));
    public static final RegistryObject<Block> TECHNOFLESH_MEMBRANE = CHBlocks.register("technoflesh_membrane", FleshMembraneBlock::new, true, LootTableType.EMPTY);
    public static final RegistryObject<Block> HANGING_TECHNOFLESH = CHBlocks.register("hanging_technoflesh", HangingFleshBlock::new, true, LootTableType.EMPTY);
    public static final RegistryObject<Block> BIG_HANGING_TECHNOFLESH = CHBlocks.register("big_hanging_technoflesh", BigHangingFleshBlock::new, false, LootTableType.EMPTY);
    public static final RegistryObject<Block> NERVE_ENDINGS = CHBlocks.register("nerve_endings", NerveEndingsBlock::new, true, LootTableType.EMPTY);
    public static final RegistryObject<Block> TECHNOFLESH_NEST = CHBlocks.register("technoflesh_nest", FleshNestBlock::new, true, LootTableType.EMPTY);
    public static final RegistryObject<Block> CRYSTAL_FORMER = CHBlocks.register("crystal_former", CrystalFormerBlock::new);
    public static final RegistryObject<Block> STATIONARY_CHARGING_STATION = CHBlocks.register("stationary_charging_station", ChargingStationBlock::new);
    public static RegistryObject<BlockItem> SMALL_EX_ENERGY_CLUSTER;
    public static RegistryObject<BlockItem> MEDIUM_EX_ENERGY_CLUSTER;
    public static RegistryObject<BlockItem> LARGE_EX_ENERGY_CLUSTER;

    public static void init() {
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private static RotatedPillarBlock pillar(BlockBehaviour.Properties properties) {
        return new RotatedPillarBlock(properties);
    }

    public static <T extends Block> RegistryObject<Block> registerSlabs(String string, RegistryObject<T> block) {
        return CHBlocks.register(string, () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)block.get()))), true);
    }

    public static <T extends Block> RegistryObject<Block> registerStairs(String name, RegistryObject<T> block) {
        return CHBlocks.register(name, () -> new StairBlock(() -> ((Block)block.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)block.get()))));
    }

    public static <T extends Block> RegistryObject<Block> registerWalls(String name, RegistryObject<T> block) {
        return CHBlocks.register(name, () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)block.get()))));
    }

    public static <T extends Block> RegistryObject<T> register(String string, Supplier<? extends T> sup) {
        return CHBlocks.register(string, sup, true);
    }

    public static <T extends Block> RegistryObject<T> register(String string, Supplier<? extends T> sup, boolean blockItemDefault) {
        return CHBlocks.register(string, sup, blockItemDefault, LootTableType.DROP);
    }

    public static <T extends Block> RegistryObject<T> register(String string, Supplier<? extends T> sup, boolean blockItemDefault, LootTableType lootTableType) {
        RegistryObject block = BLOCKS.register(string, sup);
        BLOCK_LOOT.put(block.getId(), new BlockLootSetting(blockItemDefault, lootTableType));
        if (blockItemDefault) {
            CHItems.ITEMS.register(string, () -> new CHBlockItem((Block)block.get(), new Item.Properties()));
        }
        return block;
    }

    private static boolean always(BlockState p_50775_, BlockGetter p_50776_, BlockPos p_50777_) {
        return true;
    }

    public static <T extends Block> RegistryObject<T> registerCluster(String string, Supplier<? extends T> sup) {
        RegistryObject block = BLOCKS.register(string, sup);
        BLOCK_LOOT.put(block.getId(), new BlockLootSetting(false, LootTableType.EMPTY));
        SMALL_EX_ENERGY_CLUSTER = CHItems.ITEMS.register("small_" + string, () -> new ExEnergyClusterItem(0));
        MEDIUM_EX_ENERGY_CLUSTER = CHItems.ITEMS.register("medium_" + string, () -> new ExEnergyClusterItem(1));
        LARGE_EX_ENERGY_CLUSTER = CHItems.ITEMS.register("large_" + string, () -> new ExEnergyClusterItem(2));
        return block;
    }

    public static BlockBehaviour.Properties exStoneProperties() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152550_).m_60913_(3.0f, 35.0f);
    }

    public static BlockBehaviour.Properties smoothExStoneProperties() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152555_).m_60913_(3.0f, 35.0f);
    }

    public static BlockBehaviour.Properties exStoneBricksProperties() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152589_).m_60913_(3.0f, 35.0f);
    }

    public static BlockBehaviour.Properties exSteelOreProperties() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60913_(1.5f, 6.0f);
    }

    public static BlockBehaviour.Properties exSteelBlockProperties(Block block) {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)block).m_284180_(MapColor.f_283779_).m_60913_(4.0f, 40.0f);
    }

    public static BlockBehaviour.Properties exSteelPlateProperties() {
        return BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_154663_).m_284180_(MapColor.f_283818_).m_60999_().m_60913_(2.0f, 10.0f);
    }

    public static enum LootTableType {
        EMPTY,
        DROP;

    }

    public static class BlockLootSetting {
        public boolean generateDefaultBlockItem;
        public LootTableType lootTableType;

        public BlockLootSetting(boolean generateDefaultBlockItem, LootTableType lootTableType) {
            this.generateDefaultBlockItem = generateDefaultBlockItem;
            this.lootTableType = lootTableType;
        }
    }

    public static class ExSteelBlock
    extends Block {
        public ExSteelBlock(Block block) {
            super(CHBlocks.exSteelBlockProperties(block));
        }
    }

    public static class ExSteelPlateBlock
    extends Block {
        public ExSteelPlateBlock() {
            super(CHBlocks.exSteelPlateProperties());
        }
    }

    public static class ExStoneBricksBlock
    extends Block {
        public ExStoneBricksBlock() {
            super(CHBlocks.exStoneBricksProperties());
        }
    }

    public static class SmoothExStoneBlock
    extends Block {
        public SmoothExStoneBlock() {
            super(CHBlocks.smoothExStoneProperties());
        }
    }
}

