/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl.client.events;

import com.mongoose.clanginghowl.client.audio.ItemIdleSound;
import com.mongoose.clanginghowl.client.audio.ItemLoopSound;
import com.mongoose.clanginghowl.common.items.CHItems;
import com.mongoose.clanginghowl.common.items.energy.ChainsawItem;
import com.mongoose.clanginghowl.common.items.energy.ChainswordItem;
import com.mongoose.clanginghowl.common.items.energy.IEnergyItem;
import com.mongoose.clanginghowl.common.items.fuel.IFuel;
import com.mongoose.clanginghowl.init.CHSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="clanginghowl", value={Dist.CLIENT})
public class ClientEvents {
    public static AbstractTickableSoundInstance ITEM_TICK;
    public static float PARTIAL_TICK;

    @SubscribeEvent
    public static void onPlayerHoldItem(TickEvent.PlayerTickEvent event) {
        if (event.player.m_9236_() instanceof ClientLevel) {
            if (event.player.m_21093_(itemStack -> itemStack.m_41720_() instanceof ChainsawItem && !IEnergyItem.isEmpty(itemStack))) {
                ClientEvents.playItemIdleLoop((SoundEvent)CHSounds.CHAINSAW_IDLE.get(), (LivingEntity)event.player, (Item)CHItems.ADVANCED_CHAINSAW.get(), 0.4f, 1.0f);
            } else if (event.player.m_21093_(itemStack -> itemStack.m_41720_() instanceof ChainswordItem && !IEnergyItem.isEmpty(itemStack))) {
                ClientEvents.playItemIdleLoop((SoundEvent)CHSounds.CHAINSAW_IDLE.get(), (LivingEntity)event.player, (Item)CHItems.ADVANCED_CHAINSWORD.get(), 0.3f, 1.0f);
            }
        }
    }

    public static void playItemIdleLoop(SoundEvent soundEvent, LivingEntity livingEntity, Item item, float volume, float pitch) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (soundEvent != null && livingEntity.m_6084_()) {
            if (ITEM_TICK == null) {
                ITEM_TICK = new ItemIdleSound(soundEvent, livingEntity, item, volume, pitch);
            }
        } else {
            ITEM_TICK = null;
        }
        if (ITEM_TICK != null && !minecraft.m_91106_().m_120403_((SoundInstance)ITEM_TICK)) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)ITEM_TICK);
        }
    }

    @SubscribeEvent
    public static void onItemUse(LivingEntityUseItemEvent.Start event) {
        if (event.getEntity().m_9236_() instanceof ClientLevel) {
            Minecraft minecraft = Minecraft.m_91087_();
            SoundManager soundHandler = minecraft.m_91106_();
            if (event.getItem().m_150930_((Item)CHItems.ADVANCED_HAND_DRILL.get())) {
                soundHandler.m_120367_((SoundInstance)new ItemLoopSound((SoundEvent)CHSounds.DRILLING.get(), event.getEntity()));
            }
            if (event.getItem().m_150930_((Item)CHItems.ADVANCED_CHAINSAW.get())) {
                soundHandler.m_120367_((SoundInstance)new ItemLoopSound((SoundEvent)CHSounds.CHAINSAW_CUT.get(), event.getEntity()));
            }
            if (event.getItem().m_150930_((Item)CHItems.FLAMETHROWER.get())) {
                soundHandler.m_120367_((SoundInstance)new ItemLoopSound((SoundEvent)CHSounds.FLAMETHROWER_BURNS.get(), event.getEntity()));
            }
        }
    }

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            PARTIAL_TICK = event.renderTickTime;
        }
    }

    @SubscribeEvent
    public static void updateInputEvent(MovementInputUpdateEvent event) {
        LocalPlayer localPlayer;
        Player player = event.getEntity();
        Input input = event.getInput();
        if (player instanceof LocalPlayer && (localPlayer = (LocalPlayer)player).m_6117_() && !localPlayer.m_20159_() && localPlayer.m_21211_().m_220167_(itemHolder -> itemHolder.get() instanceof IEnergyItem || itemHolder.get() instanceof IFuel)) {
            input.f_108566_ *= 5.0f;
            input.f_108567_ *= 5.0f;
        }
    }

    static {
        PARTIAL_TICK = 0.0f;
    }
}

