/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.clanginghowl;

import com.mojang.logging.LogUtils;
import com.mongoose.clanginghowl.client.ClientProxy;
import com.mongoose.clanginghowl.client.inventory.menu.CHMenuTypes;
import com.mongoose.clanginghowl.client.particles.CHParticleTypes;
import com.mongoose.clanginghowl.common.CommonProxy;
import com.mongoose.clanginghowl.common.blocks.CHBlocks;
import com.mongoose.clanginghowl.common.blocks.entities.CHBlockEntities;
import com.mongoose.clanginghowl.common.effects.CHEffects;
import com.mongoose.clanginghowl.common.enchantments.CHEnchantments;
import com.mongoose.clanginghowl.common.entities.CHEntityType;
import com.mongoose.clanginghowl.common.entities.hostiles.ExReaper;
import com.mongoose.clanginghowl.common.entities.hostiles.FleshMaiden;
import com.mongoose.clanginghowl.common.entities.hostiles.HeartOfDecay;
import com.mongoose.clanginghowl.common.items.CHItems;
import com.mongoose.clanginghowl.common.network.CHNetwork;
import com.mongoose.clanginghowl.common.world.CHMobSpawnBiomeModifier;
import com.mongoose.clanginghowl.config.CHConfig;
import com.mongoose.clanginghowl.init.CHCreativeTab;
import com.mongoose.clanginghowl.init.CHProxy;
import com.mongoose.clanginghowl.init.CHSounds;
import com.mongoose.clanginghowl.init.ClientSideInit;
import com.mongoose.clanginghowl.init.SidedInit;
import com.mongoose.clanginghowl.mixin.FireBlockAccessor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod(value="clanginghowl")
public class ClangingHowl {
    public static final String MOD_ID = "clanginghowl";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static CHProxy PROXY = (CHProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    public static SidedInit SIDED_INIT = (SidedInit)DistExecutor.unsafeRunForDist(() -> ClientSideInit::new, () -> SidedInit::new);

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public ClangingHowl() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        CHBlockEntities.BLOCK_ENTITY.register(modEventBus);
        CHEntityType.ENTITY_TYPE.register(modEventBus);
        CHParticleTypes.PARTICLE_TYPES.register(modEventBus);
        CHMenuTypes.MENU_TYPE.register(modEventBus);
        CHEnchantments.ENCHANTMENTS.register(modEventBus);
        CHCreativeTab.CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::setupEntityAttributeCreation);
        modEventBus.addListener(this::SpawnPlacementEvent);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CHConfig.SPEC, "clanginghowl.toml");
        CHConfig.loadConfig(CHConfig.SPEC, FMLPaths.CONFIGDIR.get().resolve("clanginghowl.toml").toString());
        DeferredRegister biomeModifiers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)MOD_ID);
        biomeModifiers.register(modEventBus);
        biomeModifiers.register("mob_spawns", CHMobSpawnBiomeModifier::makeCodec);
        MinecraftForge.EVENT_BUS.register((Object)this);
        CHItems.init();
        CHBlocks.init();
        CHEffects.init();
        CHSounds.init();
        SIDED_INIT.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CHNetwork.init();
        event.enqueueWork(() -> {
            FireBlockAccessor fireBlockAccessor = (FireBlockAccessor)Blocks.f_50083_;
            fireBlockAccessor.callSetFlammable((Block)CHBlocks.TECHNOFLESH_BLOCK.get(), 5, 20);
            fireBlockAccessor.callSetFlammable((Block)CHBlocks.TECHNOFLESH_SLAB.get(), 5, 20);
            fireBlockAccessor.callSetFlammable((Block)CHBlocks.TECHNOFLESH_MEMBRANE.get(), 5, 20);
            fireBlockAccessor.callSetFlammable((Block)CHBlocks.TECHNOFLESH_NEST.get(), 5, 20);
        });
    }

    private void setupEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)CHEntityType.HEART_OF_DECAY.get(), HeartOfDecay.m_33815_().m_22265_());
        event.put((EntityType)CHEntityType.EX_REAPER.get(), ExReaper.createAttributes().m_22265_());
        event.put((EntityType)CHEntityType.FLESH_MAIDEN.get(), FleshMaiden.createAttributes().m_22265_());
    }

    private void SpawnPlacementEvent(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)CHEntityType.HEART_OF_DECAY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HeartOfDecay::checkHoDSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)CHEntityType.EX_REAPER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ExReaper::checkExReaperSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)CHEntityType.FLESH_MAIDEN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FleshMaiden::checkFleshMaidenSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
    }
}

