/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base.data.cast;

import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.IRelicContainer;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.RelicContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CastData {
    private List<IRelicContainer> container;
    private CastType type;
    private Map<String, BiFunction<Player, ItemStack, Boolean>> castPredicates;
    private List<BiFunction<Player, ItemStack, Boolean>> visibilityPredicates;

    private static CastType $default$type() {
        return CastType.NONE;
    }

    CastData(List<IRelicContainer> container, CastType type, Map<String, BiFunction<Player, ItemStack, Boolean>> castPredicates, List<BiFunction<Player, ItemStack, Boolean>> visibilityPredicates) {
        this.container = container;
        this.type = type;
        this.castPredicates = castPredicates;
        this.visibilityPredicates = visibilityPredicates;
    }

    public static CastDataBuilder builder() {
        return new CastDataBuilder();
    }

    public List<IRelicContainer> getContainer() {
        return this.container;
    }

    public CastType getType() {
        return this.type;
    }

    public Map<String, BiFunction<Player, ItemStack, Boolean>> getCastPredicates() {
        return this.castPredicates;
    }

    public List<BiFunction<Player, ItemStack, Boolean>> getVisibilityPredicates() {
        return this.visibilityPredicates;
    }

    public void setContainer(List<IRelicContainer> container) {
        this.container = container;
    }

    public void setType(CastType type) {
        this.type = type;
    }

    public void setCastPredicates(Map<String, BiFunction<Player, ItemStack, Boolean>> castPredicates) {
        this.castPredicates = castPredicates;
    }

    public void setVisibilityPredicates(List<BiFunction<Player, ItemStack, Boolean>> visibilityPredicates) {
        this.visibilityPredicates = visibilityPredicates;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CastData)) {
            return false;
        }
        CastData other = (CastData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<IRelicContainer> this$container = this.getContainer();
        List<IRelicContainer> other$container = other.getContainer();
        if (this$container == null ? other$container != null : !((Object)this$container).equals(other$container)) {
            return false;
        }
        CastType this$type = this.getType();
        CastType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Map<String, BiFunction<Player, ItemStack, Boolean>> this$castPredicates = this.getCastPredicates();
        Map<String, BiFunction<Player, ItemStack, Boolean>> other$castPredicates = other.getCastPredicates();
        if (this$castPredicates == null ? other$castPredicates != null : !((Object)this$castPredicates).equals(other$castPredicates)) {
            return false;
        }
        List<BiFunction<Player, ItemStack, Boolean>> this$visibilityPredicates = this.getVisibilityPredicates();
        List<BiFunction<Player, ItemStack, Boolean>> other$visibilityPredicates = other.getVisibilityPredicates();
        return !(this$visibilityPredicates == null ? other$visibilityPredicates != null : !((Object)this$visibilityPredicates).equals(other$visibilityPredicates));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CastData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<IRelicContainer> $container = this.getContainer();
        result = result * 59 + ($container == null ? 43 : ((Object)$container).hashCode());
        CastType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Map<String, BiFunction<Player, ItemStack, Boolean>> $castPredicates = this.getCastPredicates();
        result = result * 59 + ($castPredicates == null ? 43 : ((Object)$castPredicates).hashCode());
        List<BiFunction<Player, ItemStack, Boolean>> $visibilityPredicates = this.getVisibilityPredicates();
        result = result * 59 + ($visibilityPredicates == null ? 43 : ((Object)$visibilityPredicates).hashCode());
        return result;
    }

    public String toString() {
        return "CastData(container=" + String.valueOf(this.getContainer()) + ", type=" + String.valueOf((Object)this.getType()) + ", castPredicates=" + String.valueOf(this.getCastPredicates()) + ", visibilityPredicates=" + String.valueOf(this.getVisibilityPredicates()) + ")";
    }

    public static class CastDataBuilder {
        private boolean type$set;
        private CastType type$value;
        private Map<String, BiFunction<Player, ItemStack, Boolean>> castPredicates = new HashMap<String, BiFunction<Player, ItemStack, Boolean>>();
        List<BiFunction<Player, ItemStack, Boolean>> visibilityPredicates = new ArrayList<BiFunction<Player, ItemStack, Boolean>>();
        private List<IRelicContainer> container = List.of(RelicContainer.CURIOS);

        public CastDataBuilder castPredicate(String id, BiFunction<Player, ItemStack, Boolean> predicate) {
            this.castPredicates.put(id, predicate);
            return this;
        }

        public CastDataBuilder visibilityPredicate(BiFunction<Player, ItemStack, Boolean> predicate) {
            this.visibilityPredicates.add(predicate);
            return this;
        }

        public CastDataBuilder container(RelicContainer ... container) {
            this.container = Arrays.asList(container);
            return this;
        }

        CastDataBuilder() {
        }

        public CastDataBuilder type(CastType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public CastDataBuilder castPredicates(Map<String, BiFunction<Player, ItemStack, Boolean>> castPredicates) {
            this.castPredicates = castPredicates;
            return this;
        }

        public CastDataBuilder visibilityPredicates(List<BiFunction<Player, ItemStack, Boolean>> visibilityPredicates) {
            this.visibilityPredicates = visibilityPredicates;
            return this;
        }

        public CastData build() {
            CastType type$value = this.type$value;
            if (!this.type$set) {
                type$value = CastData.$default$type();
            }
            return new CastData(this.container, type$value, this.castPredicates, this.visibilityPredicates);
        }

        public String toString() {
            return "CastData.CastDataBuilder(container=" + String.valueOf(this.container) + ", type$value=" + String.valueOf((Object)this.type$value) + ", castPredicates=" + String.valueOf(this.castPredicates) + ", visibilityPredicates=" + String.valueOf(this.visibilityPredicates) + ")";
        }
    }
}

