/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.registry.datapack;

import com.mojang.datafixers.util.Pair;
import com.rosemods.windswept.core.Windswept;
import com.rosemods.windswept.core.registry.datapack.WindsweptBiomes;
import com.teamabnormals.blueprint.common.world.modification.ModdedBiomeSlice;
import com.teamabnormals.blueprint.core.registry.BlueprintBiomes;
import com.teamabnormals.blueprint.core.registry.BlueprintDataPackRegistries;
import com.teamabnormals.blueprint.core.util.BiomeUtil;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.dimension.LevelStem;

public final class WindsweptBiomeSlices {
    public static final ResourceKey<ModdedBiomeSlice> CHESTNUT_SLICE = WindsweptBiomeSlices.createKey("chestnut");
    public static final ResourceKey<ModdedBiomeSlice> PINE_SLICE = WindsweptBiomeSlices.createKey("pine");
    public static final ResourceKey<ModdedBiomeSlice> TUNDRA_SLICE = WindsweptBiomeSlices.createKey("tundra");
    public static final ResourceKey<ModdedBiomeSlice> LAVENDER_SLICE = WindsweptBiomeSlices.createKey("lavender");
    public static final ResourceKey<ModdedBiomeSlice> SAVANNA_SLICE = WindsweptBiomeSlices.createKey("savanna");
    public static final ResourceKey<Biome> CHESTNUT_FOREST_AREA = WindsweptBiomes.createKey("chestnut_forest_area");
    public static final ResourceKey<Biome> SNOWY_CHESTNUT_FOREST_AREA = WindsweptBiomes.createKey("snowy_chestnut_forest_area");
    public static final ResourceKey<Biome> PINE_BARRENS_AREA = WindsweptBiomes.createKey("pine_barrens_area");
    public static final ResourceKey<Biome> SNOWY_PINE_BARRENS_AREA = WindsweptBiomes.createKey("snowy_pine_barrens_area");
    public static final ResourceKey<Biome> LAVENDER_HILLS_AREA = WindsweptBiomes.createKey("lavender_hills_area");
    public static final ResourceKey<Biome> LAVENDER_FIELDS_AREA = WindsweptBiomes.createKey("lavender_fields_area");
    public static final ResourceKey<Biome> TUNDRA_AREA = WindsweptBiomes.createKey("tundra_area");
    public static final ResourceKey<Biome> FLOWERING_SAVANNA_AREA = WindsweptBiomes.createKey("flowering_savanna_area");

    public static void bootstrap(BootstapContext<ModdedBiomeSlice> context) {
        ArrayList entries = new ArrayList();
        new WindsweptBiomeBuilder().addBiomesToSlice(entries::add);
        context.m_255272_(CHESTNUT_SLICE, (Object)new ModdedBiomeSlice(30, (BiomeUtil.ModdedBiomeProvider)BiomeUtil.MultiNoiseModdedBiomeProvider.builder().biomes(entries::forEach).area(CHESTNUT_FOREST_AREA, WindsweptBiomes.CHESTNUT_FOREST).area(SNOWY_CHESTNUT_FOREST_AREA, WindsweptBiomes.SNOWY_CHESTNUT_FOREST).build(), new ResourceKey[]{LevelStem.f_63971_}));
        context.m_255272_(PINE_SLICE, (Object)new ModdedBiomeSlice(30, (BiomeUtil.ModdedBiomeProvider)BiomeUtil.MultiNoiseModdedBiomeProvider.builder().biomes(entries::forEach).area(PINE_BARRENS_AREA, WindsweptBiomes.PINE_BARRENS).area(SNOWY_PINE_BARRENS_AREA, WindsweptBiomes.SNOWY_PINE_BARRENS).build(), new ResourceKey[]{LevelStem.f_63971_}));
        context.m_255272_(LAVENDER_SLICE, (Object)new ModdedBiomeSlice(16, (BiomeUtil.ModdedBiomeProvider)BiomeUtil.MultiNoiseModdedBiomeProvider.builder().biomes(entries::forEach).area(LAVENDER_HILLS_AREA, WindsweptBiomes.LAVENDER_HILLS).area(LAVENDER_FIELDS_AREA, WindsweptBiomes.LAVENDER_FIELDS).build(), new ResourceKey[]{LevelStem.f_63971_}));
        context.m_255272_(TUNDRA_SLICE, (Object)new ModdedBiomeSlice(8, (BiomeUtil.ModdedBiomeProvider)BiomeUtil.MultiNoiseModdedBiomeProvider.builder().biomes(entries::forEach).area(TUNDRA_AREA, WindsweptBiomes.TUNDRA).build(), new ResourceKey[]{LevelStem.f_63971_}));
        context.m_255272_(SAVANNA_SLICE, (Object)new ModdedBiomeSlice(20, (BiomeUtil.ModdedBiomeProvider)BiomeUtil.MultiNoiseModdedBiomeProvider.builder().biomes(entries::forEach).area(FLOWERING_SAVANNA_AREA, WindsweptBiomes.FLOWERING_SAVANNA).build(), new ResourceKey[]{LevelStem.f_63971_}));
    }

    private static ResourceKey<ModdedBiomeSlice> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)BlueprintDataPackRegistries.MODDED_BIOME_SLICES, (ResourceLocation)Windswept.location(name));
    }

    private static final class WindsweptBiomeBuilder {
        private final Climate.Parameter FULL_RANGE = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
        private final Climate.Parameter[] temperatures = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.45f), Climate.Parameter.m_186822_((float)-0.45f, (float)-0.15f), Climate.Parameter.m_186822_((float)-0.15f, (float)0.2f), Climate.Parameter.m_186822_((float)0.2f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
        private final Climate.Parameter[] humidities = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.35f), Climate.Parameter.m_186822_((float)-0.35f, (float)-0.1f), Climate.Parameter.m_186822_((float)-0.1f, (float)0.1f), Climate.Parameter.m_186822_((float)0.1f, (float)0.3f), Climate.Parameter.m_186822_((float)0.3f, (float)1.0f)};
        private final Climate.Parameter[] erosions = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.78f), Climate.Parameter.m_186822_((float)-0.78f, (float)-0.375f), Climate.Parameter.m_186822_((float)-0.375f, (float)-0.2225f), Climate.Parameter.m_186822_((float)-0.2225f, (float)0.05f), Climate.Parameter.m_186822_((float)0.05f, (float)0.45f), Climate.Parameter.m_186822_((float)0.45f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
        private final Climate.Parameter FROZEN_RANGE = this.temperatures[0];
        private final Climate.Parameter UNFROZEN_RANGE = Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[1], (Climate.Parameter)this.temperatures[4]);
        private final Climate.Parameter mushroomFieldsContinentalness = Climate.Parameter.m_186822_((float)-1.2f, (float)-1.05f);
        private final Climate.Parameter deepOceanContinentalness = Climate.Parameter.m_186822_((float)-1.05f, (float)-0.455f);
        private final Climate.Parameter oceanContinentalness = Climate.Parameter.m_186822_((float)-0.455f, (float)-0.19f);
        private final Climate.Parameter coastContinentalness = Climate.Parameter.m_186822_((float)-0.19f, (float)-0.11f);
        private final Climate.Parameter inlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.55f);
        private final Climate.Parameter nearInlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.03f);
        private final Climate.Parameter midInlandContinentalness = Climate.Parameter.m_186822_((float)0.03f, (float)0.3f);
        private final Climate.Parameter farInlandContinentalness = Climate.Parameter.m_186822_((float)0.3f, (float)1.0f);
        private final ResourceKey<Biome> VANILLA = BlueprintBiomes.ORIGINAL_SOURCE_MARKER;
        private final ResourceKey<Biome>[][] MIDDLE_BIOMES = new ResourceKey[][]{{TUNDRA_AREA, TUNDRA_AREA, TUNDRA_AREA, SNOWY_CHESTNUT_FOREST_AREA, CHESTNUT_FOREST_AREA}, {LAVENDER_FIELDS_AREA, LAVENDER_FIELDS_AREA, this.VANILLA, CHESTNUT_FOREST_AREA, PINE_BARRENS_AREA}, {this.VANILLA, LAVENDER_FIELDS_AREA, this.VANILLA, this.VANILLA, this.VANILLA}, {FLOWERING_SAVANNA_AREA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}, {this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}};
        private final ResourceKey<Biome>[][] MIDDLE_BIOMES_VARIANT = new ResourceKey[][]{{this.VANILLA, null, SNOWY_CHESTNUT_FOREST_AREA, null, null}, {null, null, null, null, PINE_BARRENS_AREA}, {LAVENDER_FIELDS_AREA, null, null, LAVENDER_HILLS_AREA, null}, {null, null, LAVENDER_FIELDS_AREA, this.VANILLA, this.VANILLA}, {null, null, null, null, null}};
        private final ResourceKey<Biome>[][] PLATEAU_BIOMES = new ResourceKey[][]{{TUNDRA_AREA, TUNDRA_AREA, TUNDRA_AREA, SNOWY_CHESTNUT_FOREST_AREA, SNOWY_CHESTNUT_FOREST_AREA}, {LAVENDER_HILLS_AREA, LAVENDER_HILLS_AREA, this.VANILLA, CHESTNUT_FOREST_AREA, PINE_BARRENS_AREA}, {LAVENDER_HILLS_AREA, LAVENDER_HILLS_AREA, LAVENDER_HILLS_AREA, LAVENDER_HILLS_AREA, this.VANILLA}, {FLOWERING_SAVANNA_AREA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}, {this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}};
        private final ResourceKey<Biome>[][] PLATEAU_BIOMES_VARIANT = new ResourceKey[][]{{this.VANILLA, null, null, null, null}, {null, null, LAVENDER_HILLS_AREA, LAVENDER_HILLS_AREA, this.VANILLA}, {null, null, this.VANILLA, this.VANILLA, null}, {null, null, null, null, null}, {this.VANILLA, this.VANILLA, null, null, null}};

        private WindsweptBiomeBuilder() {
        }

        private void addBiomesToSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
            this.addOffCoastBiomes(consumer);
            this.addInlandBiomes(consumer);
            this.addUndergroundBiomes(consumer);
        }

        private void addOffCoastBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.VANILLA);
            for (Climate.Parameter temperature : this.temperatures) {
                this.addSurfaceBiome(consumer, temperature, this.FULL_RANGE, this.deepOceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.VANILLA);
                this.addSurfaceBiome(consumer, temperature, this.FULL_RANGE, this.oceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.VANILLA);
            }
        }

        private void addInlandBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
            this.addMidSlice(consumer, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.93333334f));
            this.addHighSlice(consumer, Climate.Parameter.m_186822_((float)-0.93333334f, (float)-0.7666667f));
            this.addPeaks(consumer, Climate.Parameter.m_186822_((float)-0.7666667f, (float)-0.56666666f));
            this.addHighSlice(consumer, Climate.Parameter.m_186822_((float)-0.56666666f, (float)-0.4f));
            this.addMidSlice(consumer, Climate.Parameter.m_186822_((float)-0.4f, (float)-0.26666668f));
            this.addLowSlice(consumer, Climate.Parameter.m_186822_((float)-0.26666668f, (float)-0.05f));
            this.addValleys(consumer, Climate.Parameter.m_186822_((float)-0.05f, (float)0.05f));
            this.addLowSlice(consumer, Climate.Parameter.m_186822_((float)0.05f, (float)0.26666668f));
            this.addMidSlice(consumer, Climate.Parameter.m_186822_((float)0.26666668f, (float)0.4f));
            this.addHighSlice(consumer, Climate.Parameter.m_186822_((float)0.4f, (float)0.56666666f));
            this.addPeaks(consumer, Climate.Parameter.m_186822_((float)0.56666666f, (float)0.7666667f));
            this.addHighSlice(consumer, Climate.Parameter.m_186822_((float)0.7666667f, (float)0.93333334f));
            this.addMidSlice(consumer, Climate.Parameter.m_186822_((float)0.93333334f, (float)1.0f));
        }

        private void addPeaks(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter weirdness) {
            for (int i = 0; i < this.temperatures.length; ++i) {
                Climate.Parameter temperature = this.temperatures[i];
                for (int j = 0; j < this.humidities.length; ++j) {
                    Climate.Parameter humidity = this.humidities[j];
                    ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, weirdness);
                    ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, weirdness);
                    ResourceKey<Biome> resourcekey3 = this.pickPlateauBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey4 = this.pickShatteredBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey5 = this.maybePickWindsweptSavannaBiome(i, j, weirdness, resourcekey4);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, this.VANILLA);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[1], weirdness, 0.0f, resourcekey2);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, this.VANILLA);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, resourcekey3);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, resourcekey1);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, resourcekey3);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, resourcekey5);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, resourcekey4);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, resourcekey);
                }
            }
        }

        private void addHighSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter weirdness) {
            for (int i = 0; i < this.temperatures.length; ++i) {
                Climate.Parameter temperature = this.temperatures[i];
                for (int j = 0; j < this.humidities.length; ++j) {
                    Climate.Parameter humidity = this.humidities[j];
                    ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, weirdness);
                    ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, weirdness);
                    ResourceKey<Biome> resourcekey3 = this.pickPlateauBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey4 = this.pickShatteredBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey5 = this.maybePickWindsweptSavannaBiome(i, j, weirdness, resourcekey);
                    ResourceKey<Biome> resourcekey6 = this.pickSlopeBiome(i, j, weirdness);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.nearInlandContinentalness, this.erosions[0], weirdness, 0.0f, resourcekey6);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, this.VANILLA);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.nearInlandContinentalness, this.erosions[1], weirdness, 0.0f, resourcekey2);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, resourcekey6);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, resourcekey3);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, resourcekey1);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, resourcekey3);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, resourcekey5);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, resourcekey4);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, resourcekey);
                }
            }
        }

        private void addMidSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter weirdness) {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, this.VANILLA);
            this.addSurfaceBiome(consumer, this.UNFROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, this.VANILLA);
            for (int i = 0; i < this.temperatures.length; ++i) {
                Climate.Parameter temperature = this.temperatures[i];
                for (int j = 0; j < this.humidities.length; ++j) {
                    Climate.Parameter humidity = this.humidities[j];
                    ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, weirdness);
                    ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, weirdness);
                    ResourceKey<Biome> resourcekey3 = this.pickShatteredBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey4 = this.pickPlateauBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey6 = this.maybePickWindsweptSavannaBiome(i, j, weirdness, resourcekey);
                    ResourceKey<Biome> resourcekey7 = this.pickShatteredCoastBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey8 = this.pickSlopeBiome(i, j, weirdness);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, resourcekey8);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.midInlandContinentalness), this.erosions[1], weirdness, 0.0f, resourcekey2);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.farInlandContinentalness, this.erosions[1], weirdness, 0.0f, i == 0 ? resourcekey8 : resourcekey4);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.nearInlandContinentalness, this.erosions[2], weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.midInlandContinentalness, this.erosions[2], weirdness, 0.0f, resourcekey1);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.farInlandContinentalness, this.erosions[2], weirdness, 0.0f, resourcekey4);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[3], weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[3], weirdness, 0.0f, resourcekey1);
                    if (weirdness.f_186814_() < 0L) {
                        this.addSurfaceBiome(consumer, temperature, humidity, this.coastContinentalness, this.erosions[4], weirdness, 0.0f, this.VANILLA);
                        this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, resourcekey);
                    } else {
                        this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, resourcekey);
                    }
                    this.addSurfaceBiome(consumer, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, resourcekey7);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, resourcekey6);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, resourcekey3);
                    if (weirdness.f_186814_() < 0L) {
                        this.addSurfaceBiome(consumer, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, this.VANILLA);
                    } else {
                        this.addSurfaceBiome(consumer, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, resourcekey);
                    }
                    if (i != 0) continue;
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, resourcekey);
                }
            }
        }

        private void addLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter weirdness) {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, this.VANILLA);
            this.addSurfaceBiome(consumer, this.UNFROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, this.VANILLA);
            for (int i = 0; i < this.temperatures.length; ++i) {
                Climate.Parameter temperature = this.temperatures[i];
                for (int j = 0; j < this.humidities.length; ++j) {
                    Climate.Parameter humidity = this.humidities[j];
                    ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, weirdness);
                    ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, weirdness);
                    ResourceKey<Biome> resourcekey3 = this.VANILLA;
                    ResourceKey<Biome> resourcekey4 = this.maybePickWindsweptSavannaBiome(i, j, weirdness, resourcekey);
                    ResourceKey<Biome> resourcekey5 = this.pickShatteredCoastBiome(i, j, weirdness);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, resourcekey1);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, resourcekey2);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, resourcekey1);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[3], (Climate.Parameter)this.erosions[4]), weirdness, 0.0f, resourcekey3);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, resourcekey5);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, resourcekey4);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, resourcekey3);
                    if (i != 0) continue;
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, resourcekey);
                }
            }
        }

        private void addValleys(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter weirdness) {
            this.addSurfaceBiome(consumer, this.FROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, this.VANILLA);
            this.addSurfaceBiome(consumer, this.UNFROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, this.VANILLA);
            this.addSurfaceBiome(consumer, this.FROZEN_RANGE, this.FULL_RANGE, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, this.VANILLA);
            this.addSurfaceBiome(consumer, this.UNFROZEN_RANGE, this.FULL_RANGE, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, this.VANILLA);
            this.addSurfaceBiome(consumer, this.FROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), weirdness, 0.0f, this.VANILLA);
            this.addSurfaceBiome(consumer, this.UNFROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), weirdness, 0.0f, this.VANILLA);
            this.addSurfaceBiome(consumer, this.FROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, this.VANILLA);
            this.addSurfaceBiome(consumer, this.UNFROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, this.VANILLA);
            this.addSurfaceBiome(consumer, this.UNFROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, this.VANILLA);
            this.addSurfaceBiome(consumer, this.FROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, this.VANILLA);
            for (int i = 0; i < this.temperatures.length; ++i) {
                Climate.Parameter temperature = this.temperatures[i];
                for (int j = 0; j < this.humidities.length; ++j) {
                    Climate.Parameter humidity = this.humidities[j];
                    ResourceKey<Biome> resourcekey = this.pickMiddleBiomeOrBadlandsIfHot(i, j, weirdness);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, resourcekey);
                }
            }
        }

        private void addUndergroundBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
            this.addUndergroundBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.8f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.VANILLA);
            this.addUndergroundBiome(consumer, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.7f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.VANILLA);
        }

        private ResourceKey<Biome> pickMiddleBiome(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
            if (weirdness.f_186814_() < 0L) {
                return this.MIDDLE_BIOMES[temperatureIndex][humidityIndex];
            }
            ResourceKey<Biome> resourcekey = this.MIDDLE_BIOMES_VARIANT[temperatureIndex][humidityIndex];
            return resourcekey == null ? this.MIDDLE_BIOMES[temperatureIndex][humidityIndex] : resourcekey;
        }

        private ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHot(int p_187192_, int p_187193_, Climate.Parameter p_187194_) {
            return p_187192_ == 4 ? this.VANILLA : this.pickMiddleBiome(p_187192_, p_187193_, p_187194_);
        }

        private ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(int p_187212_, int p_187213_, Climate.Parameter p_187214_) {
            return p_187212_ == 0 ? this.pickSlopeBiome(p_187212_, p_187213_, p_187214_) : this.pickMiddleBiomeOrBadlandsIfHot(p_187212_, p_187213_, p_187214_);
        }

        private ResourceKey<Biome> maybePickWindsweptSavannaBiome(int p_201991_, int p_201992_, Climate.Parameter p_201993_, ResourceKey<Biome> p_201994_) {
            return p_201991_ > 1 && p_201992_ < 4 && p_201993_.f_186814_() >= 0L ? this.VANILLA : p_201994_;
        }

        private ResourceKey<Biome> pickShatteredCoastBiome(int temperatureIndex, int humidityIndex, Climate.Parameter p_187225_) {
            ResourceKey<Biome> resourcekey = p_187225_.f_186814_() >= 0L ? this.pickMiddleBiome(temperatureIndex, humidityIndex, p_187225_) : this.VANILLA;
            return this.maybePickWindsweptSavannaBiome(temperatureIndex, humidityIndex, p_187225_, resourcekey);
        }

        private ResourceKey<Biome> pickPlateauBiome(int p_187234_, int p_187235_, Climate.Parameter p_187236_) {
            if (p_187236_.f_186814_() < 0L) {
                return this.PLATEAU_BIOMES[p_187234_][p_187235_];
            }
            ResourceKey<Biome> resourcekey = this.PLATEAU_BIOMES_VARIANT[p_187234_][p_187235_];
            return resourcekey == null ? this.PLATEAU_BIOMES[p_187234_][p_187235_] : resourcekey;
        }

        private ResourceKey<Biome> pickSlopeBiome(int p_187245_, int p_187246_, Climate.Parameter p_187247_) {
            if (p_187245_ >= 3) {
                return this.pickPlateauBiome(p_187245_, p_187246_, p_187247_);
            }
            return SNOWY_PINE_BARRENS_AREA;
        }

        private ResourceKey<Biome> pickShatteredBiome(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
            return temperatureIndex > 2 ? this.pickMiddleBiome(temperatureIndex, humidityIndex, weirdness) : this.VANILLA;
        }

        private void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187181_, Climate.Parameter p_187182_, Climate.Parameter p_187183_, Climate.Parameter p_187184_, Climate.Parameter p_187185_, Climate.Parameter p_187186_, float p_187187_, ResourceKey<Biome> p_187188_) {
            p_187181_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)p_187182_, (Climate.Parameter)p_187183_, (Climate.Parameter)p_187184_, (Climate.Parameter)p_187185_, (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)p_187186_, (float)p_187187_), p_187188_));
            p_187181_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)p_187182_, (Climate.Parameter)p_187183_, (Climate.Parameter)p_187184_, (Climate.Parameter)p_187185_, (Climate.Parameter)Climate.Parameter.m_186820_((float)1.0f), (Climate.Parameter)p_187186_, (float)p_187187_), p_187188_));
        }

        private void addUndergroundBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187201_, Climate.Parameter p_187202_, Climate.Parameter p_187203_, Climate.Parameter p_187204_, Climate.Parameter p_187205_, Climate.Parameter p_187206_, float p_187207_, ResourceKey<Biome> p_187208_) {
            p_187201_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)p_187202_, (Climate.Parameter)p_187203_, (Climate.Parameter)p_187204_, (Climate.Parameter)p_187205_, (Climate.Parameter)Climate.Parameter.m_186822_((float)0.2f, (float)0.9f), (Climate.Parameter)p_187206_, (float)p_187207_), p_187208_));
        }
    }
}

