/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.data.server;

import com.google.common.collect.ImmutableList;
import com.rosemods.windswept.common.block.GingerCropBlock;
import com.rosemods.windswept.common.block.LavenderBlock;
import com.rosemods.windswept.common.block.PineconeBlock;
import com.rosemods.windswept.core.Windswept;
import com.rosemods.windswept.core.registry.WindsweptBlocks;
import com.rosemods.windswept.core.registry.WindsweptEntityTypes;
import com.rosemods.windswept.core.registry.WindsweptItems;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.Tags;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class WindsweptLootTableProvider
extends LootTableProvider {
    public WindsweptLootTableProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), BuiltInLootTables.m_78766_(), (List)ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(WindsweptBlockLoot::new, LootContextParamSets.f_81421_), (Object)new LootTableProvider.SubProviderEntry(WindsweptEntityLoot::new, LootContextParamSets.f_81415_), (Object)new LootTableProvider.SubProviderEntry(WindsweptChestLoot::new, LootContextParamSets.f_81411_), (Object)new LootTableProvider.SubProviderEntry(WindsweptArchaeologyLoot::new, LootContextParamSets.f_271368_)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    private static <T> Stream<T> getContent(IForgeRegistry<T> entry) {
        return entry.getValues().stream().filter(i -> entry.getKey(i) != null && "windswept".equals(entry.getKey(i).m_135827_()));
    }

    private static class WindsweptArchaeologyLoot
    implements LootTableSubProvider {
        private WindsweptArchaeologyLoot() {
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> builder) {
            WindsweptArchaeologyLoot.register("pine_totem", LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.HOOT_POTTERY_SHERD.get())).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.PLUMAGE_POTTERY_SHERD.get())).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.ELDER_FEATHER.get())).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptBlocks.PINECONE.get())).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79707_(1))), builder);
            WindsweptArchaeologyLoot.register("snowy_pine_totem", LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.HOOT_POTTERY_SHERD.get())).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.FLAKE_POTTERY_SHERD.get())).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.PLUMAGE_POTTERY_SHERD.get())).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.ELDER_FEATHER.get())).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptBlocks.PINECONE.get())).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.FROZEN_FLESH.get())).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79707_(1))), builder);
            WindsweptArchaeologyLoot.register("grove_weathered_house", LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.FLAKE_POTTERY_SHERD.get())).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.OFFSHOOT_POTTERY_SHERD.get())).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.DRUPES_POTTERY_SHERD.get())).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.ELDER_FEATHER.get())).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.HOLLY_BERRIES.get())).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.FROZEN_FLESH.get())).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79707_(1))), builder);
        }

        private static void register(String name, LootTable.Builder lootTable, BiConsumer<ResourceLocation, LootTable.Builder> builder) {
            builder.accept(Windswept.location("archaeology/" + name), lootTable);
        }
    }

    private static class WindsweptChestLoot
    implements LootTableSubProvider {
        private WindsweptChestLoot() {
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> builder) {
            WindsweptChestLoot.register("grove_weathered_house", LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)8.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42417_).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptBlocks.SNOWY_SPROUTS.get())).m_79707_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.SNOW_BOOTS.get())).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)20.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42517_).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.WOODEN_BUCKET.get())).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)20.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.SWEET_SNOW_CONE.get())).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.WILD_BERRIES.get())).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptBlocks.ICICLES.get())).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42452_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41863_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptBlocks.HOLLY_SAPLING.get())).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.COOKED_GOAT.get())).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))), builder);
            WindsweptChestLoot.register("chestnut_weathered_house", LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41865_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42780_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptBlocks.CHESTNUT_LOG.get())).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41863_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptBlocks.CHESTNUT_SAPLING.get())).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42801_).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.WOODEN_BUCKET.get())).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)20.0f))))), builder);
            WindsweptChestLoot.register("village/village_frozen_house", LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.GINGER_ROOT.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptBlocks.SHALE.get())).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptBlocks.HOLLY_LOG.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptBlocks.BLUE_ICE_BRICKS.get())).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42733_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41938_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42452_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42734_))), builder);
        }

        private static void register(String name, LootTable.Builder lootTable, BiConsumer<ResourceLocation, LootTable.Builder> builder) {
            builder.accept(Windswept.location("chests/" + name), lootTable);
        }
    }

    private static class WindsweptEntityLoot
    extends EntityLootSubProvider {
        protected WindsweptEntityLoot() {
            super(FeatureFlags.f_244280_.m_247355_());
        }

        public void m_246942_() {
            this.m_245309_((EntityType)WindsweptEntityTypes.CHILLED.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.FROZEN_FLESH.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)-2.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptBlocks.ICICLES.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)-3.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42417_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42732_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42410_).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_244460_)))).m_79080_(LootItemKilledByPlayerCondition.m_81901_()).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(() -> WindsweptItems.MUSIC_DISC_SNOW.get())).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_204077_(EntityTypeTags.f_13120_)))));
            this.m_245309_((EntityType)WindsweptEntityTypes.FROSTBITER.get(), LootTable.m_79147_());
        }

        public Stream<EntityType<?>> getKnownEntityTypes() {
            return WindsweptLootTableProvider.getContent(ForgeRegistries.ENTITY_TYPES);
        }
    }

    private static class WindsweptBlockLoot
    extends BlockLootSubProvider {
        private static final Set<Item> EXPLOSION_RESISTANT = Stream.of(Blocks.f_50260_, Blocks.f_50273_, Blocks.f_50569_, Blocks.f_50310_, Blocks.f_50312_, Blocks.f_50316_, Blocks.f_50314_, Blocks.f_50318_, Blocks.f_50320_, Blocks.f_260630_, Blocks.f_50456_, Blocks.f_50525_, Blocks.f_50521_, Blocks.f_50522_, Blocks.f_50466_, Blocks.f_50464_, Blocks.f_50523_, Blocks.f_50460_, Blocks.f_50465_, Blocks.f_50462_, Blocks.f_50459_, Blocks.f_50458_, Blocks.f_50463_, Blocks.f_50520_, Blocks.f_50524_, Blocks.f_50457_, Blocks.f_50461_).map(ItemLike::m_5456_).collect(Collectors.toSet());

        protected WindsweptBlockLoot() {
            super(EXPLOSION_RESISTANT, FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            this.m_245724_((Block)WindsweptBlocks.STRIPPED_HOLLY_LOG.get());
            this.m_245724_((Block)WindsweptBlocks.STRIPPED_HOLLY_WOOD.get());
            this.m_245724_((Block)WindsweptBlocks.HOLLY_LOG.get());
            this.m_245724_((Block)WindsweptBlocks.HOLLY_WOOD.get());
            this.m_245724_((Block)WindsweptBlocks.HOLLY_PLANKS.get());
            this.m_246481_((Block)WindsweptBlocks.HOLLY_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.HOLLY_STAIRS.get());
            this.m_245724_((Block)WindsweptBlocks.HOLLY_FENCE.get());
            this.m_245724_((Block)WindsweptBlocks.HOLLY_FENCE_GATE.get());
            this.m_245724_((Block)WindsweptBlocks.HOLLY_PRESSURE_PLATE.get());
            this.m_246481_((Block)WindsweptBlocks.HOLLY_DOOR.get(), x$0 -> this.m_247398_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.HOLLY_TRAPDOOR.get());
            this.m_245724_((Block)WindsweptBlocks.HOLLY_BUTTON.get());
            this.m_245724_((Block)((RegistryObject)WindsweptBlocks.HOLLY_SIGNS.getFirst()).get());
            this.m_245724_((Block)((RegistryObject)WindsweptBlocks.HOLLY_HANGING_SIGNS.getFirst()).get());
            this.m_245724_((Block)WindsweptBlocks.HOLLY_SAPLING.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_HOLLY_SAPLING.get());
            this.m_246481_((Block)WindsweptBlocks.HOLLY_BEEHIVE.get(), x$0 -> WindsweptBlockLoot.m_247247_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.HOLLY_LADDER.get());
            this.bookshelf((Block)WindsweptBlocks.HOLLY_BOOKSHELF.get());
            this.m_245644_((Block)WindsweptBlocks.CHISELED_HOLLY_BOOKSHELF.get());
            this.m_245724_((Block)WindsweptBlocks.HOLLY_BOARDS.get());
            this.m_245724_((Block)WindsweptBlocks.HOLLY_CHEST.get());
            this.m_245724_((Block)WindsweptBlocks.TRAPPED_HOLLY_CHEST.get());
            this.m_246481_((Block)WindsweptBlocks.HOLLY_LEAVES.get(), b -> this.m_246047_((Block)b, (Block)WindsweptBlocks.HOLLY_SAPLING.get(), new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f}).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(f_244248_).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)this.m_247733_((ItemLike)b, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.HOLLY_BERRIES.get())))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)-6.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)))));
            this.leafPile((Block)WindsweptBlocks.HOLLY_LEAF_PILE.get());
            this.m_245724_((Block)WindsweptBlocks.HOLLY_BERRY_BASKET.get());
            this.m_245724_((Block)WindsweptBlocks.STRIPPED_CHESTNUT_LOG.get());
            this.m_245724_((Block)WindsweptBlocks.STRIPPED_CHESTNUT_WOOD.get());
            this.m_245724_((Block)WindsweptBlocks.CHESTNUT_LOG.get());
            this.m_245724_((Block)WindsweptBlocks.CHESTNUT_WOOD.get());
            this.m_245724_((Block)WindsweptBlocks.CHESTNUT_PLANKS.get());
            this.m_246481_((Block)WindsweptBlocks.CHESTNUT_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.CHESTNUT_STAIRS.get());
            this.m_245724_((Block)WindsweptBlocks.CHESTNUT_FENCE.get());
            this.m_245724_((Block)WindsweptBlocks.CHESTNUT_FENCE_GATE.get());
            this.m_245724_((Block)WindsweptBlocks.CHESTNUT_PRESSURE_PLATE.get());
            this.m_246481_((Block)WindsweptBlocks.CHESTNUT_DOOR.get(), x$0 -> this.m_247398_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.CHESTNUT_TRAPDOOR.get());
            this.m_245724_((Block)WindsweptBlocks.CHESTNUT_BUTTON.get());
            this.m_245724_((Block)((RegistryObject)WindsweptBlocks.CHESTNUT_SIGNS.getFirst()).get());
            this.m_245724_((Block)((RegistryObject)WindsweptBlocks.CHESTNUT_HANGING_SIGNS.getFirst()).get());
            this.m_245724_((Block)WindsweptBlocks.CHESTNUT_SAPLING.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_CHESTNUT_SAPLING.get());
            this.m_246481_((Block)WindsweptBlocks.CHESTNUT_BEEHIVE.get(), x$0 -> WindsweptBlockLoot.m_247247_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.CHESTNUT_LADDER.get());
            this.bookshelf((Block)WindsweptBlocks.CHESTNUT_BOOKSHELF.get());
            this.m_245644_((Block)WindsweptBlocks.CHISELED_CHESTNUT_BOOKSHELF.get());
            this.m_245724_((Block)WindsweptBlocks.CHESTNUT_BOARDS.get());
            this.m_245724_((Block)WindsweptBlocks.CHESTNUT_CHEST.get());
            this.m_245724_((Block)WindsweptBlocks.TRAPPED_CHESTNUT_CHEST.get());
            this.m_246481_((Block)WindsweptBlocks.CHESTNUT_LEAVES.get(), b -> this.m_246047_((Block)b, (Block)WindsweptBlocks.CHESTNUT_SAPLING.get(), new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f}).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(f_244248_).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)this.m_247733_((ItemLike)b, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.CHESTNUTS.get())))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)-4.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)))));
            this.leafPile((Block)WindsweptBlocks.CHESTNUT_LEAF_PILE.get());
            this.m_245724_((Block)WindsweptBlocks.CHESTNUT_CRATE.get());
            this.m_245724_((Block)WindsweptBlocks.ROASTED_CHESTNUT_CRATE.get());
            this.m_245724_((Block)WindsweptBlocks.STRIPPED_PINE_LOG.get());
            this.m_245724_((Block)WindsweptBlocks.STRIPPED_PINE_WOOD.get());
            this.m_245724_((Block)WindsweptBlocks.WEATHERED_PINE_LOG.get());
            this.m_245724_((Block)WindsweptBlocks.WEATHERED_PINE_WOOD.get());
            this.m_245724_((Block)WindsweptBlocks.PINE_LOG.get());
            this.m_245724_((Block)WindsweptBlocks.PINE_WOOD.get());
            this.m_245724_((Block)WindsweptBlocks.PINE_PLANKS.get());
            this.m_246481_((Block)WindsweptBlocks.PINE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.PINE_STAIRS.get());
            this.m_245724_((Block)WindsweptBlocks.PINE_FENCE.get());
            this.m_245724_((Block)WindsweptBlocks.PINE_FENCE_GATE.get());
            this.m_245724_((Block)WindsweptBlocks.PINE_PRESSURE_PLATE.get());
            this.m_246481_((Block)WindsweptBlocks.PINE_DOOR.get(), x$0 -> this.m_247398_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.PINE_TRAPDOOR.get());
            this.m_245724_((Block)WindsweptBlocks.PINE_BUTTON.get());
            this.m_245724_((Block)((RegistryObject)WindsweptBlocks.PINE_SIGNS.getFirst()).get());
            this.m_245724_((Block)((RegistryObject)WindsweptBlocks.PINE_HANGING_SIGNS.getFirst()).get());
            this.m_245724_((Block)WindsweptBlocks.PINE_SAPLING.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_PINE_SAPLING.get());
            this.m_246481_((Block)WindsweptBlocks.PINE_BEEHIVE.get(), x$0 -> WindsweptBlockLoot.m_247247_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.PINE_LADDER.get());
            this.bookshelf((Block)WindsweptBlocks.PINE_BOOKSHELF.get());
            this.m_245644_((Block)WindsweptBlocks.CHISELED_PINE_BOOKSHELF.get());
            this.m_245724_((Block)WindsweptBlocks.PINE_BOARDS.get());
            this.m_245724_((Block)WindsweptBlocks.PINE_CHEST.get());
            this.m_245724_((Block)WindsweptBlocks.TRAPPED_PINE_CHEST.get());
            this.m_246481_((Block)WindsweptBlocks.PINE_LEAVES.get(), b -> this.m_246047_((Block)b, (Block)WindsweptBlocks.PINE_SAPLING.get(), new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f}));
            this.leafPile((Block)WindsweptBlocks.PINE_LEAF_PILE.get());
            this.m_246481_((Block)WindsweptBlocks.PINECONE.get(), this::createPineconeTable);
            this.m_246481_((Block)WindsweptBlocks.FAIRY_LIGHT.get(), this::createPineconeTable);
            this.m_246481_((Block)WindsweptBlocks.SOUL_FAIRY_LIGHT.get(), this::createPineconeTable);
            this.m_246481_((Block)WindsweptBlocks.CUPRIC_FAIRY_LIGHT.get(), this::createPineconeTable);
            this.m_246481_((Block)WindsweptBlocks.ENDER_FAIRY_LIGHT.get(), this::createPineconeTable);
            this.m_246481_((Block)WindsweptBlocks.NIGHT_FAIRY_LIGHT.get(), this::createPineconeTable);
            this.m_246481_((Block)WindsweptBlocks.REDSTONE_FAIRY_LIGHT.get(), this::createPineconeTable);
            this.m_245724_((Block)WindsweptBlocks.PINECONE_JAM_BLOCK.get());
            this.m_245724_((Block)WindsweptBlocks.PINECONE_BLOCK.get());
            this.m_245724_((Block)WindsweptBlocks.CARVED_PINECONE_BLOCK.get());
            this.m_245724_((Block)WindsweptBlocks.WILL_O_THE_WISP.get());
            this.m_245724_((Block)WindsweptBlocks.ELDER_WING.get());
            this.m_245724_((Block)WindsweptBlocks.ELDER_ORNAMENT.get());
            this.m_246481_((Block)WindsweptBlocks.DREAM_CATCHER.get(), b -> this.m_245178_((Block)b, (Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER));
            this.m_245724_((Block)WindsweptBlocks.PINECONE_SHINGLES.get());
            this.m_245724_((Block)WindsweptBlocks.PINECONE_SHINGLE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.PINECONE_SHINGLE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.WHITE_PINECONE_SHINGLES.get());
            this.m_245724_((Block)WindsweptBlocks.WHITE_PINECONE_SHINGLE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.WHITE_PINECONE_SHINGLE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.LIGHT_GRAY_PINECONE_SHINGLES.get());
            this.m_245724_((Block)WindsweptBlocks.LIGHT_GRAY_PINECONE_SHINGLE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.LIGHT_GRAY_PINECONE_SHINGLE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.GRAY_PINECONE_SHINGLES.get());
            this.m_245724_((Block)WindsweptBlocks.GRAY_PINECONE_SHINGLE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.GRAY_PINECONE_SHINGLE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.BLACK_PINECONE_SHINGLES.get());
            this.m_245724_((Block)WindsweptBlocks.BLACK_PINECONE_SHINGLE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.BLACK_PINECONE_SHINGLE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.BROWN_PINECONE_SHINGLES.get());
            this.m_245724_((Block)WindsweptBlocks.BROWN_PINECONE_SHINGLE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.BROWN_PINECONE_SHINGLE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.RED_PINECONE_SHINGLES.get());
            this.m_245724_((Block)WindsweptBlocks.RED_PINECONE_SHINGLE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.RED_PINECONE_SHINGLE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.ORANGE_PINECONE_SHINGLES.get());
            this.m_245724_((Block)WindsweptBlocks.ORANGE_PINECONE_SHINGLE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.ORANGE_PINECONE_SHINGLE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.YELLOW_PINECONE_SHINGLES.get());
            this.m_245724_((Block)WindsweptBlocks.YELLOW_PINECONE_SHINGLE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.YELLOW_PINECONE_SHINGLE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.LIME_PINECONE_SHINGLES.get());
            this.m_245724_((Block)WindsweptBlocks.LIME_PINECONE_SHINGLE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.LIME_PINECONE_SHINGLE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.GREEN_PINECONE_SHINGLES.get());
            this.m_245724_((Block)WindsweptBlocks.GREEN_PINECONE_SHINGLE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.GREEN_PINECONE_SHINGLE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.CYAN_PINECONE_SHINGLES.get());
            this.m_245724_((Block)WindsweptBlocks.CYAN_PINECONE_SHINGLE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.CYAN_PINECONE_SHINGLE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.LIGHT_BLUE_PINECONE_SHINGLES.get());
            this.m_245724_((Block)WindsweptBlocks.LIGHT_BLUE_PINECONE_SHINGLE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.LIGHT_BLUE_PINECONE_SHINGLE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.BLUE_PINECONE_SHINGLES.get());
            this.m_245724_((Block)WindsweptBlocks.BLUE_PINECONE_SHINGLE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.BLUE_PINECONE_SHINGLE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.PURPLE_PINECONE_SHINGLES.get());
            this.m_245724_((Block)WindsweptBlocks.PURPLE_PINECONE_SHINGLE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.PURPLE_PINECONE_SHINGLE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.MAGENTA_PINECONE_SHINGLES.get());
            this.m_245724_((Block)WindsweptBlocks.MAGENTA_PINECONE_SHINGLE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.MAGENTA_PINECONE_SHINGLE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.PINK_PINECONE_SHINGLES.get());
            this.m_245724_((Block)WindsweptBlocks.PINK_PINECONE_SHINGLE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.PINK_PINECONE_SHINGLE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.SNOW_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.SNOW_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.SNOW_BRICKS.get());
            this.m_245724_((Block)WindsweptBlocks.SNOW_BRICK_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.SNOW_BRICK_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.SNOW_BRICK_WALL.get());
            this.m_247577_((Block)WindsweptBlocks.SUSPICIOUS_SNOW.get(), WindsweptBlockLoot.m_246386_());
            this.m_245724_((Block)WindsweptBlocks.PACKED_ICE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.PACKED_ICE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.PACKED_ICE_BRICKS.get());
            this.m_245724_((Block)WindsweptBlocks.CHISELED_PACKED_ICE_BRICKS.get());
            this.m_245724_((Block)WindsweptBlocks.PACKED_ICE_BRICK_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.PACKED_ICE_BRICK_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.PACKED_ICE_BRICK_WALL.get());
            this.m_245724_((Block)WindsweptBlocks.BLUE_ICE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.BLUE_ICE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.BLUE_ICE_BRICKS.get());
            this.m_245724_((Block)WindsweptBlocks.CHISELED_BLUE_ICE_BRICKS.get());
            this.m_245724_((Block)WindsweptBlocks.BLUE_ICE_BRICK_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.BLUE_ICE_BRICK_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.BLUE_ICE_BRICK_WALL.get());
            this.m_245724_((Block)WindsweptBlocks.SHALE.get());
            this.m_245724_((Block)WindsweptBlocks.SHALE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.SHALE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.SHALE_WALL.get());
            this.m_245724_((Block)WindsweptBlocks.POLISHED_SHALE.get());
            this.m_245724_((Block)WindsweptBlocks.POLISHED_SHALE_STAIRS.get());
            this.m_245724_((Block)WindsweptBlocks.POLISHED_SHALE_WALL.get());
            this.m_246481_((Block)WindsweptBlocks.POLISHED_SHALE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.POLISHED_SHALE_BRICKS.get());
            this.m_245724_((Block)WindsweptBlocks.ICY_POLISHED_SHALE_BRICKS.get());
            this.m_245724_((Block)WindsweptBlocks.CHISELED_POLISHED_SHALE_BRICKS.get());
            this.m_245724_((Block)WindsweptBlocks.POLISHED_SHALE_BRICK_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.POLISHED_SHALE_BRICK_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.POLISHED_SHALE_BRICK_WALL.get());
            this.m_245724_((Block)WindsweptBlocks.CANDY_CANE_BLOCK.get());
            this.m_247577_((Block)WindsweptBlocks.GINGER.get(), (LootTable.Builder)this.m_246108_((ItemLike)WindsweptBlocks.GINGER.get(), (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.GINGER_ROOT.get())))).m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)WindsweptBlocks.GINGER.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)GingerCropBlock.AGE, 4))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.GINGER_ROOT.get())).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3))))));
            this.m_246481_((Block)WindsweptBlocks.GINGER_SOIL.get(), b -> this.dropTwoOthers((Block)b, (ItemLike)Items.f_42329_, (ItemLike)WindsweptItems.GINGER_ROOT.get()));
            this.m_245724_((Block)WindsweptBlocks.GINGERBREAD_BLOCK.get());
            this.m_245724_((Block)WindsweptBlocks.GLAZED_GINGERBREAD_BLOCK.get());
            this.m_245724_((Block)WindsweptBlocks.GINGERBREAD_BRICKS.get());
            this.m_245724_((Block)WindsweptBlocks.GINGERBREAD_BRICK_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.GINGERBREAD_BRICK_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.GINGERBREAD_BRICK_WALL.get());
            this.m_245724_((Block)WindsweptBlocks.GLAZED_GINGERBREAD_BRICKS.get());
            this.m_245724_((Block)WindsweptBlocks.GINGERBREAD_COOKIE_BLOCK.get());
            this.m_245724_((Block)WindsweptBlocks.GLAZED_GINGERBREAD_BRICK_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.GLAZED_GINGERBREAD_BRICK_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.GLAZED_GINGERBREAD_BRICK_WALL.get());
            this.m_245724_((Block)WindsweptBlocks.GINGER_ROOT_CRATE.get());
            this.m_246481_((Block)WindsweptBlocks.GINGERBREAD_DOOR.get(), x$0 -> this.m_247398_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.GINGERBREAD_TRAPDOOR.get());
            this.m_245724_((Block)WindsweptBlocks.FROSTBITER_TROPHY.get());
            this.m_247577_((Block)WindsweptBlocks.CHRISTMAS_PUDDING.get(), WindsweptBlockLoot.m_246386_());
            this.m_245724_((Block)WindsweptBlocks.HOLLY_WREATH.get());
            this.m_245724_((Block)WindsweptBlocks.PINECONE_WREATH.get());
            this.m_245724_((Block)WindsweptBlocks.VINE_WREATH.get());
            this.m_245724_((Block)WindsweptBlocks.CHERRY_WREATH.get());
            this.m_245724_((Block)WindsweptBlocks.ICE_SHEET.get());
            this.tallFlower((Block)WindsweptBlocks.LUPINE.get());
            this.tallFlower((Block)WindsweptBlocks.LIONS_TAIL.get());
            this.tallFlower((Block)WindsweptBlocks.RED_ROSE_BUSH.get());
            this.tallFlower((Block)WindsweptBlocks.BLUE_ROSE_BUSH.get());
            this.tallFlower((Block)WindsweptBlocks.WHITE_ROSE_BUSH.get());
            this.tallFlower((Block)WindsweptBlocks.YELLOW_ROSE_BUSH.get());
            this.m_246481_((Block)WindsweptBlocks.SNOWY_SPROUTS.get(), x$0 -> WindsweptBlockLoot.m_245929_((ItemLike)x$0));
            this.m_246481_((Block)WindsweptBlocks.GELISOL_GRASS.get(), x$0 -> WindsweptBlockLoot.m_245929_((ItemLike)x$0));
            this.m_246481_((Block)WindsweptBlocks.DRY_MOSSY_SPROUTS.get(), x$0 -> WindsweptBlockLoot.m_245929_((ItemLike)x$0));
            this.m_246481_((Block)WindsweptBlocks.MOSSY_SPROUTS.get(), x$0 -> WindsweptBlockLoot.m_245929_((ItemLike)x$0));
            this.m_245724_((Block)WindsweptBlocks.RED_ROSE.get());
            this.m_245724_((Block)WindsweptBlocks.BLUE_ROSE.get());
            this.m_245724_((Block)WindsweptBlocks.WHITE_ROSE.get());
            this.m_245724_((Block)WindsweptBlocks.YELLOW_ROSE.get());
            this.m_245724_((Block)WindsweptBlocks.FOXGLOVE.get());
            this.m_245724_((Block)WindsweptBlocks.BLUEBELLS.get());
            this.m_245724_((Block)WindsweptBlocks.SNOWDROP.get());
            this.m_245724_((Block)WindsweptBlocks.MOSS_CAMPION.get());
            this.m_246481_((Block)WindsweptBlocks.WILD_GINGER.get(), this::createWildGingerDrops);
            this.m_245724_((Block)WindsweptBlocks.NIGHTSHADE.get());
            this.m_246481_((Block)WindsweptBlocks.LAVENDER.get(), this::createLavenderTable);
            this.m_245724_((Block)WindsweptBlocks.MIMOSA.get());
            this.m_245724_((Block)WindsweptBlocks.FLOWERING_ACACIA_SAPLING.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_FLOWERING_ACACIA_SAPLING.get());
            this.m_246481_((Block)WindsweptBlocks.FLOWERING_ACACIA_LEAVES.get(), b -> this.m_246047_((Block)b, (Block)WindsweptBlocks.FLOWERING_ACACIA_SAPLING.get(), new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f}));
            this.leafPile((Block)WindsweptBlocks.FLOWERING_ACACIA_LEAF_PILE.get());
            this.m_246481_((Block)WindsweptBlocks.YELLOW_PETALS.get(), this::createPetalsTable);
            this.m_246535_((Block)WindsweptBlocks.POTTED_RED_ROSE.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_BLUE_ROSE.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_WHITE_ROSE.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_YELLOW_ROSE.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_FOXGLOVE.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_BLUEBELLS.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_SNOWDROP.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_MOSS_CAMPION.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_WILD_GINGER.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_NIGHTSHADE.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_SNOWY_SPROUTS.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_GELISOL_GRASS.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_DRY_MOSSY_SPROUTS.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_MOSSY_SPROUTS.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_LAVENDER.get());
            this.m_246535_((Block)WindsweptBlocks.POTTED_MIMOSA.get());
            this.m_245724_((Block)WindsweptBlocks.LAVENDER_BALE.get());
            this.m_245724_((Block)WindsweptBlocks.LAVENDER_THATCH.get());
            this.m_245724_((Block)WindsweptBlocks.LAVENDER_THATCH_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.LAVENDER_THATCH_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_246481_((Block)WindsweptBlocks.WILD_BERRY_BUSH.get(), b -> (LootTable.Builder)this.m_246108_((ItemLike)b, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)b).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SweetBerryBushBlock.f_57244_, 3))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.WILD_BERRIES.get()))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)))));
            this.m_245724_((Block)WindsweptBlocks.WILD_BERRY_BASKET.get());
            this.m_245724_((Block)WindsweptBlocks.ICICLES.get());
            this.m_245724_((Block)WindsweptBlocks.ICICLE_BLOCK.get());
            this.m_245724_((Block)WindsweptBlocks.CHISELED_ICICLE_BLOCK.get());
            this.m_246481_((Block)WindsweptBlocks.ICICLE_DOOR.get(), x$0 -> this.m_247398_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.ICICLE_TRAPDOOR.get());
            this.m_245724_((Block)WindsweptBlocks.ICICLE_BARS.get());
            this.m_245724_((Block)WindsweptBlocks.ICE_LANTERN.get());
            this.m_245724_((Block)WindsweptBlocks.ICE_CHAIN.get());
            this.m_245724_((Block)WindsweptBlocks.LUNALITE.get());
            this.m_245724_((Block)WindsweptBlocks.LUNALITE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.LUNALITE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.LUNALITE_WALL.get());
            this.m_245724_((Block)WindsweptBlocks.CUT_LUNALITE.get());
            this.m_245724_((Block)WindsweptBlocks.CUT_LUNALITE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.CUT_LUNALITE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.CUT_LUNALITE_WALL.get());
            this.m_245724_((Block)WindsweptBlocks.CUT_LUNALITE_BRICKS.get());
            this.m_245724_((Block)WindsweptBlocks.CHISELED_CUT_LUNALITE_BRICKS.get());
            this.m_245724_((Block)WindsweptBlocks.CUT_LUNALITE_BRICK_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.CUT_LUNALITE_BRICK_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.CUT_LUNALITE_BRICK_WALL.get());
            this.m_245724_((Block)WindsweptBlocks.SMOOTH_LUNALITE.get());
            this.m_245724_((Block)WindsweptBlocks.SMOOTH_LUNALITE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.SMOOTH_LUNALITE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.DRY_MOSS_CARPET.get());
            this.m_245724_((Block)WindsweptBlocks.DRY_MOSS_BLOCK.get());
            this.m_245724_((Block)WindsweptBlocks.DRY_MOSSY_COBBLESTONE.get());
            this.m_245724_((Block)WindsweptBlocks.DRY_MOSSY_COBBLESTONE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.DRY_MOSSY_COBBLESTONE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.DRY_MOSSY_COBBLESTONE_WALL.get());
            this.m_245724_((Block)WindsweptBlocks.DRY_MOSSY_STONE_BRICKS.get());
            this.m_245724_((Block)WindsweptBlocks.DRY_MOSSY_STONE_BRICK_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.DRY_MOSSY_STONE_BRICK_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.DRY_MOSSY_STONE_BRICK_WALL.get());
            this.m_245724_((Block)WindsweptBlocks.DRY_MOSSY_COBBLESTONE_BRICKS.get());
            this.m_245724_((Block)WindsweptBlocks.DRY_MOSSY_COBBLESTONE_BRICK_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.DRY_MOSSY_COBBLESTONE_BRICK_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.DRY_MOSSY_COBBLESTONE_BRICK_WALL.get());
            this.m_245724_((Block)WindsweptBlocks.DRY_MOSSY_COBBLESTONE_TILES.get());
            this.m_245724_((Block)WindsweptBlocks.DRY_MOSSY_COBBLESTONE_TILE_STAIRS.get());
            this.m_246481_((Block)WindsweptBlocks.DRY_MOSSY_COBBLESTONE_TILE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)WindsweptBlocks.DRY_MOSSY_COBBLESTONE_TILE_WALL.get());
            this.m_246481_((Block)WindsweptBlocks.GELISOL.get(), b -> this.m_245514_((Block)b, (ItemLike)Blocks.f_50493_));
            this.m_246481_((Block)WindsweptBlocks.GELISOL_PATH.get(), b -> this.m_245514_((Block)b, (ItemLike)Blocks.f_50493_));
            this.m_245724_((Block)WindsweptBlocks.FROZEN_FLESH_BLOCK.get());
        }

        private void bookshelf(Block block) {
            this.m_246481_(block, b -> this.m_245142_((Block)b, (ItemLike)Items.f_42517_, (NumberProvider)ConstantValue.m_165692_((float)3.0f)));
        }

        private void tallFlower(Block block) {
            this.m_246481_(block, b -> this.m_245178_((Block)b, (Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER));
        }

        private void leafPile(Block block) {
            this.m_246481_(block, b -> this.m_246235_((Block)b, MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.SHEARS))));
        }

        public Iterable<Block> getKnownBlocks() {
            return WindsweptLootTableProvider.getContent(ForgeRegistries.BLOCKS).collect(Collectors.toSet());
        }

        protected LootTable.Builder createWildGingerDrops(Block block) {
            return WindsweptBlockLoot.m_247184_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.GINGER_ROOT.get())))));
        }

        private LootTable.Builder dropTwoOthers(Block block, ItemLike other, ItemLike another) {
            return LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(f_243678_).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)))).m_79161_((LootPool.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(f_244217_).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)other)))).m_79161_((LootPool.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(f_244217_).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)another))));
        }

        private LootTable.Builder createPineconeTable(Block block) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, LootItem.m_79579_((ItemLike)block).m_230984_(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), i -> SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)i.intValue())).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)PineconeBlock.AMOUNT, i.intValue())))))));
        }

        private LootTable.Builder createPetalsTable(Block block) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, LootItem.m_79579_((ItemLike)block).m_230984_(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), i -> SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)i.intValue())).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)PinkPetalsBlock.f_271373_, i.intValue())))))));
        }

        private LootTable.Builder createLavenderTable(Block block) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, LootItem.m_79579_((ItemLike)block).m_230984_(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)), i -> SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)((float)i.intValue() + 1.0f))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)LavenderBlock.AGE, i.intValue())))))));
        }

        private static <V extends Comparable<V>> LootItemCondition.Builder stateCond(RegistryObject<? extends Block> block, Property<V> property, V v) {
            return LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)block.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67700_(property, v.toString()));
        }
    }
}

