/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.common.entity;

import com.rosemods.windswept.common.entity.ai.goal.FrostbiterEatGoal;
import com.rosemods.windswept.common.entity.ai.goal.FrostbiterShakeGoal;
import com.rosemods.windswept.core.registry.WindsweptEntityTypes;
import com.rosemods.windswept.core.registry.WindsweptItems;
import com.rosemods.windswept.core.registry.WindsweptParticleTypes;
import com.teamabnormals.blueprint.core.endimator.Endimatable;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class Frostbiter
extends TamableAnimal
implements Endimatable,
NeutralMob,
ItemSteerable,
Saddleable {
    private static final EntityDataAccessor<Boolean> LEFT_ANTLER = SynchedEntityData.m_135353_(Frostbiter.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RIGHT_ANTLER = SynchedEntityData.m_135353_(Frostbiter.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(Frostbiter.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BOOST_TIME = SynchedEntityData.m_135353_(Frostbiter.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(Frostbiter.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt ANGER_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    private static final Predicate<Entity> FROSTBITER_SHOULD_KB = e -> EntitySelector.f_20406_.test(e) && !e.m_20159_() && e.m_6084_() && e instanceof Monster;
    private final ItemBasedSteering steering;
    private UUID lastHurtBy;

    public Frostbiter(EntityType<? extends Frostbiter> type, Level level) {
        super(type, level);
        this.steering = new ItemBasedSteering(this.f_19804_, BOOST_TIME, SADDLED);
        this.m_7105_(false);
        this.setLeftAntler(true);
        this.setRightAntler(true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LEFT_ANTLER, (Object)true);
        this.f_19804_.m_135372_(RIGHT_ANTLER, (Object)true);
        this.f_19804_.m_135372_(SADDLED, (Object)false);
        this.f_19804_.m_135372_(BOOST_TIME, (Object)0);
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("LeftAntler", this.hasLeftAntler());
        compound.m_128379_("RightAntler", this.hasRightAntler());
        compound.m_128379_("Saddled", this.m_6254_());
        this.m_21678_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setLeftAntler(compound.m_128471_("LeftAntler"));
        this.setRightAntler(compound.m_128471_("RightAntler"));
        this.setSaddled(compound.m_128471_("Saddled"));
        this.m_147285_(this.m_9236_(), compound);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FrostbiterPanicGoal());
        this.f_21345_.m_25352_(2, (Goal)new FrostbiterMeleeAttackGoal());
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, (double)1.15f, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)WindsweptItems.HOLLY_BERRIES.get(), (ItemLike)WindsweptItems.HOLLY_BERRIES_ON_A_STICK.get()}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, (double)0.7f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new FrostbiterShakeGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new FrostbiterEatGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Frostbiter)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void m_8024_() {
        this.m_21666_((ServerLevel)this.m_9236_(), true);
        if (this.m_21660_()) {
            this.f_20889_ = this.f_19797_;
        }
        super.m_8024_();
    }

    public void setLeftAntler(boolean has) {
        this.f_19804_.m_135381_(LEFT_ANTLER, (Object)has);
    }

    public void setRightAntler(boolean has) {
        this.f_19804_.m_135381_(RIGHT_ANTLER, (Object)has);
    }

    public boolean hasLeftAntler() {
        return (Boolean)this.f_19804_.m_135370_(LEFT_ANTLER) != false && !this.m_6162_();
    }

    public boolean hasRightAntler() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT_ANTLER) != false && !this.m_6162_();
    }

    public boolean hasAntlers() {
        return ((Boolean)this.f_19804_.m_135370_(LEFT_ANTLER) != false || (Boolean)this.f_19804_.m_135370_(RIGHT_ANTLER) != false) && !this.m_6162_();
    }

    public void growRandomAntler() {
        if (!this.hasAntlers()) {
            if (this.f_19796_.m_188499_()) {
                this.setLeftAntler(true);
            } else {
                this.setRightAntler(true);
            }
        } else if (!this.hasRightAntler()) {
            this.setRightAntler(true);
        } else if (!this.hasLeftAntler()) {
            this.setLeftAntler(true);
        }
        this.spawnAntlerParticle();
    }

    public void dropRandomAntler() {
        if (this.hasAntlers()) {
            if (this.f_19796_.m_188499_()) {
                this.setLeftAntler(false);
            } else {
                this.setRightAntler(false);
            }
        } else if (this.hasRightAntler()) {
            this.setRightAntler(false);
        } else if (this.hasLeftAntler()) {
            this.setLeftAntler(false);
        }
        this.spawnItemFancy((Item)WindsweptItems.FROZEN_BRANCH.get(), this.m_20182_().m_82549_(this.m_20154_().m_82490_(1.5)).m_231075_(Direction.UP, (double)(this.m_20192_() + 0.75f)), SoundEvents.f_215698_);
    }

    public void spawnAntlerParticle() {
        Vec3 lookAngle = this.m_20154_();
        for (int i = 0; i < 5; ++i) {
            Vec3 vector = new Vec3(this.m_20208_(0.25), this.m_20187_(), this.m_20262_(0.25)).m_82549_(lookAngle);
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level1 = (ServerLevel)level;
            level1.m_8767_((ParticleOptions)((SimpleParticleType)WindsweptParticleTypes.FROST_LEAF.get()), vector.f_82479_, vector.f_82480_, vector.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private boolean spawnItemFancy(Item item, Vec3 spawnPos, SoundEvent sound) {
        ItemEntity entity = new ItemEntity(this.m_9236_(), spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, new ItemStack((ItemLike)item));
        if (this.m_9236_().m_7967_((Entity)entity)) {
            entity.m_20256_(entity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f), (double)(this.f_19796_.m_188501_() * 0.1f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f)));
            this.m_216990_(sound);
            return true;
        }
        return false;
    }

    public boolean m_7327_(Entity entity) {
        if (super.m_7327_(entity) && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!livingEntity.m_9236_().f_46443_) {
                livingEntity.m_146917_(livingEntity.m_146888_() + 100);
                return true;
            }
        }
        return false;
    }

    protected void m_5806_(BlockPos pos) {
        FrostWalkerEnchantment.m_45018_((LivingEntity)this, (Level)this.m_9236_(), (BlockPos)pos, (int)0);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.m_6254_() && !this.m_20160_() && !player.m_36341_()) {
            if (stack.m_204117_(Tags.Items.SHEARS)) {
                this.dropSaddle();
                this.m_216990_(SoundEvents.f_12480_);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            } else if (!this.m_9236_().f_46443_) {
                player.m_20329_((Entity)this);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (stack.m_150930_(Items.f_42446_) && !this.m_6162_()) {
            player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)Items.f_42455_.m_7968_()));
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (stack.m_150930_((Item)WindsweptItems.HOLLY_BERRIES.get())) {
            if (!this.m_21824_()) {
                if (this.f_19796_.m_188503_(4) == 0) {
                    this.m_7105_(true);
                    this.m_21816_(player.m_20148_());
                    this.m_142075_(player, hand, stack);
                    this.f_21344_.m_26573_();
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_142075_(player, hand, stack);
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7866_(stack), this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
                return InteractionResult.SUCCESS;
            }
            if (this.m_5957_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7866_(stack), this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
            }
        }
        return super.m_6071_(player, hand);
    }

    protected SoundEvent m_7515_() {
        return this.m_6162_() ? SoundEvents.f_12281_ : SoundEvents.f_12280_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12283_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12282_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12284_, 0.15f, 1.0f);
    }

    public float m_6100_() {
        return this.m_6162_() ? 1.4f : 0.4f;
    }

    protected float m_6121_() {
        return this.m_6162_() ? 0.8f : 1.0f;
    }

    public boolean m_6573_(Player player) {
        return true;
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        Frostbiter biter = (Frostbiter)((EntityType)WindsweptEntityTypes.FROSTBITER.get()).m_20615_((Level)level);
        UUID uuid = this.m_21805_();
        if (uuid != null && biter != null) {
            biter.m_21816_(uuid);
            biter.m_7105_(true);
        }
        return biter;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_((Item)WindsweptItems.HOLLY_BERRIES.get());
    }

    protected float m_6431_(Pose pos, EntityDimensions dimensions) {
        return this.m_6162_() ? dimensions.f_20378_ * 0.95f : 1.3f;
    }

    public SoundEvent m_7866_(ItemStack p_21202_) {
        return SoundEvents.f_12096_;
    }

    public static AttributeSupplier.Builder createFrostbiterAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, (double)0.24f).m_22268_(Attributes.f_22282_, (double)1.2f);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(ANGER_TIME, (Object)time);
    }

    public UUID m_6120_() {
        return this.lastHurtBy;
    }

    public void m_6925_(UUID target) {
        this.lastHurtBy = target;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_RANGE.m_214085_(this.f_19796_));
    }

    public LivingEntity m_6688_() {
        Player player;
        Entity entity = this.m_146895_();
        return entity instanceof Player && this.canBeControlledBy(player = (Player)entity) ? player : null;
    }

    private boolean canBeControlledBy(Player player) {
        return this.m_6254_() && (player.m_21205_().m_150930_((Item)WindsweptItems.HOLLY_BERRIES_ON_A_STICK.get()) || player.m_21206_().m_150930_((Item)WindsweptItems.HOLLY_BERRIES_ON_A_STICK.get()));
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.m_6254_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
    }

    public void m_8119_() {
        if (this.m_9236_().m_46467_() % 5L == 1L && this.m_217005_() && this.m_6084_()) {
            for (LivingEntity entity : this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(1.6), FROSTBITER_SHOULD_KB)) {
                entity.m_146917_(entity.m_146888_() + 65);
                Vec3 deltaPos = entity.m_20182_().m_82546_(this.m_20182_()).m_193103_(Direction.Axis.Y, 0.0).m_82541_().m_82490_(1.5 + this.f_19796_.m_188500_() / 2.0).m_82490_(this.m_21133_(Attributes.f_22282_));
                entity.m_147240_(deltaPos.m_82553_(), -deltaPos.f_82479_, -deltaPos.f_82481_);
                entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_) / 2.0f);
                this.m_5496_(SoundEvents.f_144170_, 2.0f, 1.0f);
            }
        }
        super.m_8119_();
    }

    public boolean m_6746_() {
        return this.steering.m_217032_(this.f_19796_);
    }

    protected Vec3 m_274312_(Player player, Vec3 vec3) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        this.m_19915_(player.m_146908_(), player.m_146909_() * 0.5f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        this.steering.m_274606_();
    }

    public boolean m_6741_() {
        return this.m_21824_() && !this.m_6162_();
    }

    public void m_5853_(SoundSource sound) {
        this.setSaddled(true);
        if (sound != null) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12034_, sound, 0.5f, 1.0f);
        }
    }

    protected float m_245547_(Player player) {
        return (float)this.m_21133_(Attributes.f_22279_) * 0.6f;
    }

    private void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(SADDLED, (Object)saddled);
    }

    public boolean m_6254_() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    public double m_6048_() {
        return super.m_6048_() * 1.25;
    }

    protected void dropSaddle() {
        super.m_5907_();
        this.setSaddled(false);
        this.spawnItemFancy(Items.f_42450_, this.m_20182_().m_231075_(Direction.UP, 2.0), SoundEvents.f_12480_);
    }

    public static boolean checkFrostbiterSpawnRules(EntityType<Frostbiter> frostbiter, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_204166_(pos).m_203656_(BiomeTags.f_215813_) ? Frostbiter.m_186209_((BlockAndTintGetter)level, (BlockPos)pos) && level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_215826_) : Frostbiter.m_218104_(frostbiter, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance diff, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        return super.m_6518_(level, diff, spawnType, (SpawnGroupData)(spawnGroupData != null ? spawnGroupData : new AgeableMob.AgeableMobGroupData(1.0f)), tag);
    }

    public class FrostbiterPanicGoal
    extends PanicGoal {
        public FrostbiterPanicGoal() {
            super((PathfinderMob)Frostbiter.this, 1.35);
        }

        protected boolean m_202729_() {
            return this.f_25684_.m_6162_() && super.m_202729_();
        }
    }

    public class FrostbiterMeleeAttackGoal
    extends MeleeAttackGoal {
        public FrostbiterMeleeAttackGoal() {
            super((PathfinderMob)Frostbiter.this, (double)1.2f, false);
        }

        public boolean m_8036_() {
            return !this.f_25540_.m_6162_() && super.m_8036_();
        }
    }
}

