/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.common.entity;

import com.rosemods.windswept.core.other.WindsweptConstants;
import com.rosemods.windswept.core.other.tags.WindsweptBiomeTags;
import com.rosemods.windswept.core.registry.WindsweptBlocks;
import com.rosemods.windswept.core.registry.WindsweptEnchantments;
import com.rosemods.windswept.core.registry.WindsweptItems;
import com.rosemods.windswept.core.registry.WindsweptSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;

public class Chilled
extends Zombie {
    public Chilled(EntityType<? extends Zombie> type, Level level) {
        super(type, level);
    }

    protected ItemStack m_5728_() {
        return ItemStack.f_41583_;
    }

    public boolean m_142079_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)WindsweptSounds.CHILLED_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)WindsweptSounds.CHILLED_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)WindsweptSounds.CHILLED_DEATH.get();
    }

    protected SoundEvent m_7660_() {
        return SoundEvents.f_12047_;
    }

    public boolean m_7327_(Entity entity) {
        if (super.m_7327_(entity) && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!livingEntity.m_9236_().f_46443_) {
                livingEntity.m_146917_(livingEntity.m_146888_() + 100);
                return true;
            }
        }
        return false;
    }

    protected void m_213945_(RandomSource rand, DifficultyInstance difficulty) {
        float chance;
        float f = chance = this.m_9236_().m_46791_() == Difficulty.HARD ? 0.5f : 0.33f;
        if (rand.m_188501_() < chance) {
            this.m_8061_(EquipmentSlot.HEAD, Items.f_42407_.m_7968_());
        }
        this.cncCompat(rand);
        if (rand.m_188501_() < 0.075f) {
            this.m_8061_(EquipmentSlot.OFFHAND, ((Item)WindsweptItems.CANDY_CANE.get()).m_7968_());
            this.f_21348_[EquipmentSlot.OFFHAND.m_20749_()] = 1.0f;
        }
        if (rand.m_188501_() < chance) {
            boolean snow = rand.m_188499_();
            this.m_8061_(EquipmentSlot.FEET, snow ? ((Item)WindsweptItems.SNOW_BOOTS.get()).m_7968_() : Items.f_42463_.m_7968_());
            if (snow) {
                this.f_21348_[EquipmentSlot.FEET.m_20749_()] = 0.5f;
            }
        }
        if (rand.m_188501_() < 0.1f && this.m_9236_().m_204166_(this.m_20183_()).m_203656_(WindsweptBiomeTags.IS_PINE_BARRENS)) {
            this.m_8061_(EquipmentSlot.HEAD, ((Block)WindsweptBlocks.CARVED_PINECONE_BLOCK.get()).m_5456_().m_7968_());
            this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = 0.5f;
        }
    }

    public void cncCompat(RandomSource random) {
        if (ModList.get().isLoaded("caverns_and_chasms")) {
            if (random.m_188501_() < 0.075f) {
                this.m_8061_(EquipmentSlot.MAINHAND, Chilled.randomDurability(random, WindsweptConstants.getItem("caverns_and_chasms", random.m_188499_() ? "silver_sword" : "silver_shovel")));
            } else if (random.m_188501_() < 0.05f) {
                Item axe = WindsweptConstants.getItem("caverns_and_chasms", "silver_axe");
                this.m_8061_(EquipmentSlot.MAINHAND, Chilled.randomDurability(random, axe));
                this.m_8061_(EquipmentSlot.OFFHAND, Chilled.randomDurability(random, axe));
            }
            if (random.m_188501_() < 0.05f) {
                this.m_8061_(EquipmentSlot.HEAD, Chilled.randomDurability(random, WindsweptConstants.getItem("caverns_and_chasms", "silver_helmet")));
            }
            if (random.m_188501_() < 0.05f) {
                this.m_8061_(EquipmentSlot.CHEST, Chilled.randomDurability(random, WindsweptConstants.getItem("caverns_and_chasms", "silver_chestplate")));
            }
            if (random.m_188501_() < 0.05f) {
                this.m_8061_(EquipmentSlot.LEGS, Chilled.randomDurability(random, WindsweptConstants.getItem("caverns_and_chasms", "silver_leggings")));
            }
            if (random.m_188501_() < 0.05f) {
                this.m_8061_(EquipmentSlot.FEET, Chilled.randomDurability(random, WindsweptConstants.getItem("caverns_and_chasms", "silver_boots")));
            }
        }
    }

    private static ItemStack randomDurability(RandomSource random, Item item) {
        ItemStack stack = item.m_7968_();
        stack.m_41721_(random.m_216339_(1, stack.m_41776_()));
        return stack;
    }

    protected void m_217051_(RandomSource rand, float difficulty, EquipmentSlot slot) {
        ItemStack stack = this.m_6844_(slot);
        if (!stack.m_41619_() && this.f_19796_.m_188501_() < 0.5f * difficulty && slot == EquipmentSlot.FEET) {
            stack.m_41663_((Enchantment)WindsweptEnchantments.SLIPPING_CURSE.get(), 0);
        } else {
            super.m_217051_(rand, difficulty, slot);
        }
    }

    protected void m_7595_() {
        this.m_34310_(EntityType.f_20501_);
        if (!this.m_20067_()) {
            this.m_9236_().m_5898_(null, 1041, this.m_20183_(), 0);
        }
    }

    public static AttributeSupplier.Builder createChilledAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22278_, 0.5).m_22266_(Attributes.f_22287_);
    }
}

