/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.common.block_entity;

import com.rosemods.windswept.common.block.WillOTheWispBlock;
import com.rosemods.windswept.core.registry.WindsweptBlockEntities;
import com.rosemods.windswept.core.registry.WindsweptBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class WillOTheWispBlockEntity
extends BlockEntity {
    public WillOTheWispBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)WindsweptBlockEntities.WILL_O_THE_WISP.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WillOTheWispBlockEntity blockEntity) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == direction || !level.m_8055_(pos.m_121945_(direction)).m_60795_()) continue;
            for (Player player : level.m_45976_(Player.class, WillOTheWispBlockEntity.expandTowards(new AABB(pos.m_121945_(direction)), direction, 6.0))) {
                if (player.m_6350_() != direction) continue;
                WillOTheWispBlockEntity.turn(level, pos, state, direction, player);
                return;
            }
        }
    }

    private static void turn(Level level, BlockPos pos, BlockState state, Direction direction, Player player) {
        if (state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) != direction) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)WillOTheWispBlock.f_54117_, (Comparable)direction), 2);
        }
        int distance = Math.min(Math.abs(pos.m_123304_(direction.m_122434_()) - player.m_20183_().m_123304_(direction.m_122434_())), 3);
        AABB aabb = WillOTheWispBlockEntity.expandTowards(new AABB(pos.m_5484_(direction.m_122424_(), 3)).m_82400_(2.0), direction, distance);
        BlockPos.m_121921_((AABB)aabb).forEach(blockPos -> {
            BlockState blockState = level.m_8055_(blockPos);
            if (blockState.m_60713_((Block)WindsweptBlocks.WILL_O_THE_WISP.get()) && blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) != direction && level.m_8055_(blockPos.m_121945_(direction)).m_60795_()) {
                level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction));
            }
        });
    }

    private static AABB expandTowards(AABB aabb, Direction direction, double amount) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> aabb.m_82363_(0.0, amount, 0.0);
            case Direction.DOWN -> aabb.m_82363_(0.0, -amount, 0.0);
            case Direction.NORTH -> aabb.m_82363_(0.0, 0.0, -amount);
            case Direction.SOUTH -> aabb.m_82363_(0.0, 0.0, amount);
            case Direction.EAST -> aabb.m_82363_(amount, 0.0, 0.0);
            case Direction.WEST -> aabb.m_82363_(-amount, 0.0, 0.0);
        };
    }
}

