/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.util;

import dev.hexnowloading.dungeonnowloading.registry.DNLGameEvents;
import dev.hexnowloading.dungeonnowloading.util.event_managers.BlockDestructionManager;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DNLLevelUtil {
    private static Set<SoundType> pendingBlockBreakSounds = null;

    public static void beginMultiDestroySoundPending() {
        pendingBlockBreakSounds = new HashSet<SoundType>();
    }

    public static boolean destroyBlockMulti(Level level, BlockPos pos, boolean dropBlock, @Nullable Entity entity, int flags) {
        BlockDestructionManager.reset();
        level.m_220407_(DNLGameEvents.BLOCK_DESTROY_EARLY.get(), pos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)level.m_8055_(pos)));
        if (BlockDestructionManager.shouldCancel()) {
            return false;
        }
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_60795_()) {
            return false;
        }
        FluidState fluidState = level.m_6425_(pos);
        if (dropBlock) {
            BlockEntity blockEntity = blockState.m_155947_() ? level.m_7702_(pos) : null;
            Block.m_49881_((BlockState)blockState, (Level)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)entity, (ItemStack)ItemStack.f_41583_);
        }
        if (pendingBlockBreakSounds != null) {
            pendingBlockBreakSounds.add(blockState.m_60827_());
            DNLLevelUtil.spawnDestroyParticles(level, pos, blockState);
        } else {
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)blockState));
        }
        boolean success = level.m_6933_(pos, fluidState.m_76188_(), 3, flags);
        if (success) {
            level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)blockState));
        }
        return success;
    }

    public static void endMultiDestroySoundPending(Level level, @Nullable Entity soundSourceEntity) {
        if (pendingBlockBreakSounds != null) {
            for (SoundType soundType : pendingBlockBreakSounds) {
                DNLLevelUtil.playBreakSound(level, soundSourceEntity, soundType);
            }
            pendingBlockBreakSounds = null;
        }
    }

    public static void spawnDestroyParticles(Level level, BlockPos blockPos, BlockState blockState) {
        if (blockState.m_60795_() || !blockState.m_245147_()) {
            return;
        }
        VoxelShape shape = blockState.m_60808_((BlockGetter)level, blockPos);
        shape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double sizeX = Math.min(1.0, maxX - minX);
            double sizeY = Math.min(1.0, maxY - minY);
            double sizeZ = Math.min(1.0, maxZ - minZ);
            int stepsX = Math.max(2, Mth.m_14165_((double)(sizeX / 0.25)));
            int stepsY = Math.max(2, Mth.m_14165_((double)(sizeY / 0.25)));
            int stepsZ = Math.max(2, Mth.m_14165_((double)(sizeZ / 0.25)));
            for (int ix = 0; ix < stepsX; ++ix) {
                for (int iy = 0; iy < stepsY; ++iy) {
                    for (int iz = 0; iz < stepsZ; ++iz) {
                        double px = ((double)ix + 0.5) / (double)stepsX;
                        double py = ((double)iy + 0.5) / (double)stepsY;
                        double pz = ((double)iz + 0.5) / (double)stepsZ;
                        double worldX = minX + px * sizeX;
                        double worldY = minY + py * sizeY;
                        double worldZ = minZ + pz * sizeZ;
                        if (!(level instanceof ServerLevel)) continue;
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), (double)blockPos.m_123341_() + worldX, (double)blockPos.m_123342_() + worldY, (double)blockPos.m_123343_() + worldZ, 1, px - 0.5, py - 0.5, pz - 0.5, 0.0);
                    }
                }
            }
        });
    }

    public static void playBreakSound(Level level, @Nullable Entity entity, SoundType soundType) {
        if (entity != null) {
            level.m_245803_(entity, entity.m_20183_(), soundType.m_56775_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
        }
    }
}

