/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.supporter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import dev.hexnowloading.dungeonnowloading.block.entity.PlayerStatueBlockEntity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.RandomSource;

public final class PatronRegistry {
    public static final String DEFAULT_URL = "https://raw.githubusercontent.com/hexnowloading/DungeonNowLoadingSupporterList/refs/heads/main/statues.json";
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private static volatile Map<String, Campaign> DATA = new HashMap<String, Campaign>();

    public static void initOrReload(MinecraftServer server) {
        PatronRegistry.initOrReload(server, DEFAULT_URL);
    }

    public static void initOrReload(MinecraftServer server, String remoteUrl) {
        try {
            Map<String, Campaign> fresh = PatronRegistry.fetch(remoteUrl);
            if (!fresh.isEmpty()) {
                PatronRegistry.enrichNamesFromProfileCache(server, fresh);
                DATA = fresh;
                PatronRegistry.cacheToDisk(server, fresh);
                return;
            }
        }
        catch (Exception fresh) {
            // empty catch block
        }
        Map<String, Campaign> cached = PatronRegistry.readCache(server);
        if (!cached.isEmpty()) {
            PatronRegistry.enrichNamesFromProfileCache(server, cached);
            DATA = cached;
        }
    }

    @Nullable
    public static Patron pickPatron(String campaignId, RandomSource rand) {
        Campaign c = DATA.get(campaignId);
        if (c == null || c.patrons == null || c.patrons.isEmpty()) {
            return null;
        }
        return c.patrons.get(rand.m_188503_(c.patrons.size()));
    }

    public static PlayerStatueBlockEntity.NotchTier tierFor(Patron p) {
        int m;
        if (p == null) {
            return PlayerStatueBlockEntity.NotchTier.NONE;
        }
        if (p.tier != null) {
            try {
                return PlayerStatueBlockEntity.NotchTier.valueOf(p.tier.toUpperCase(Locale.ROOT));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((m = Math.max(0, p.months)) >= 4) {
            return PlayerStatueBlockEntity.NotchTier.DIAMOND;
        }
        if (m == 3) {
            return PlayerStatueBlockEntity.NotchTier.GOLD;
        }
        if (m == 2) {
            return PlayerStatueBlockEntity.NotchTier.IRON;
        }
        if (m == 1) {
            return PlayerStatueBlockEntity.NotchTier.COPPER;
        }
        return PlayerStatueBlockEntity.NotchTier.NONE;
    }

    private static Map<String, Campaign> fetch(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setConnectTimeout(7000);
        conn.setReadTimeout(7000);
        conn.setRequestProperty("User-Agent", "DNL-PatronFetcher");
        try (InputStream in = conn.getInputStream();){
            Map<String, Campaign> map;
            try (InputStreamReader r = new InputStreamReader(in, StandardCharsets.UTF_8);){
                Root root = (Root)GSON.fromJson((Reader)r, Root.class);
                map = root != null && root.campaigns != null ? root.campaigns : Map.of();
            }
            return map;
        }
    }

    private static void cacheToDisk(MinecraftServer server, Map<String, Campaign> data) {
        try {
            File f = PatronRegistry.getCacheFile(server);
            f.getParentFile().mkdirs();
            try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8);){
                Root r = new Root();
                r.campaigns = data;
                GSON.toJson((Object)r, (Appendable)w);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Map<String, Campaign> readCache(MinecraftServer server) {
        Map<String, Campaign> map;
        block9: {
            File f = PatronRegistry.getCacheFile(server);
            if (!f.exists()) {
                return Map.of();
            }
            BufferedReader r = Files.newBufferedReader(f.toPath(), StandardCharsets.UTF_8);
            try {
                Root root = (Root)GSON.fromJson((Reader)r, Root.class);
                Map<String, Campaign> map2 = map = root != null && root.campaigns != null ? root.campaigns : Map.of();
                if (r == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            ((Reader)r).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return Map.of();
                }
            }
            ((Reader)r).close();
        }
        return map;
    }

    private static File getCacheFile(MinecraftServer server) {
        return server.m_129971_("config/dnl/patrons.json");
    }

    private static void enrichNamesFromProfileCache(MinecraftServer server, Map<String, Campaign> data) {
        if (server == null || data == null) {
            return;
        }
        GameProfileCache cache = server.m_129927_();
        if (cache == null) {
            return;
        }
        for (Map.Entry<String, Campaign> entry : data.entrySet()) {
            Campaign c = entry.getValue();
            if (c == null || c.patrons == null) continue;
            for (Patron p : c.patrons) {
                if (p == null || p.uuid == null || p.name != null && !p.name.isBlank()) continue;
                cache.m_11002_(p.uuid).ifPresent(gp -> {
                    if (gp.getName() != null && !gp.getName().isBlank()) {
                        p.name = gp.getName();
                    }
                });
            }
        }
    }

    public static final class Campaign {
        public List<Patron> patrons = new ArrayList<Patron>();
    }

    public static final class Patron {
        public UUID uuid;
        @SerializedName(value="name", alternate={"username"})
        @Nullable
        public String name;
        public int months;
        public String tier;
    }

    public static final class Root {
        public String lastUpdated;
        public Map<String, Campaign> campaigns = new HashMap<String, Campaign>();
    }
}

