/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.particle;

import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class MendstonePickaxeParticleLogic {
    private static final int RADIUS = 10;
    private static final int INTERVAL_TICKS = 10;
    private static final int MAX_BLOCKS_PER_SCAN = 100;
    private static final int PARTICLES_PER_FACE = 1;

    public static void handleClientTick(Minecraft mc) {
        if (mc == null || mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        if (!mc.f_91074_.m_21205_().m_150930_(DNLItems.MENDSTONE_PICKAXE.get())) {
            return;
        }
        if (mc.f_91073_.m_46467_() % 10L != 0L) {
            return;
        }
        BlockPos playerPos = mc.f_91074_.m_20183_();
        List<BlockPos> targets = MendstonePickaxeParticleLogic.findNearbyDiamondOres((Level)mc.f_91073_, playerPos, 10, 100);
        for (BlockPos pos : targets) {
            MendstonePickaxeParticleLogic.spawnParticlesOnExposedFaces((Level)mc.f_91073_, pos, 1);
        }
    }

    private static List<BlockPos> findNearbyDiamondOres(Level level, BlockPos center, int radius, int limit) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        int r2 = radius * radius;
        for (int dx = -radius; dx <= radius && list.size() < limit; ++dx) {
            for (int dy = -radius; dy <= radius && list.size() < limit; ++dy) {
                for (int dz = -radius; dz <= radius && list.size() < limit; ++dz) {
                    BlockPos pos;
                    BlockState state;
                    if (dx * dx + dy * dy + dz * dz > r2 || !(state = level.m_8055_(pos = center.m_7918_(dx, dy, dz))).m_60713_(Blocks.f_50089_) && !state.m_60713_(Blocks.f_152474_)) continue;
                    list.add(pos);
                }
            }
        }
        return list;
    }

    private static void spawnParticlesOnExposedFaces(Level level, BlockPos pos, int perFace) {
        BlockState state = level.m_8055_(pos);
        if (!state.m_60713_(Blocks.f_50089_) && !state.m_60713_(Blocks.f_152474_)) {
            return;
        }
        for (Direction dir : Direction.values()) {
            if (!MendstonePickaxeParticleLogic.isFaceExposed(level, pos, dir)) continue;
            for (int i = 0; i < perFace; ++i) {
                MendstonePickaxeParticleLogic.spawnFaceParticle(level, pos, dir);
            }
        }
    }

    private static boolean isFaceExposed(Level level, BlockPos pos, Direction face) {
        BlockPos adjacent = pos.m_121945_(face);
        BlockState neighbor = level.m_8055_(adjacent);
        return neighbor.m_60795_() || !neighbor.m_60804_((BlockGetter)level, adjacent);
    }

    private static void spawnFaceParticle(Level level, BlockPos pos, Direction face) {
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        double u = level.f_46441_.m_188500_();
        double v = level.f_46441_.m_188500_();
        double OUT = 0.02;
        double px = 0.0;
        double py = 0.0;
        double pz = 0.0;
        switch (face) {
            case UP: {
                px = x + u;
                py = y + 1.0 + 0.02;
                pz = z + v;
                break;
            }
            case DOWN: {
                px = x + u;
                py = y - 0.02;
                pz = z + v;
                break;
            }
            case NORTH: {
                px = x + u;
                py = y + v;
                pz = z - 0.02;
                break;
            }
            case SOUTH: {
                px = x + u;
                py = y + v;
                pz = z + 1.0 + 0.02;
                break;
            }
            case WEST: {
                px = x - 0.02;
                py = y + u;
                pz = z + v;
                break;
            }
            case EAST: {
                px = x + 1.0 + 0.02;
                py = y + u;
                pz = z + v;
            }
        }
        level.m_7106_((ParticleOptions)DNLParticleTypes.MENDING_RUNE_SHORT_PARTICLE.get(), px, py, pz, 0.0, 0.0, 0.0);
    }
}

