/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MendingRuneParticle
extends TextureSheetParticle {
    private SpriteSet spriteSet;
    private int runeVarient;
    private double xi;
    private double yi;
    private double zi;
    private final float spinAcceleration;
    private float rotSpeed;
    private final float initialQuadSize;
    private Vec3 initialVelocity;
    private final int REVERSE_DURATION = 50;
    private final int GROWTH_DURATION = 5;

    protected MendingRuneParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.f_107663_ *= 0.5f;
        this.f_107219_ = true;
        this.f_107230_ = 0.0f;
        this.spriteSet = spriteSet;
        this.f_172258_ = 0.95f;
        this.f_107225_ = 100;
        this.runeVarient = level.m_213780_().m_216339_(0, 7);
        this.m_108337_(spriteSet.m_5819_(this.runeVarient, 7));
        this.xi = xSpeed;
        this.yi = ySpeed;
        this.zi = zSpeed;
        this.rotSpeed = (float)Math.toRadians(this.f_107223_.m_188499_() ? -30.0 : 30.0);
        this.spinAcceleration = (float)Math.toRadians(this.f_107223_.m_188499_() ? -5.0 : 5.0);
        this.initialQuadSize = this.f_107663_;
        this.f_107663_ = 0.0f;
        this.initialVelocity = new Vec3(-xSpeed, -ySpeed, -zSpeed);
        this.f_107215_ = this.initialVelocity.f_82479_ * 0.2;
        this.f_107216_ = this.initialVelocity.f_82480_ * 0.2;
        this.f_107217_ = this.initialVelocity.f_82481_ * 0.2;
    }

    public void m_5989_() {
        float progress;
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_ < 5) {
            progress = (float)this.f_107224_ / 5.0f;
            this.f_107663_ = this.initialQuadSize * progress * progress;
        } else {
            float scaleFactor = 1.0f + 0.2f * (float)Math.sin((double)this.f_107224_ * 0.2);
            this.f_107663_ = this.initialQuadSize * scaleFactor;
        }
        this.rotSpeed += this.spinAcceleration / 20.0f;
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += this.rotSpeed / 20.0f;
        this.m_108337_(this.spriteSet.m_5819_(this.runeVarient, 7));
        this.m_107271_(1.0f);
        if (this.f_107224_++ < this.f_107225_) {
            boolean onCieling;
            if (this.f_107224_ < 50) {
                progress = (float)this.f_107224_ / 50.0f;
                this.f_107215_ = this.lerp(progress, this.initialVelocity.f_82479_, 0.0);
                this.f_107216_ = this.lerp(progress, this.initialVelocity.f_82480_, 0.0);
                this.f_107217_ = this.lerp(progress, this.initialVelocity.f_82481_, 0.0);
            } else {
                this.f_107215_ += this.xi;
                this.f_107216_ += this.yi;
                this.f_107217_ += this.zi;
            }
            double xt = this.f_107215_;
            double yt = this.f_107216_;
            double zt = this.f_107217_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            if (this.f_107218_) {
                this.m_107274_();
                return;
            }
            boolean onNorthWall = zt != this.f_107217_ && zt < 0.0;
            boolean onSouthWall = zt != this.f_107217_ && zt > 0.0;
            boolean onWestWall = xt != this.f_107215_ && xt < 0.0;
            boolean onEastWall = xt != this.f_107215_ && xt > 0.0;
            boolean bl = onCieling = yt != this.f_107216_ && yt > 0.0;
            if (onNorthWall || onEastWall || onSouthWall || onWestWall || onCieling) {
                this.m_107274_();
            }
        } else {
            this.m_107274_();
        }
    }

    private double lerp(float t, double start, double end) {
        return start + (double)t * (end - start);
    }

    public int m_6355_(float $$0) {
        return 240;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Factory(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            MendingRuneParticle particle = new MendingRuneParticle(clientLevel, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites);
            particle.m_108337_(this.sprites.m_5819_(0, 1));
            return particle;
        }
    }
}

