/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.network.packets;

import dev.hexnowloading.dungeonnowloading.network.ClientUtil;
import dev.hexnowloading.dungeonnowloading.network.DNLPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class S2CStructureDetectionPacket
implements DNLPacket {
    private final boolean insideStructure;
    private final int playerId;
    private static final Map<UUID, Boolean> playerStructureStatus = new HashMap<UUID, Boolean>();

    public S2CStructureDetectionPacket(boolean insideStructure, int playerId) {
        this.insideStructure = insideStructure;
        this.playerId = playerId;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.insideStructure);
        buffer.writeInt(this.playerId);
    }

    public static S2CStructureDetectionPacket decode(FriendlyByteBuf buffer) {
        return new S2CStructureDetectionPacket(buffer.readBoolean(), buffer.readInt());
    }

    @Override
    public void handle(@Nullable ServerPlayer sender) {
        if (sender != null) {
            return;
        }
        if (ClientUtil.onClient()) {
            if (ClientUtil.getClientLevel() == null) {
                return;
            }
            Entity entity = ClientUtil.getClientLevel().m_6815_(this.playerId);
            if (entity != null) {
                playerStructureStatus.put(entity.m_20148_(), this.insideStructure);
            }
        }
    }

    public static boolean isClientInStructure() {
        if (ClientUtil.getClientPlayer() == null) {
            return false;
        }
        UUID clientUUID = ClientUtil.getClientPlayer().m_20148_();
        return playerStructureStatus.getOrDefault(clientUUID, false);
    }
}

