/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.network.packets;

import dev.hexnowloading.dungeonnowloading.network.DNLPacket;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStopTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.platform.Services;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.AABB;

public class C2SStopTickingSoundPacket
implements DNLPacket {
    private final ResourceLocation soundId;
    private final double radius;

    public C2SStopTickingSoundPacket(ResourceLocation soundId, double radius) {
        this.soundId = soundId;
        this.radius = radius;
    }

    public C2SStopTickingSoundPacket(FriendlyByteBuf buf) {
        this.soundId = buf.m_130281_();
        this.radius = buf.readDouble();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.soundId);
        buf.writeDouble(this.radius);
    }

    public static C2SStopTickingSoundPacket decode(FriendlyByteBuf buf) {
        return new C2SStopTickingSoundPacket(buf);
    }

    @Override
    public void handle(@Nullable ServerPlayer sender) {
        if (sender == null) {
            return;
        }
        AABB area = sender.m_20191_().m_82400_(this.radius);
        List nearbyPlayers = sender.m_9236_().m_45976_(ServerPlayer.class, area);
        for (ServerPlayer player : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStopTickingSoundPacket(sender.m_19879_(), this.soundId, 20, true), player);
        }
    }
}

