/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.network.packets;

import dev.hexnowloading.dungeonnowloading.block.entity.PlayerStatueBlockEntity;
import dev.hexnowloading.dungeonnowloading.network.DNLPacket;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class C2SPedestalUpdatePacket
implements DNLPacket {
    private static final int MAX_LINES = 4;
    private static final int MAX_CHARS_PER_LINE = 16;
    private static final double MAX_EDIT_DISTANCE_SQ = 4096.0;
    private final BlockPos pos;
    private final List<Component> lines;
    private final DyeColor color;
    private final boolean glowing;

    public C2SPedestalUpdatePacket(BlockPos pos, List<Component> lines, DyeColor color, boolean glowing) {
        this.pos = pos.m_7949_();
        this.lines = C2SPedestalUpdatePacket.sanitize(lines);
        this.color = color != null ? color : DyeColor.BLACK;
        this.glowing = glowing;
    }

    public C2SPedestalUpdatePacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        int n = Math.min(buf.m_130242_(), 4);
        ArrayList<Component> tmp = new ArrayList<Component>(4);
        for (int i = 0; i < n; ++i) {
            tmp.add(buf.m_130238_());
        }
        this.lines = C2SPedestalUpdatePacket.sanitize(tmp);
        int colorId = buf.m_130242_();
        DyeColor c = DyeColor.m_41053_((int)colorId);
        this.color = c != null ? c : DyeColor.BLACK;
        this.glowing = buf.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130130_(this.lines.size());
        for (Component c : this.lines) {
            buf.m_130083_(c);
        }
        buf.m_130130_(this.color.m_41060_());
        buf.writeBoolean(this.glowing);
    }

    public static C2SPedestalUpdatePacket decode(FriendlyByteBuf buf) {
        return new C2SPedestalUpdatePacket(buf);
    }

    @Override
    public void handle(@Nullable ServerPlayer sender) {
        System.out.println("[C2S Update] recv from " + sender.m_36316_().getName() + " @ " + this.pos);
        if (sender == null) {
            return;
        }
        sender.f_8924_.execute(() -> {
            Level level = sender.m_9236_();
            if (!level.m_46749_(this.pos)) {
                return;
            }
            BlockEntity be = level.m_7702_(this.pos);
            if (!(be instanceof PlayerStatueBlockEntity)) {
                return;
            }
            PlayerStatueBlockEntity statue = (PlayerStatueBlockEntity)be;
            statue.applyTextUpdateFromClient(sender, this.lines, this.color, this.glowing);
        });
    }

    private static List<Component> sanitize(List<Component> in) {
        ArrayList<Component> out = new ArrayList<Component>(4);
        int n = Math.min(in != null ? in.size() : 0, 4);
        for (int i = 0; i < n; ++i) {
            String s;
            String string = s = in.get(i) != null ? in.get(i).getString() : "";
            if (s.length() > 16) {
                s = s.substring(0, 16);
            }
            out.add((Component)Component.m_237113_((String)s));
        }
        while (out.size() < 4) {
            out.add((Component)Component.m_237119_());
        }
        return out;
    }
}

