/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.network.packets;

import dev.hexnowloading.dungeonnowloading.block.entity.PlayerStatueBlockEntity;
import dev.hexnowloading.dungeonnowloading.network.DNLPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class C2SPedestalEditPacket
implements DNLPacket {
    private final BlockPos pos;
    private final List<Component> lines;
    private final int colorId;
    private final boolean glowing;

    public C2SPedestalEditPacket(BlockPos pos, List<Component> lines, int colorId, boolean glowing) {
        this.pos = pos;
        this.lines = List.copyOf(lines);
        this.colorId = colorId;
        this.glowing = glowing;
    }

    public C2SPedestalEditPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        int n = buf.m_130242_();
        ArrayList<Component> tmp = new ArrayList<Component>(n);
        for (int i = 0; i < n; ++i) {
            tmp.add(buf.m_130238_());
        }
        this.lines = List.copyOf(tmp);
        this.colorId = buf.m_130242_();
        this.glowing = buf.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130130_(this.lines.size());
        for (Component c : this.lines) {
            buf.m_130083_(c);
        }
        buf.m_130130_(this.colorId);
        buf.writeBoolean(this.glowing);
    }

    public static C2SPedestalEditPacket decode(FriendlyByteBuf buf) {
        return new C2SPedestalEditPacket(buf);
    }

    @Override
    public void handle(@Nullable ServerPlayer sender) {
        if (sender == null) {
            return;
        }
        Level level = sender.m_9236_();
        if (!level.m_46749_(this.pos)) {
            return;
        }
        BlockEntity be = level.m_7702_(this.pos);
        if (!(be instanceof PlayerStatueBlockEntity)) {
            return;
        }
        PlayerStatueBlockEntity statue = (PlayerStatueBlockEntity)be;
        if (sender.m_20238_(this.pos.m_252807_()) > 64.0) {
            return;
        }
        DyeColor color = this.colorId >= 0 && this.colorId < DyeColor.values().length ? DyeColor.m_41053_((int)this.colorId) : statue.getTextColor();
        statue.setAllText(this.lines, color, this.glowing);
        statue.m_6596_();
        BlockState state = statue.m_58900_();
        level.m_7260_(this.pos, state, state, 2);
    }
}

