/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.util;

import dev.hexnowloading.dungeonnowloading.entity.util.EntityScale;
import dev.hexnowloading.dungeonnowloading.util.ArmorTrimMaterial;
import dev.hexnowloading.dungeonnowloading.util.ArmorTrimPattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class SpawnMobUtil {
    public static Mob createAndSpawnEntity(EntityType<?> entityType, double x, double y, double z, Level level) {
        Mob mob = (Mob)entityType.m_20615_(level);
        SpawnMobUtil.spawnEntity(mob, x, y, z, level);
        return mob;
    }

    public static Mob spawnEntity(Mob mob, double x, double y, double z, Level level) {
        if (mob != null) {
            mob.m_7678_(x, y, z, level.f_46441_.m_188501_() * 360.0f, 0.0f);
            EntityScale.scaleMobAttributes((LivingEntity)mob);
            mob.m_21530_();
            BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(blockPos), MobSpawnType.SPAWNER, null, null);
        }
        return mob;
    }

    public static Mob spawnEntityWithRot(Mob mob, double x, double y, double z, float yRot, float xRot, Level level) {
        if (mob != null) {
            mob.m_7678_(x, y, z, yRot, xRot);
            EntityScale.scaleMobAttributes((LivingEntity)mob);
            mob.m_21530_();
            BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(blockPos), MobSpawnType.SPAWNER, null, null);
        }
        return mob;
    }

    public static Mob spawnEntityWithoutMove(Mob mob, double x, double y, double z, Level level) {
        if (mob != null) {
            EntityScale.scaleMobAttributes((LivingEntity)mob);
            mob.m_21530_();
            BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(blockPos), MobSpawnType.SPAWNER, null, null);
        }
        return mob;
    }

    public static void equipArmor(Mob mob, EquipmentSlot equipmentSlot, Item item, ArmorTrimMaterial trimMaterial, ArmorTrimPattern trimPattern) {
        SpawnMobUtil.equipArmor(mob, equipmentSlot, item, trimMaterial, trimPattern, 0.0f);
    }

    public static void equipArmor(Mob mob, EquipmentSlot equipmentSlot, Item item, ArmorTrimMaterial trimMaterial, ArmorTrimPattern trimPattern, float dropChance) {
        mob.m_8061_(equipmentSlot, SpawnMobUtil.trimArmor(item, trimMaterial, trimPattern));
        mob.m_21409_(equipmentSlot, dropChance);
    }

    private static ItemStack trimArmor(Item item, ArmorTrimMaterial trimMaterial, ArmorTrimPattern trimPattern) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_("material", "minecraft:" + trimMaterial.material);
        compoundTag.m_128359_("pattern", "minecraft:" + trimPattern.pattern);
        itemStack.m_41784_().m_128365_("Trim", (Tag)compoundTag);
        return itemStack;
    }

    public static void createPoofParticle(ServerLevel serverLevel, Entity entity) {
        double d = entity.m_20185_();
        double e = entity.m_20186_() + entity.m_20191_().m_82376_() / 2.0;
        double f = entity.m_20189_();
        int particleCount = (int)(entity.m_20191_().m_82309_() * 15.0);
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, d, e, f, particleCount, (double)(entity.m_20205_() / 2.0f), (double)(entity.m_20206_() / 2.0f), (double)(entity.m_20205_() / 2.0f), 0.0);
    }
}

