/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.hexnowloading.dungeonnowloading.entity.client.model.VertexDomainProjectileModel;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexDomainProjectileEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class VertexDomainProjectileRenderer<T extends VertexDomainProjectileEntity>
extends EntityRenderer<VertexDomainProjectileEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("dungeonnowloading", "textures/entity/vertex_domain_projectile.png");
    private static final ResourceLocation EMISSIVE = new ResourceLocation("dungeonnowloading", "textures/entity/vertex_domain_projectile_emissive.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110473_((ResourceLocation)TEXTURE);
    private static final RenderType EMISSIVE_RENDER_TYPE = RenderType.m_110473_((ResourceLocation)EMISSIVE);
    private VertexDomainProjectileModel model;

    public VertexDomainProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new VertexDomainProjectileModel(context.m_174023_(VertexDomainProjectileModel.LAYER_LOCATION));
    }

    public boolean shouldRender(VertexDomainProjectileEntity entity, Frustum frustum, double x, double y, double z) {
        return true;
    }

    public void render(VertexDomainProjectileEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(-2.0f, -2.0f, 2.0f);
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
        boolean bl = entity.getHurtTime() > 0;
        float alpha = 1.0f;
        int fadeStart = 20;
        if (entity.getLife() > 0 && entity.getLife() < fadeStart) {
            alpha = Math.max((float)entity.getLife() / (float)fadeStart, 0.0f);
        } else if (entity.getDyingTick() > 0) {
            alpha = Math.max((float)entity.getDyingTick() / (float)fadeStart, 0.0f);
        }
        VertexConsumer vertexConsumer = buffer.m_6299_(RENDER_TYPE);
        this.model.setupAnim(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, entityYaw, 0.0f);
        this.model.renderToBufferWithEntity(entity, poseStack, vertexConsumer, 0xF000F0, OverlayTexture.m_118090_((float)0.0f, (boolean)bl), 1.0f, 1.0f, 1.0f, alpha);
        float emissiveAlpha = VertexDomainProjectileRenderer.getEmissiveAlpha(entity, partialTicks);
        if (emissiveAlpha > 0.01f) {
            VertexConsumer emissiveVertexConsumer = buffer.m_6299_(EMISSIVE_RENDER_TYPE);
            this.model.renderToBufferWithEntity(entity, poseStack, emissiveVertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, emissiveAlpha);
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private static float getEmissiveAlpha(VertexDomainProjectileEntity entity, float partialTicks) {
        if (entity.getLife() <= 0) {
            return 0.2f;
        }
        float lifeProgress = (float)entity.getLife() / 1200.0f;
        float cycleTime = 40.0f;
        float time = ((float)(1200 - entity.getLife()) + partialTicks) % cycleTime;
        float pulse = 0.0f;
        if (time < 5.0f) {
            pulse = time / 5.0f;
        } else if (time < 20.0f) {
            float fadeTime = (time - 5.0f) / 15.0f;
            pulse = 1.0f - fadeTime * fadeTime;
        }
        pulse = 0.2f + 0.8f * pulse;
        return lifeProgress * pulse;
    }

    public ResourceLocation getTextureLocation(VertexDomainProjectileEntity vertexDomainProjectileEntity) {
        return TEXTURE;
    }
}

