/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.hexnowloading.dungeonnowloading.entity.boss.ChaosSpawnerEntity;
import dev.hexnowloading.dungeonnowloading.entity.client.animation.ChaosSpawnerAnimation;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ChaosSpawnerModel<T extends ChaosSpawnerEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("dungeonnowloading", "chaos_spawner"), "main");
    private final ModelPart shockwave;
    private final ModelPart body;
    private final ModelPart root;

    public ChaosSpawnerModel(ModelPart root) {
        this.root = root;
        this.shockwave = root.m_171324_("shockwave");
        this.body = root.m_171324_("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition shockwave = partdefinition.m_171599_("shockwave", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)31.0f, (float)0.0f));
        PartDefinition wave4 = shockwave.m_171599_("wave4", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-28.0f));
        PartDefinition cube_r1 = wave4.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(-8, 62).m_171488_(-11.0f, 0.0f, 20.0f, 22.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)24.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition wave3 = shockwave.m_171599_("wave3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)28.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = wave3.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(-8, 62).m_171488_(-11.0f, 0.0f, 28.0f, 22.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-32.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition wave2 = shockwave.m_171599_("wave2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-28.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = wave2.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(-8, 62).m_171488_(-15.0f, 0.0f, 24.0f, 22.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)28.0f, (float)0.0f, (float)4.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition wave1 = shockwave.m_171599_("wave1", CubeListBuilder.m_171558_().m_171514_(-8, 62).m_171488_(-11.0f, 0.0f, -4.0f, 22.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)28.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition chaos_hexahedron = body.m_171599_("chaos_hexahedron", CubeListBuilder.m_171558_().m_171514_(32, 99).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(48, 40).m_171488_(-7.6659f, -4.103f, -15.8096f, 16.0f, 4.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-10.6659f, -17.103f, -18.8096f, 22.0f, 14.0f, 22.0f, new CubeDeformation(0.0f)).m_171514_(14, 99).m_171488_(-1.6659f, -15.103f, -19.8096f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.3341f, (float)10.103f, (float)8.8096f));
        PartDefinition cube_r4 = head.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(0, 99).m_171488_(17.5f, -0.5f, -0.5f, 2.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 81).m_171488_(-17.5f, -2.5f, -2.5f, 35.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.1659f, (float)-11.603f, (float)-10.3096f, (float)0.0f, (float)-0.2182f, (float)-0.1309f));
        PartDefinition cube_r5 = head.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(0, 99).m_171488_(-1.0f, -2.5f, -2.5f, 2.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-18.241f, (float)-7.2061f, (float)-12.3612f, (float)1.5708f, (float)0.2182f, (float)3.0107f));
        PartDefinition lower_jaw = body.m_171599_("lower_jaw", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171488_(-8.0f, 0.0f, -16.0f, 16.0f, 4.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)9.0f));
        PartDefinition chain = body.m_171599_("chain", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)0.0f));
        PartDefinition cube_r6 = chain.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(0, 109).m_171488_(-5.0f, -1.5f, 0.0f, 10.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-24.3827f, (float)-17.3385f, (float)-4.8502f, (float)0.0f, (float)0.2182f, (float)3.0107f));
        PartDefinition cube_r7 = chain.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(0, 109).m_171488_(19.5f, 0.5f, 2.0f, 10.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-22.5f, (float)-1.5f, (float)0.0f, (float)-0.2182f, (float)-0.1309f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233385_(((ChaosSpawnerEntity)entity).sleepingAnimationState, ChaosSpawnerAnimation.CHAOS_SPAWNER_SLEEPING, ageInTicks, 1.0f);
        this.m_233385_(((ChaosSpawnerEntity)entity).awakeningAnimationState, ChaosSpawnerAnimation.CHAOS_SPAWNER_WAKE_UP, ageInTicks, 1.0f);
        this.m_233385_(((ChaosSpawnerEntity)entity).smashAttackAnimationState, ChaosSpawnerAnimation.CHAOS_SPAWNER_SMASH_ATTACK, ageInTicks, 1.0f);
        this.m_233385_(((ChaosSpawnerEntity)entity).rangeAttackAnimationState, ChaosSpawnerAnimation.CHAOS_SPAWNER_RANGE_ATTACK, ageInTicks, 1.0f);
        this.m_233385_(((ChaosSpawnerEntity)entity).rangeBurstAttackAnimationState, ChaosSpawnerAnimation.CHAOS_SPAWNER_RANGE_BURST_ATTACK, ageInTicks, 1.0f);
        this.m_233385_(((ChaosSpawnerEntity)entity).summonAnimationState, ChaosSpawnerAnimation.CHAOS_SPAWNER_SUMMON, ageInTicks, 1.0f);
        this.m_233385_(((ChaosSpawnerEntity)entity).deathAnimationState, ChaosSpawnerAnimation.CHAOS_SPAWNER_DEATH, ageInTicks, 1.0f);
        this.animateHeadLookTarget(netHeadYaw, headPitch);
        if (((ChaosSpawnerEntity)entity).getState() != ChaosSpawnerEntity.State.SLEEPING && ((ChaosSpawnerEntity)entity).getState() != ChaosSpawnerEntity.State.DEATH && ((ChaosSpawnerEntity)entity).getAwakeningTick() < 100) {
            this.animateIdlePose(ageInTicks);
        }
    }

    private void animateIdlePose(float ageInTicks) {
        float AGEINTICKS_TO_SECONDS = ageInTicks / 20.0f;
        float UPDOWN_OSCILLATION_SECOND = 2.0f;
        float UPDOWN_DISTANCE_PIXEL = 1.0f;
        float updownRate = UPDOWN_DISTANCE_PIXEL * Mth.m_14031_((float)(AGEINTICKS_TO_SECONDS * ((float)Math.PI * 2) / UPDOWN_OSCILLATION_SECOND));
        this.body.f_104201_ += updownRate;
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.body.f_104203_ += headPitch * ((float)Math.PI / 180);
        this.body.f_104204_ += netHeadYaw * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.shockwave.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

