/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.hexnowloading.dungeonnowloading.entity.client.model.ScuttleModel;
import dev.hexnowloading.dungeonnowloading.entity.client.renderer.ScuttleRenderer;
import dev.hexnowloading.dungeonnowloading.entity.monster.ScuttleEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class ScuttleLayer<T extends ScuttleEntity, M extends ScuttleModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation TEXTURE_EMISSIVE = new ResourceLocation("dungeonnowloading", "textures/entity/scuttle/scuttle_emissive.png");

    public ScuttleLayer(ScuttleRenderer renderer) {
        super((RenderLayerParent)renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLightIn, ScuttleEntity scuttleEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        float timeInSeconds;
        float DURATION;
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_234335_((ResourceLocation)TEXTURE_EMISSIVE, (boolean)true));
        if (scuttleEntity.isState(ScuttleEntity.ScuttleState.OPENING) && !scuttleEntity.isRenderHeating()) {
            scuttleEntity.setRenderOldTick(scuttleEntity.f_19797_);
            scuttleEntity.setRenderHeating(true);
            scuttleEntity.setRenderCooling(false);
        }
        if (scuttleEntity.isRenderHeating()) {
            DURATION = 3.0f;
            timeInSeconds = (float)(scuttleEntity.f_19797_ - scuttleEntity.getRenderOldTick()) / 20.0f;
            if (scuttleEntity.isState(ScuttleEntity.ScuttleState.OPENING) || scuttleEntity.isState(ScuttleEntity.ScuttleState.OPENED)) {
                ((ScuttleModel)this.m_117386_()).m_7695_(poseStack, vertexConsumer, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)scuttleEntity, (float)0.0f), 1.0f, 1.0f, 1.0f, timeInSeconds < DURATION ? timeInSeconds / DURATION : 1.0f);
            }
        }
        if (scuttleEntity.isState(ScuttleEntity.ScuttleState.CLOSING) && scuttleEntity.isRenderHeating()) {
            scuttleEntity.setRenderOldTick(scuttleEntity.f_19797_);
            scuttleEntity.setRenderHeating(false);
            scuttleEntity.setRenderCooling(true);
        }
        if (scuttleEntity.isRenderCooling()) {
            DURATION = 5.0f;
            timeInSeconds = (float)(scuttleEntity.f_19797_ - scuttleEntity.getRenderOldTick()) / 20.0f;
            ((ScuttleModel)this.m_117386_()).m_7695_(poseStack, vertexConsumer, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)scuttleEntity, (float)0.0f), 1.0f, 1.0f, 1.0f, timeInSeconds < DURATION ? (DURATION - timeInSeconds) / DURATION : 0.0f);
        }
    }
}

